/*
 * Decompiled with CFR 0.152.
 */
package com.platypushasnohat.tome_of_wonders.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.platypushasnohat.tome_of_wonders.TomeOfWonders;
import com.platypushasnohat.tome_of_wonders.client.models.SquillModel;
import com.platypushasnohat.tome_of_wonders.entities.Squill;
import com.platypushasnohat.tome_of_wonders.registry.TOWModelLayers;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@OnlyIn(value=Dist.CLIENT)
public class SquillRenderer
extends MobRenderer<Squill, SquillModel> {
    private static final ResourceLocation TEXTURE = TomeOfWonders.modPrefix("textures/entity/squill/squill.png");
    private static final ResourceLocation TEXTURE_AGGRO = TomeOfWonders.modPrefix("textures/entity/squill/squill_aggro.png");

    public SquillRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new SquillModel(context.m_174023_(TOWModelLayers.SQUILL)), 0.4f);
    }

    public ResourceLocation getTextureLocation(Squill entity) {
        if (entity.isAttacking()) {
            return TEXTURE_AGGRO;
        }
        return TEXTURE;
    }

    @Nullable
    protected RenderType getRenderType(Squill entity, boolean bodyVisible, boolean translucent, boolean glowing) {
        return RenderType.m_110473_((ResourceLocation)this.getTextureLocation(entity));
    }

    protected void scale(Squill entity, PoseStack poseStack, float partialTicks) {
        float alpha = 1.0f - (0.25f + 0.25f * (float)Math.sin((float)entity.f_19797_ * 0.02f)) * entity.getAlphaProgress(partialTicks);
        ((SquillModel)this.f_115290_).setAlpha(alpha);
    }

    protected void setupRotations(Squill entity, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTicks) {
        String name;
        double pulledZ;
        double pulledY;
        Vec3 pull = entity.getPull(partialTicks);
        double pulledX = Mth.m_14139_((double)partialTicks, (double)entity.f_19854_, (double)entity.m_20185_()) - pull.m_7096_();
        Vector3f lookDir = new Vector3f((float)pulledX, (float)(pulledY = Mth.m_14139_((double)partialTicks, (double)entity.f_19855_, (double)entity.m_20186_()) - pull.m_7098_()), (float)(pulledZ = Mth.m_14139_((double)partialTicks, (double)entity.f_19856_, (double)entity.m_20189_()) - pull.m_7094_()));
        if (lookDir.lengthSquared() < 1.0E-6f) {
            lookDir.set(0.0f, 0.0f, 1.0f);
        } else {
            lookDir.normalize();
        }
        Vector3f defaultForward = new Vector3f(0.0f, 0.0f, -1.0f);
        Quaternionf rotation = new Quaternionf().rotationTo((Vector3fc)defaultForward, (Vector3fc)lookDir);
        Quaternionf correction = new Quaternionf().rotateX(-1.5707964f);
        rotation.mul((Quaternionfc)correction);
        float rotationOffset = 0.2f;
        poseStack.m_252880_(0.0f, rotationOffset, 0.0f);
        poseStack.m_252781_(rotation);
        poseStack.m_252880_(0.0f, -rotationOffset, 0.0f);
        if (entity.m_8077_() && ((name = ChatFormatting.m_126649_((String)entity.m_7755_().getString())).equals("Dinnerbone") || name.equals("Grumm"))) {
            poseStack.m_85837_(0.0, (double)entity.m_20206_() + 0.1, 0.0);
            poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        }
        if (entity.isAttacking()) {
            poseStack.m_85837_(0.0, (double)entity.m_20206_() + 0.1, 0.0);
            poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        }
    }
}

