/*
 * Decompiled with CFR 0.152.
 */
package com.platypushasnohat.tome_of_wonders.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.platypushasnohat.tome_of_wonders.TomeOfWonders;
import com.platypushasnohat.tome_of_wonders.blocks.WhirligigBlock;
import com.platypushasnohat.tome_of_wonders.blocks.blockentity.WhirligigBlockEntity;
import com.platypushasnohat.tome_of_wonders.registry.TOWModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class WhirligigRenderer
implements BlockEntityRenderer<WhirligigBlockEntity> {
    public static final Material TEXTURE = new Material(TextureAtlas.f_118259_, TomeOfWonders.modPrefix("block/whirligig"));
    private final ModelPart root;
    private final ModelPart spinner;
    private final ModelPart spinner2;

    public WhirligigRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart modelPart = context.m_173582_(TOWModelLayers.WHIRLIGIG);
        this.root = modelPart.m_171324_("root");
        this.spinner = modelPart.m_171324_("spinner");
        this.spinner2 = modelPart.m_171324_("spinner2");
    }

    public static LayerDefinition createMesh() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("root", CubeListBuilder.m_171558_().m_171514_(0, 13).m_171488_(-0.5f, 0.5f, -0.625f, 1.0f, 16.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.f_171404_);
        partdefinition.m_171599_("spinner", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-6.5f, -6.5f, -0.875f, 13.0f, 13.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.f_171404_);
        partdefinition.m_171599_("spinner2", CubeListBuilder.m_171558_().m_171514_(4, 13).m_171488_(-1.5f, -1.5f, -0.625f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.2f)), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void render(WhirligigBlockEntity whirligig, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay) {
        VertexConsumer vertexConsumer = TEXTURE.m_119194_(bufferSource, RenderType::m_110452_);
        BlockState state = whirligig.m_58900_();
        WhirligigBlock block = (WhirligigBlock)state.m_60734_();
        poseStack.m_252880_(0.5f, 1.025f, 0.5f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-block.getYRotationDegrees(state)));
        poseStack.m_252781_(new Quaternionf().rotateZ((float)Math.PI));
        poseStack.m_85836_();
        this.root.m_104301_(poseStack, vertexConsumer, light, overlay);
        this.spinner2.m_104301_(poseStack, vertexConsumer, light, overlay);
        poseStack.m_85849_();
        poseStack.m_85836_();
        float h = whirligig.getActiveRotation(partialTicks) * 57.295776f;
        poseStack.m_252781_(new Quaternionf().rotateZ(h * ((float)Math.PI / 180)));
        this.spinner.m_104301_(poseStack, vertexConsumer, light, overlay);
        poseStack.m_85849_();
    }

    public int m_142163_() {
        return 256;
    }
}

