/*
 * Decompiled with CFR 0.152.
 */
package com.platypushasnohat.tome_of_wonders.data;

import com.platypushasnohat.tome_of_wonders.TomeOfWondersTab;
import com.platypushasnohat.tome_of_wonders.registry.TOWBlocks;
import com.platypushasnohat.tome_of_wonders.registry.TOWEntities;
import com.platypushasnohat.tome_of_wonders.registry.TOWItems;
import com.platypushasnohat.tome_of_wonders.registry.TOWPaintings;
import com.platypushasnohat.tome_of_wonders.registry.TOWPotions;
import com.platypushasnohat.tome_of_wonders.registry.TOWSoundEvents;
import com.platypushasnohat.tome_of_wonders.utils.TOWTextUtils;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.text.WordUtils;

public class TOWLanguageProvider
extends LanguageProvider {
    public TOWLanguageProvider(GatherDataEvent event) {
        super(event.getGenerator().getPackOutput(), "tome_of_wonders", "en_us");
    }

    protected void addTranslations() {
        this.addTab((CreativeModeTab)TomeOfWondersTab.TOME_OF_WONDERS_TAB.get(), "Tome of Wonders");
        TOWItems.AUTO_TRANSLATE.forEach(this::forItems);
        TOWBlocks.AUTO_TRANSLATE.forEach(this::forBlocks);
        TOWPaintings.PAINTING_TRANSLATIONS.forEach(this::painting);
        this.addItem((Supplier)TOWItems.RAW_BAITFISH, "Raw Baitfish");
        this.addItem((Supplier)TOWItems.FLYING_FISH_BUCKET, "Bucket of Flying Fish");
        this.addItem((Supplier)TOWItems.SQUILL_BUCKET, "Bucket of Squill");
        this.addItem((Supplier)TOWItems.BAITFISH_BUCKET, "Bucket of Baitfish");
        this.forEntity((Supplier<? extends EntityType<?>>)TOWEntities.BAITFISH);
        this.forEntity((Supplier<? extends EntityType<?>>)TOWEntities.FLYING_FISH);
        this.forEntity((Supplier<? extends EntityType<?>>)TOWEntities.SQUILL);
        this.sound((Supplier<? extends SoundEvent>)TOWSoundEvents.FISH_DEATH, "Fish dies");
        this.sound((Supplier<? extends SoundEvent>)TOWSoundEvents.FISH_HURT, "Fish hurts");
        this.sound((Supplier<? extends SoundEvent>)TOWSoundEvents.FISH_FLOP, "Fish flops");
        this.sound((Supplier<? extends SoundEvent>)TOWSoundEvents.SQUILL_DEATH, "Squill dies");
        this.sound((Supplier<? extends SoundEvent>)TOWSoundEvents.SQUILL_HURT, "Squill hurts");
        this.sound((Supplier<? extends SoundEvent>)TOWSoundEvents.SQUILL_SQUIRT, "Squill squirts");
        this.sound((Supplier<? extends SoundEvent>)TOWSoundEvents.SQUILL_CHATTER, "Squill chatters");
        this.potion((Supplier<? extends Potion>)TOWPotions.LEVITATION_POTION, "Levitation", "levitation");
    }

    public String m_6055_() {
        return "tome_of_wonders Languages: en_us";
    }

    private void forBlocks(Supplier<? extends Block> block) {
        this.addBlock(block, TOWTextUtils.createTranslation(Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block.get())).m_135815_()));
    }

    private void forItems(Supplier<? extends Item> item) {
        this.addItem(item, TOWTextUtils.createTranslation(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item.get())).m_135815_()));
    }

    private void forEntity(Supplier<? extends EntityType<?>> entity) {
        this.addEntityType(entity, TOWTextUtils.createTranslation(Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey(entity.get())).m_135815_()));
    }

    public void sound(Supplier<? extends SoundEvent> key, String subtitle) {
        this.add("subtitles.shifted_lens." + key.get().m_11660_().m_135815_(), subtitle);
    }

    private void addEnchantmentWithDesc(Enchantment enchantment, String description) {
        String name = ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment).m_135815_();
        this.add(enchantment, this.formatEnchantment(name));
        this.add(enchantment.m_44704_() + ".desc", description);
    }

    private String formatEnchantment(String path) {
        return WordUtils.capitalizeFully((String)path.replace("_", " ")).replace("Of ", "of ");
    }

    public void potion(Supplier<? extends Potion> key, String name, String regName) {
        this.potions(key.get(), name, regName);
    }

    public void potions(Potion key, String name, String regName) {
        this.add("item.minecraft.potion.effect." + regName, "Potion of " + name);
        this.add("item.minecraft.splash_potion.effect." + regName, "Splash Potion of " + name);
        this.add("item.minecraft.lingering_potion.effect." + regName, "Lingering Potion of " + name);
        this.add("item.minecraft.tipped_arrow.effect." + regName, "Arrow of " + name);
    }

    protected void painting(String name, String author) {
        this.add("painting.tome_of_wonders." + name + ".title", TOWTextUtils.createTranslation(name));
        this.add("painting.tome_of_wonders." + name + ".author", author);
    }

    public void addTab(CreativeModeTab key, String name) {
        this.add(key.m_40786_().getString(), name);
    }

    public void addAdvancement(String key, String name) {
        this.add("advancement.tome_of_wonders." + key, name);
    }

    public void addAdvancementDesc(String key, String name) {
        this.add("advancement.tome_of_wonders." + key + ".desc", name);
    }
}

