/*
 * Decompiled with CFR 0.152.
 */
package com.platypushasnohat.tome_of_wonders.entities;

import com.platypushasnohat.tome_of_wonders.TomeOfWondersConfig;
import com.platypushasnohat.tome_of_wonders.entities.ai.goals.CustomRandomSwimGoal;
import com.platypushasnohat.tome_of_wonders.registry.TOWEntities;
import com.platypushasnohat.tome_of_wonders.registry.TOWItems;
import com.platypushasnohat.tome_of_wonders.registry.TOWSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FollowFlockLeaderGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Baitfish
extends AbstractSchoolingFish {
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(Baitfish.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final AnimationState flopAnimationState = new AnimationState();
    public final AnimationState swimmingAnimationState = new AnimationState();
    public float prevOnLandProgress;
    public float onLandProgress;

    public Baitfish(EntityType<? extends AbstractSchoolingFish> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 1000, 5, 0.02f, 0.1f, false);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 4);
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level level) {
        return new WaterBoundPathNavigation((Mob)this, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 1.6, 1.4, EntitySelector.f_20408_::test));
        this.f_21345_.m_25352_(1, (Goal)new CustomRandomSwimGoal((PathfinderMob)this, 1.0, 1, 16, 16, 3));
        this.f_21345_.m_25352_(4, (Goal)new FollowFlockLeaderGoal((AbstractSchoolingFish)this));
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 2.0).m_22268_(Attributes.f_22279_, 1.0);
    }

    @NotNull
    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)TOWItems.BAITFISH_BUCKET.get());
    }

    public void m_7023_(@NotNull Vec3 travelVec) {
        if (this.m_21515_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), travelVec);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
        } else {
            super.m_7023_(travelVec);
        }
    }

    public void m_8107_() {
        boolean onLand;
        super.m_8107_();
        this.prevOnLandProgress = this.onLandProgress;
        boolean bl = onLand = !this.m_20072_();
        if (onLand && this.onLandProgress < 5.0f) {
            this.onLandProgress += 1.0f;
        }
        if (!onLand && this.onLandProgress > 0.0f) {
            this.onLandProgress -= 1.0f;
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            this.setupAnimationStates();
        }
    }

    private void setupAnimationStates() {
        this.flopAnimationState.m_246184_(!this.m_20072_(), this.f_19797_);
        this.swimmingAnimationState.m_246184_(this.m_20072_(), this.f_19797_);
    }

    public void m_267651_(boolean flying) {
        float f1 = (float)Mth.m_184648_((double)(this.m_20185_() - this.f_19854_), (double)(this.m_20186_() - this.f_19855_), (double)(this.m_20189_() - this.f_19856_));
        float f2 = Math.min(f1 * 10.0f, 1.0f);
        this.f_267362_.m_267566_(f2, 0.4f);
    }

    public static boolean canSpawn(EntityType<Baitfish> entityType, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return WaterAnimal.m_218282_(entityType, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
    }

    public void m_7380_(@NotNull CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("Variant", this.getVariant());
    }

    public void m_7378_(@NotNull CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setVariant(compoundTag.m_128451_("Variant"));
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    protected float m_6431_(@NotNull Pose pose, EntityDimensions size) {
        return size.f_20378_ * 0.5f;
    }

    public int m_6031_() {
        return 72;
    }

    @Nullable
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag compoundTag) {
        int schoolCount;
        this.setVariant(this.m_9236_().m_213780_().m_188503_(1));
        if ((spawnType == MobSpawnType.CHUNK_GENERATION || spawnType == MobSpawnType.NATURAL) && ((Boolean)TomeOfWondersConfig.BAITFISH_SCHOOL_SPAWNING.get()).booleanValue() && (schoolCount = (int)((float)this.m_6031_() * this.m_217043_().m_188501_())) > 0 && !this.m_9236_().m_5776_()) {
            for (int i = 0; i < schoolCount; ++i) {
                float distance = 1.5f;
                Baitfish entity = new Baitfish((EntityType<? extends AbstractSchoolingFish>)((EntityType)TOWEntities.BAITFISH.get()), this.m_9236_());
                entity.setVariant(this.getVariant());
                entity.m_6027_(this.m_20185_() + (double)(this.m_217043_().m_188501_() * distance), this.m_20186_() + (double)(this.m_217043_().m_188501_() * distance), this.m_20189_() + (double)(this.m_217043_().m_188501_() * distance));
                entity.m_27525_(this);
                this.m_9236_().m_7967_((Entity)entity);
            }
        }
        return super.m_6518_(level, difficulty, spawnType, spawnData, compoundTag);
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)TOWSoundEvents.FISH_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource source) {
        return (SoundEvent)TOWSoundEvents.FISH_HURT.get();
    }

    @NotNull
    protected SoundEvent m_5699_() {
        return (SoundEvent)TOWSoundEvents.FISH_FLOP.get();
    }
}

