/*
 * Decompiled with CFR 0.152.
 */
package com.platypushasnohat.tome_of_wonders.entities;

import com.platypushasnohat.tome_of_wonders.TomeOfWondersConfig;
import com.platypushasnohat.tome_of_wonders.entities.ai.goals.CustomRandomSwimGoal;
import com.platypushasnohat.tome_of_wonders.entities.ai.goals.FlyingFishFollowLeaderGoal;
import com.platypushasnohat.tome_of_wonders.entities.ai.goals.FlyingFishGlideGoal;
import com.platypushasnohat.tome_of_wonders.registry.TOWEntities;
import com.platypushasnohat.tome_of_wonders.registry.TOWItems;
import com.platypushasnohat.tome_of_wonders.registry.TOWSoundEvents;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlyingFish
extends WaterAnimal
implements FlyingAnimal,
Bucketable {
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(FlyingFish.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> GLIDING = SynchedEntityData.m_135353_(FlyingFish.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(FlyingFish.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final AnimationState flopAnimationState = new AnimationState();
    public final AnimationState glidingAnimationState = new AnimationState();
    public final AnimationState swimmingAnimationState = new AnimationState();
    public int glideCooldown = this.f_19796_.m_188503_(1600) + 180;
    public float prevOnLandProgress;
    public float onLandProgress;
    @Nullable
    public FlyingFish leader;
    private int schoolSize = 1;

    public FlyingFish(EntityType<? extends WaterAnimal> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 1000, 10, 0.02f, 0.1f, true);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 10);
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level level) {
        return new WaterBoundPathNavigation((Mob)this, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 4.0).m_22268_(Attributes.f_22279_, (double)1.1f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(1, (Goal)new FlyingFishGlideGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 1.6, 1.4, EntitySelector.f_20408_::test));
        this.f_21345_.m_25352_(3, (Goal)new CustomRandomSwimGoal((PathfinderMob)this, 1.0, 1, 16, 8, 3));
        this.f_21345_.m_25352_(4, (Goal)new FlyingFishFollowLeaderGoal(this));
    }

    public void m_7023_(@NotNull Vec3 travelVec) {
        if (this.m_21515_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), travelVec);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(travelVec);
        }
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        boolean hurt = super.m_6469_(source, amount);
        if (hurt && source.m_7639_() != null) {
            this.glideCooldown = 0;
            List list = this.m_9236_().m_45976_(((Object)((Object)this)).getClass(), this.m_20191_().m_82377_(8.0, 7.0, 8.0));
            for (FlyingFish entity : list) {
                entity.glideCooldown = 0;
            }
        }
        return hurt;
    }

    @NotNull
    protected InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        return Bucketable.m_148828_((Player)player, (InteractionHand)hand, (LivingEntity)this).orElse(super.m_6071_(player, hand));
    }

    public void m_6872_(@NotNull ItemStack stack) {
        Bucketable.m_148822_((Mob)this, (ItemStack)stack);
    }

    public void m_142278_(@NotNull CompoundTag compoundTag) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)compoundTag);
    }

    @NotNull
    public ItemStack m_28282_() {
        return ((Item)TOWItems.FLYING_FISH_BUCKET.get()).m_7968_();
    }

    @NotNull
    public SoundEvent m_142623_() {
        return SoundEvents.f_11782_;
    }

    public boolean m_142535_(float fallDistance, float multiplier, @NotNull DamageSource source) {
        return false;
    }

    protected void m_7840_(double y, boolean onGround, @NotNull BlockState state, @NotNull BlockPos pos) {
    }

    public void m_8119_() {
        List list;
        super.m_8119_();
        if (this.hasFollowers() && this.m_9236_().f_46441_.m_188503_(200) == 1 && (list = this.m_9236_().m_45976_(((Object)((Object)this)).getClass(), this.m_20191_().m_82377_(8.0, 8.0, 8.0))).size() <= 1) {
            this.schoolSize = 1;
        }
        if (this.isGliding() && !this.m_20072_() && this.m_20184_().f_82480_ < 0.0) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, (double)0.55f, 1.0));
        }
        if (this.leader != null) {
            this.glideCooldown = this.leader.glideCooldown;
        }
        if (this.glideCooldown > 0) {
            --this.glideCooldown;
        }
        if (this.m_9236_().f_46443_) {
            this.setupAnimationStates();
        }
    }

    private void setupAnimationStates() {
        this.flopAnimationState.m_246184_(!this.isGliding() && !this.m_20072_(), this.f_19797_);
        this.glidingAnimationState.m_246184_(this.isGliding() && !this.m_20072_(), this.f_19797_);
        this.swimmingAnimationState.m_246184_(this.m_20072_(), this.f_19797_);
    }

    public void m_267651_(boolean flying) {
        float f1 = (float)Mth.m_184648_((double)(this.m_20185_() - this.f_19854_), (double)(this.m_20186_() - this.f_19855_), (double)(this.m_20189_() - this.f_19856_));
        float f2 = Math.min(f1 * 10.0f, 1.0f);
        this.f_267362_.m_267566_(f2, 0.4f);
    }

    public void m_8107_() {
        boolean onLand;
        this.prevOnLandProgress = this.onLandProgress;
        boolean bl = onLand = !this.m_20072_() && this.m_20096_();
        if (onLand && this.onLandProgress < 5.0f) {
            this.onLandProgress += 1.0f;
        }
        if (!onLand && this.onLandProgress > 0.0f) {
            this.onLandProgress -= 1.0f;
        }
        if (!this.m_20072_() && this.m_6084_() && this.m_20096_() && this.f_19796_.m_188501_() < 0.1f) {
            this.m_20256_(this.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.2f), 0.5, (double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.2f)));
            this.m_5496_(this.getFlopSound(), this.m_6121_(), this.m_6100_());
        }
        super.m_8107_();
    }

    public int m_5792_() {
        return this.getMaxSchoolSize();
    }

    public int getMaxSchoolSize() {
        return 12;
    }

    public boolean isFollower() {
        return this.leader != null && this.leader.m_6084_();
    }

    public void startFollowing(FlyingFish fish) {
        this.leader = fish;
        fish.addFollower();
    }

    public void stopFollowing() {
        this.leader.removeFollower();
        this.leader = null;
    }

    private void addFollower() {
        ++this.schoolSize;
    }

    private void removeFollower() {
        --this.schoolSize;
    }

    public boolean canBeFollowed() {
        return this.hasFollowers() && this.schoolSize < this.getMaxSchoolSize();
    }

    public boolean hasFollowers() {
        return this.schoolSize > 1;
    }

    public boolean inRangeOfLeader() {
        return this.m_20280_((Entity)this.leader) <= 121.0;
    }

    public void pathToLeader() {
        if (this.isFollower()) {
            this.m_21573_().m_5624_((Entity)this.leader, 1.0);
        }
    }

    public void addFollowers(Stream<? extends FlyingFish> entity) {
        entity.limit(this.getMaxSchoolSize() - this.schoolSize).filter(fish -> fish != this).forEach(fish1 -> fish1.startFollowing(this));
    }

    public static boolean canSpawn(EntityType<FlyingFish> entityType, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return WaterAnimal.m_218282_(entityType, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(GLIDING, (Object)false);
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
    }

    public void m_7380_(@NotNull CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("Variant", this.getVariant());
        compoundTag.m_128379_("FromBucket", this.m_27487_());
    }

    public void m_7378_(@NotNull CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setVariant(compoundTag.m_128451_("Variant"));
        this.m_27497_(compoundTag.m_128471_("FromBucket"));
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public boolean isGliding() {
        return (Boolean)this.f_19804_.m_135370_(GLIDING);
    }

    public void setGliding(boolean flying) {
        this.f_19804_.m_135381_(GLIDING, (Object)flying);
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean fromBucket) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)fromBucket);
    }

    protected float m_6431_(@NotNull Pose pose, EntityDimensions size) {
        return size.f_20378_ * 0.5f;
    }

    @Nullable
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag compoundTag) {
        int schoolCount;
        this.setVariant(this.m_9236_().m_213780_().m_188503_(1));
        if ((spawnType == MobSpawnType.CHUNK_GENERATION || spawnType == MobSpawnType.NATURAL) && ((Boolean)TomeOfWondersConfig.FLYING_FISH_SCHOOL_SPAWNING.get()).booleanValue() && (schoolCount = (int)((float)this.getMaxSchoolSize() * this.m_217043_().m_188501_())) > 0 && !this.m_9236_().m_5776_()) {
            for (int i = 0; i < schoolCount; ++i) {
                float distance = 1.5f;
                FlyingFish entity = new FlyingFish((EntityType<? extends WaterAnimal>)((EntityType)TOWEntities.FLYING_FISH.get()), this.m_9236_());
                entity.setVariant(this.getVariant());
                entity.m_6027_(this.m_20185_() + (double)(this.m_217043_().m_188501_() * distance), this.m_20186_() + (double)(this.m_217043_().m_188501_() * distance), this.m_20189_() + (double)(this.m_217043_().m_188501_() * distance));
                entity.startFollowing(this);
                entity.glideCooldown = this.glideCooldown;
                this.m_9236_().m_7967_((Entity)entity);
            }
        }
        return super.m_6518_(level, difficulty, spawnType, spawnData, compoundTag);
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)TOWSoundEvents.FISH_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource source) {
        return (SoundEvent)TOWSoundEvents.FISH_HURT.get();
    }

    @NotNull
    protected SoundEvent getFlopSound() {
        return (SoundEvent)TOWSoundEvents.FISH_FLOP.get();
    }

    public boolean m_29443_() {
        return true;
    }
}

