/*
 * Decompiled with CFR 0.152.
 */
package com.platypushasnohat.tome_of_wonders.entities;

import com.platypushasnohat.tome_of_wonders.TomeOfWondersConfig;
import com.platypushasnohat.tome_of_wonders.entities.ai.goals.SquillAttackGoal;
import com.platypushasnohat.tome_of_wonders.entities.ai.goals.SquillPanicGoal;
import com.platypushasnohat.tome_of_wonders.entities.ai.goals.SquillWanderGoal;
import com.platypushasnohat.tome_of_wonders.entities.ai.utils.SquillMoveControl;
import com.platypushasnohat.tome_of_wonders.registry.TOWEntities;
import com.platypushasnohat.tome_of_wonders.registry.TOWItems;
import com.platypushasnohat.tome_of_wonders.registry.TOWParticles;
import com.platypushasnohat.tome_of_wonders.registry.TOWSoundEvents;
import com.platypushasnohat.tome_of_wonders.registry.tags.TOWEntityTags;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Squill
extends PathfinderMob
implements FlyingAnimal,
Bucketable {
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(Squill.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(Squill.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> COMBAT_COOLDOWN = SynchedEntityData.m_135353_(Squill.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private Vec3 prevPull = Vec3.f_82478_;
    private Vec3 pull = Vec3.f_82478_;
    private float alphaProgress;
    private float prevAlphaProgress;
    public float xBodyRot;
    public float xBodyRotO;
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState aggroAnimationState = new AnimationState();

    public Squill(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new SquillMoveControl(this);
        this.f_21364_ = 5;
        this.m_21530_();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, (double)0.17f).m_22268_(Attributes.f_22280_, (double)0.17f).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22277_, 64.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new SquillPanicGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new SquillAttackGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new SquillWanderGoal(this));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 20, true, false, entity -> entity.m_6095_().m_204039_(TOWEntityTags.SQUILL_TARGETS)));
    }

    public boolean m_6147_() {
        return false;
    }

    protected void m_7355_(@NotNull BlockPos pos, @NotNull BlockState state) {
    }

    public boolean m_142535_(float fallDistance, float multiplier, @NotNull DamageSource source) {
        return false;
    }

    protected void m_7840_(double y, boolean onGround, @NotNull BlockState state, @NotNull BlockPos pos) {
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level level) {
        FlyingPathNavigation navigation = new FlyingPathNavigation((Mob)this, level){

            public boolean m_6342_(BlockPos pos) {
                return !Squill.this.m_9236_().m_8055_(pos.m_6625_(128)).m_60795_();
            }
        };
        navigation.m_26440_(false);
        navigation.m_7008_(false);
        navigation.m_26443_(true);
        return navigation;
    }

    public void m_7023_(@NotNull Vec3 travelVector) {
        if (this.m_21515_()) {
            this.m_19920_(0.1f, travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.8));
        } else {
            super.m_7023_(travelVector);
        }
    }

    private Vec3 rotateVector(Vec3 vec3) {
        Vec3 vec31 = vec3.m_82496_(this.xBodyRotO * ((float)Math.PI / 180));
        return vec31.m_82524_(-this.f_20884_ * ((float)Math.PI / 180));
    }

    private void spawnInk() {
        for (LivingEntity entity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(2.25, 2.25, 2.25))) {
            if (entity instanceof Squill) continue;
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 40));
        }
        this.m_5496_((SoundEvent)TOWSoundEvents.SQUILL_SQUIRT.get(), this.m_6121_(), this.m_6100_());
        Vec3 vec3 = this.rotateVector(new Vec3(0.0, 0.0, 0.0)).m_82520_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        for (int i = 0; i < 30; ++i) {
            Vec3 vec31 = this.rotateVector(new Vec3((double)this.f_19796_.m_188501_() * 0.6 - 0.3, -1.0, (double)this.f_19796_.m_188501_() * 0.6 - 0.3));
            Vec3 vec32 = vec31.m_82490_(0.3 + (double)(this.f_19796_.m_188501_() * 2.0f));
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)((SimpleParticleType)TOWParticles.WHIRLIWIND.get()), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0, vec32.f_82479_, vec32.f_82480_, vec32.f_82481_, (double)0.1f);
        }
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        if (super.m_6469_(source, amount) && this.m_21188_() != null) {
            if (!this.m_9236_().f_46443_) {
                if (this.m_21223_() <= this.m_21233_() * 0.25f && this.getCombatCooldown() <= 0) {
                    this.combatCooldown();
                }
                if (this.getCombatCooldown() > 0 && !this.isAttacking()) {
                    this.spawnInk();
                }
            }
            return true;
        }
        return false;
    }

    public boolean m_29443_() {
        return true;
    }

    public boolean m_20068_() {
        return true;
    }

    public void updatePull(Vec3 pos) {
        this.prevPull = this.pull = pos.m_82492_(0.0, 1.0, 0.0);
    }

    public static Vec3 lerp(Vec3 prev, Vec3 current, float ptc) {
        return prev.m_82549_(current.m_82546_(prev).m_82490_((double)ptc));
    }

    public Vec3 getPull(float partialTicks) {
        return Squill.lerp(this.prevPull, this.pull, partialTicks);
    }

    public int m_5792_() {
        return 48;
    }

    public void m_8119_() {
        super.m_8119_();
        this.xBodyRotO = this.xBodyRot;
        this.prevAlphaProgress = this.alphaProgress;
        if (this.m_6084_() && this.alphaProgress < 20.0f) {
            this.alphaProgress += 1.0f;
        }
        if (!this.m_6084_() && this.alphaProgress > 0.0f) {
            this.alphaProgress -= 1.0f;
        }
        if (this.getCombatCooldown() > 0) {
            this.setCombatCooldown(this.getCombatCooldown() - 1);
        }
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
            this.prevPull = this.pull;
            Vec3 pos = this.m_20182_();
            this.pull = pos.m_82549_(this.pull.m_82546_(pos).m_82541_().m_82490_(0.25));
        }
        Vec3 vec3 = this.m_20184_();
        double d0 = vec3.m_165924_();
        this.xBodyRot += (-((float)Mth.m_14136_((double)d0, (double)vec3.f_82480_)) * 57.295776f - this.xBodyRot) * 0.1f;
    }

    public void setupAnimationStates() {
        this.idleAnimationState.m_246184_(!this.isAttacking(), this.f_19797_);
        this.aggroAnimationState.m_246184_(this.isAttacking(), this.f_19797_);
    }

    public void m_267651_(boolean flying) {
        float f1 = (float)Mth.m_184648_((double)(this.m_20185_() - this.f_19854_), (double)(this.m_20186_() - this.f_19855_), (double)(this.m_20189_() - this.f_19856_));
        float f2 = Math.min(f1 * 10.0f, 1.0f);
        this.f_267362_.m_267566_(f2, 0.4f);
    }

    public float getAlphaProgress(float partialTicks) {
        return (this.prevAlphaProgress + (this.alphaProgress - this.prevAlphaProgress) * partialTicks) * 0.05f;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
        this.f_19804_.m_135372_(COMBAT_COOLDOWN, (Object)0);
    }

    public void m_7380_(@NotNull CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128379_("Attacking", this.isAttacking());
        compoundTag.m_128379_("FromBucket", this.m_27487_());
        compoundTag.m_128405_("CombatCooldown", this.getCombatCooldown());
    }

    public void m_7378_(@NotNull CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setAttacking(compoundTag.m_128471_("Attacking"));
        this.m_27497_(compoundTag.m_128471_("FromBucket"));
        this.setCombatCooldown(compoundTag.m_128451_("CombatCooldown"));
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
    }

    public int getCombatCooldown() {
        return (Integer)this.f_19804_.m_135370_(COMBAT_COOLDOWN);
    }

    public void setCombatCooldown(int cooldown) {
        this.f_19804_.m_135381_(COMBAT_COOLDOWN, (Object)cooldown);
    }

    public void combatCooldown() {
        this.f_19804_.m_135381_(COMBAT_COOLDOWN, (Object)(60 + this.f_19796_.m_188503_(80)));
    }

    @NotNull
    public AABB m_6921_() {
        return this.m_20191_().m_82377_(3.0, 3.0, 3.0);
    }

    public boolean m_6783_(double distance) {
        return Math.sqrt(distance) < 1024.0;
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean fromBucket) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)fromBucket);
    }

    public void m_6872_(@NotNull ItemStack stack) {
        Bucketable.m_148822_((Mob)this, (ItemStack)stack);
        if (this.m_8077_()) {
            stack.m_41714_(this.m_7770_());
        }
    }

    public void m_142278_(@NotNull CompoundTag compoundTag) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)compoundTag);
    }

    @NotNull
    public ItemStack m_28282_() {
        return ((Item)TOWItems.SQUILL_BUCKET.get()).m_7968_();
    }

    @NotNull
    public SoundEvent m_142623_() {
        return SoundEvents.f_11782_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)TOWSoundEvents.SQUILL_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource source) {
        return (SoundEvent)TOWSoundEvents.SQUILL_HURT.get();
    }

    @NotNull
    protected InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41720_() == Items.f_42446_ && this.m_6084_()) {
            this.m_146850_(GameEvent.f_223708_);
            this.m_5496_(this.m_142623_(), 1.0f, 1.0f);
            ItemStack itemstack1 = this.m_28282_();
            this.m_6872_(itemstack1);
            ItemStack itemstack2 = ItemUtils.m_41817_((ItemStack)itemstack, (Player)player, (ItemStack)itemstack1, (boolean)false);
            player.m_21008_(hand, itemstack2);
            if (!this.m_9236_().f_46443_) {
                CriteriaTriggers.f_10576_.m_38772_((ServerPlayer)player, itemstack1);
            }
            this.m_146870_();
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    public static boolean canSpawn(EntityType<Squill> entityType, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Squill.m_217057_(entityType, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random) && Squill.wholeHitboxCanSeeSky(level, pos, 2) && random.m_188501_() < 0.2f;
    }

    public static boolean wholeHitboxCanSeeSky(LevelAccessor level, BlockPos pos, int hitboxRadius) {
        boolean flag = true;
        for (int xOffset = -hitboxRadius; xOffset <= hitboxRadius; ++xOffset) {
            for (int zOffset = -hitboxRadius; zOffset <= hitboxRadius; ++zOffset) {
                flag = flag && level.m_45527_(pos.m_7918_(xOffset, 0, zOffset));
            }
        }
        return flag;
    }

    @Nullable
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag compoundTag) {
        int spawnHeight = Math.min(this.m_20183_().m_123342_() + (Integer)TomeOfWondersConfig.SQUILL_SPAWN_HEIGHT.get(), this.m_9236_().m_151558_());
        if (spawnType == MobSpawnType.NATURAL || spawnType == MobSpawnType.CHUNK_GENERATION) {
            this.m_7678_(this.m_20185_(), spawnHeight, this.m_20189_(), this.m_146908_(), this.m_146909_());
            if (((Boolean)TomeOfWondersConfig.SQUILL_SCHOOL_SPAWNING.get()).booleanValue()) {
                this.spawnSchool();
            }
        }
        return super.m_6518_(level, difficulty, spawnType, spawnData, compoundTag);
    }

    private void spawnSchool() {
        int schoolCount = (int)(20.0f * this.m_217043_().m_188501_());
        if (schoolCount > 0 && !this.m_9236_().m_5776_()) {
            for (int i = 0; i < schoolCount; ++i) {
                float distance = 1.5f;
                Squill entity = new Squill((EntityType<? extends PathfinderMob>)((EntityType)TOWEntities.SQUILL.get()), this.m_9236_());
                entity.m_6027_(this.m_20185_() + (double)(this.m_217043_().m_188501_() * distance), this.m_20186_() + (double)(this.m_217043_().m_188501_() * distance), this.m_20189_() + (double)(this.m_217043_().m_188501_() * distance));
                this.m_9236_().m_7967_((Entity)entity);
            }
        }
    }
}

