/*
 * Decompiled with CFR 0.152.
 */
package com.platypushasnohat.tome_of_wonders.entities.ai.goals;

import com.platypushasnohat.tome_of_wonders.entities.FlyingFish;
import java.util.EnumSet;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class FlyingFishGlideGoal
extends Goal {
    private final FlyingFish fish;
    private BlockPos surfacePos;

    public FlyingFishGlideGoal(FlyingFish fish) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        this.fish = fish;
    }

    public boolean m_8036_() {
        BlockPos surfacePos;
        if (!this.fish.m_20072_()) {
            return false;
        }
        if (this.fish.glideCooldown == 0 && (surfacePos = this.findSurfacePos()) != null) {
            this.surfacePos = surfacePos;
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        return this.surfacePos != null && (!this.fish.m_20096_() || this.fish.m_20072_());
    }

    public void m_8041_() {
        this.fish.setGliding(false);
        this.fish.glideCooldown = this.fish.m_217043_().m_188503_(1600) + 180;
        this.surfacePos = null;
    }

    public void m_8037_() {
        if (this.fish.m_20072_() && this.fish.m_20238_(Vec3.m_82512_((Vec3i)this.surfacePos)) > 3.0) {
            this.fish.m_21573_().m_26519_((double)((float)this.surfacePos.m_123341_() + 0.5f), (double)((float)this.surfacePos.m_123342_() + 1.0f), (double)((float)this.surfacePos.m_123343_() + 0.5f), (double)1.4f);
            if (this.fish.isGliding()) {
                this.m_8041_();
            }
        } else {
            this.fish.m_21573_().m_26573_();
            double y = 0.0;
            if (!this.fish.isGliding()) {
                y = 1.0f + this.fish.m_217043_().m_188501_() * 0.2f;
            } else if (this.fish.isGliding() && this.fish.m_20072_()) {
                this.m_8041_();
            }
            Direction direction = this.fish.leader != null && this.fish.m_20069_() && !this.fish.isGliding() ? this.fish.leader.m_6374_() : this.fish.m_6374_();
            Vec3 movement = new Vec3((double)direction.m_122429_(), 0.0, (double)direction.m_122431_()).m_82541_().m_82490_((double)0.4f);
            Vec3 glide = new Vec3(movement.f_82479_, y, movement.f_82481_);
            this.fish.m_20256_(glide);
            this.fish.m_146922_((float)Mth.m_14136_((double)this.fish.m_6374_().m_122431_(), (double)this.fish.m_6374_().m_122429_()) * 57.295776f - 90.0f);
            this.fish.f_19859_ = (float)Mth.m_14136_((double)this.fish.m_6374_().m_122431_(), (double)this.fish.m_6374_().m_122429_()) * 57.295776f - 90.0f;
            this.fish.f_20883_ = (float)Mth.m_14136_((double)this.fish.m_6374_().m_122431_(), (double)this.fish.m_6374_().m_122429_()) * 57.295776f - 90.0f;
            this.fish.f_20885_ = (float)Mth.m_14136_((double)this.fish.m_6374_().m_122431_(), (double)this.fish.m_6374_().m_122429_()) * 57.295776f - 90.0f;
            this.fish.setGliding(true);
        }
    }

    private BlockPos findSurfacePos() {
        BlockPos fishPos = Objects.requireNonNullElse(this.fish.leader, this.fish).m_20183_();
        for (int i = 0; i < 15; ++i) {
            BlockPos offset = fishPos.m_7918_(this.fish.m_217043_().m_188503_(16) - 8, 0, this.fish.m_217043_().m_188503_(16) - 8);
            while (this.fish.m_9236_().m_46801_(offset) && offset.m_123342_() < this.fish.m_9236_().m_151558_()) {
                offset = offset.m_7494_();
            }
            if (this.fish.m_9236_().m_46801_(offset) || !this.fish.m_9236_().m_46801_(offset.m_7495_()) || !this.canSeeBlock(offset)) continue;
            return offset;
        }
        return null;
    }

    private boolean canSeeBlock(BlockPos destinationBlock) {
        Vec3 Vector3d = new Vec3(this.fish.m_20185_(), this.fish.m_20188_(), this.fish.m_20189_());
        Vec3 blockVec = Vec3.m_82512_((Vec3i)destinationBlock);
        BlockHitResult result = this.fish.m_9236_().m_45547_(new ClipContext(Vector3d, blockVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.fish));
        return result.m_82425_().equals((Object)destinationBlock);
    }
}

