/*
 * Decompiled with CFR 0.152.
 */
package com.platypushasnohat.tome_of_wonders.entities.ai.goals;

import com.platypushasnohat.tome_of_wonders.entities.Squill;
import java.util.EnumSet;
import java.util.Objects;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class SquillAttackGoal
extends Goal {
    private final Squill squill;
    private Vec3 startOrbitFrom;
    private int orbitTime;
    private int maxOrbitTime;
    private int attackTime;

    public SquillAttackGoal(Squill entity) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        this.squill = entity;
    }

    public void m_8056_() {
        this.orbitTime = 0;
        this.maxOrbitTime = 80;
        this.startOrbitFrom = null;
        this.squill.setAttacking(false);
    }

    public void m_8041_() {
        LivingEntity target = this.squill.m_5448_();
        if (!EntitySelector.f_20406_.test(target)) {
            this.squill.m_6710_(null);
        }
        this.squill.m_21561_(false);
        this.squill.setAttacking(false);
        this.squill.m_21573_().m_26573_();
    }

    public boolean m_8036_() {
        LivingEntity target = this.squill.m_5448_();
        return target != null && target.m_6084_() && !this.squill.m_20159_() && this.squill.getCombatCooldown() <= 0;
    }

    public boolean m_8045_() {
        LivingEntity target = this.squill.m_5448_();
        if (target == null) {
            return false;
        }
        if (!target.m_6084_()) {
            return false;
        }
        if (!this.squill.m_21444_(target.m_20183_())) {
            return false;
        }
        if (this.squill.getCombatCooldown() > 0) {
            return false;
        }
        return !(target instanceof Player) || !target.m_5833_() && !((Player)target).m_7500_() || !this.squill.m_21573_().m_26571_();
    }

    public void m_8037_() {
        LivingEntity target = this.squill.m_5448_();
        if (target != null && target.m_6084_()) {
            double distance = this.squill.m_20270_((Entity)target);
            if (this.startOrbitFrom == null) {
                this.squill.m_21573_().m_5624_((Entity)target, 4.0);
                this.squill.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
            } else if (this.orbitTime < this.maxOrbitTime) {
                ++this.orbitTime;
                float zoomIn = 1.0f - (float)this.orbitTime / (float)this.maxOrbitTime;
                Vec3 orbitPos = this.orbitAroundPos(3.0f + zoomIn * 5.0f).m_82520_(0.0, (double)(4.0f + zoomIn * 3.0f), 0.0);
                this.squill.m_21573_().m_26519_(orbitPos.f_82479_, orbitPos.f_82480_, orbitPos.f_82481_, 3.0);
                this.squill.m_7618_(EntityAnchorArgument.Anchor.EYES, orbitPos);
            } else {
                this.orbitTime = 0;
                this.startOrbitFrom = null;
            }
            if (distance <= 16.0 && this.orbitTime <= 0) {
                this.tickAttack();
            }
        }
    }

    protected void tickAttack() {
        ++this.attackTime;
        LivingEntity target = this.squill.m_5448_();
        double distance = this.squill.m_20270_((Entity)target);
        float attackReach = this.squill.m_20205_() + target.m_20205_();
        this.squill.setAttacking(true);
        if (this.attackTime <= 4) {
            this.squill.m_21573_().m_26573_();
            this.squill.m_21391_((Entity)Objects.requireNonNull(target), 360.0f, 360.0f);
            this.squill.m_21563_().m_24960_((Entity)target, 360.0f, 360.0f);
        }
        if (this.attackTime > 8 && this.attackTime <= 32) {
            if (distance < (double)attackReach + 0.5) {
                this.squill.m_7327_((Entity)target);
                this.squill.m_6674_(InteractionHand.MAIN_HAND);
                this.maxOrbitTime = 40 + this.squill.m_217043_().m_188503_(60);
                this.startOrbitFrom = target.m_146892_();
                this.attackTime = 0;
                this.squill.setAttacking(false);
            }
        } else if (this.attackTime > 32) {
            this.maxOrbitTime = 40 + this.squill.m_217043_().m_188503_(60);
            this.startOrbitFrom = target.m_146892_();
            this.attackTime = 0;
            this.squill.setAttacking(false);
        }
    }

    public Vec3 orbitAroundPos(float circleDistance) {
        float angle = 3.0f * (float)Math.toRadians((float)this.orbitTime * 3.0f);
        double extraX = circleDistance * Mth.m_14031_((float)angle);
        double extraZ = circleDistance * Mth.m_14089_((float)angle);
        return this.startOrbitFrom.m_82520_(extraX, 0.0, extraZ);
    }
}

