/*
 * Decompiled with CFR 0.152.
 */
package com.platypushasnohat.tome_of_wonders.registry;

import com.platypushasnohat.tome_of_wonders.blocks.WhirliboxBlock;
import com.platypushasnohat.tome_of_wonders.blocks.WhirligigBlock;
import com.platypushasnohat.tome_of_wonders.registry.TOWItems;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class TOWBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"tome_of_wonders");
    public static List<RegistryObject<? extends Block>> AUTO_TRANSLATE = new ArrayList<RegistryObject<? extends Block>>();
    public static final RegistryObject<Block> WHIRLIGIG = TOWBlocks.registerBlock("whirligig", () -> new WhirligigBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_280658_(NoteBlockInstrument.HARP).m_280606_().m_60910_().m_60955_().m_60978_(1.0f).m_60918_(SoundType.f_56754_)));
    public static final RegistryObject<Block> WHIRLIBOX = TOWBlocks.registerBlock("whirlibox", () -> new WhirliboxBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_280658_(NoteBlockInstrument.HARP).m_60999_().m_60978_(3.5f)));

    private static <B extends Block> RegistryObject<B> registerBlock(String name, Supplier<? extends B> supplier) {
        RegistryObject block = BLOCKS.register(name, supplier);
        TOWItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        AUTO_TRANSLATE.add((RegistryObject<? extends Block>)block);
        return block;
    }

    private static <B extends Block> RegistryObject<B> registerBlockNoLang(String name, Supplier<? extends B> supplier) {
        RegistryObject block = BLOCKS.register(name, supplier);
        TOWItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        return block;
    }

    private static <B extends Block> RegistryObject<B> registerBlockWithoutItem(String name, Supplier<? extends B> supplier) {
        RegistryObject block = BLOCKS.register(name, supplier);
        AUTO_TRANSLATE.add((RegistryObject<? extends Block>)block);
        return block;
    }

    private static <B extends Block> RegistryObject<B> registerBlockWithoutItemNoLang(String name, Supplier<? extends B> supplier) {
        return BLOCKS.register(name, supplier);
    }

    private static <B extends Block> Supplier<B> registerBlockWithItem(String name, Supplier<B> block, Function<Supplier<B>, Item> item) {
        RegistryObject entry = TOWBlocks.registerBlockWithoutItem(name, block);
        TOWItems.ITEMS.register(name, () -> (Item)item.apply((Supplier)entry));
        return entry;
    }

    private static BlockBehaviour.Properties registerFlowerPot(FeatureFlag ... featureFlags) {
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_284310_().m_60966_().m_60955_().m_278166_(PushReaction.DESTROY);
        if (featureFlags.length > 0) {
            properties = properties.m_246843_(featureFlags);
        }
        return properties;
    }
}

