/*
 * Decompiled with CFR 0.152.
 */
package com.platypushasnohat.tome_of_wonders.registry;

import com.platypushasnohat.tome_of_wonders.items.LollipopItem;
import com.platypushasnohat.tome_of_wonders.items.SquillBucketItem;
import com.platypushasnohat.tome_of_wonders.items.TOWMobBucketItem;
import com.platypushasnohat.tome_of_wonders.items.ToothedSnowballItem;
import com.platypushasnohat.tome_of_wonders.items.WhirlicapItem;
import com.platypushasnohat.tome_of_wonders.registry.TOWEntities;
import com.platypushasnohat.tome_of_wonders.registry.TOWFoodValues;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class TOWItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"tome_of_wonders");
    public static List<RegistryObject<? extends Item>> AUTO_TRANSLATE = new ArrayList<RegistryObject<? extends Item>>();
    public static final RegistryObject<Item> SQUILL_TOOTH = TOWItems.registerItem("squill_tooth", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> TOOTHED_SNOWBALL = TOWItems.registerItem("toothed_snowball", () -> new ToothedSnowballItem(new Item.Properties().m_41487_(16)));
    public static final RegistryObject<Item> WHIRLICAP = TOWItems.registerItem("whirlicap", () -> new WhirlicapItem(new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> LOLLIPOP = TOWItems.registerItem("lollipop", () -> new LollipopItem(TOWItems.foodItem(TOWFoodValues.LOLLIPOP).m_41487_(1)));
    public static final RegistryObject<Item> RAW_BAITFISH = TOWItems.registerItemNoLang("baitfish", () -> new Item(TOWItems.foodItem(TOWFoodValues.RAW_BAITFISH)));
    public static final RegistryObject<Item> COOKED_BAITFISH = TOWItems.registerItem("cooked_baitfish", () -> new Item(TOWItems.foodItem(TOWFoodValues.COOKED_BAITFISH)));
    public static final RegistryObject<Item> BAITFISH_BUCKET = TOWItems.registerItemNoLang("baitfish_bucket", () -> new TOWMobBucketItem((Supplier<? extends EntityType<?>>)TOWEntities.BAITFISH, (Fluid)Fluids.f_76193_, new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> FLYING_FISH = TOWItems.registerItem("flying_fish", () -> new Item(TOWItems.foodItem(TOWFoodValues.FLYING_FISH)));
    public static final RegistryObject<Item> FLYING_FISH_BUCKET = TOWItems.registerItemNoLang("flying_fish_bucket", () -> new TOWMobBucketItem((Supplier<? extends EntityType<?>>)TOWEntities.FLYING_FISH, (Fluid)Fluids.f_76193_, new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> SQUILL_BUCKET = TOWItems.registerItemNoLang("squill_bucket", () -> new SquillBucketItem(new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> BAITFISH_SPAWN_EGG = TOWItems.registerSpawnEggItem("baitfish", TOWEntities.BAITFISH, 0xE0E0E0, 0x757575);
    public static final RegistryObject<Item> FLYING_FISH_SPAWN_EGG = TOWItems.registerSpawnEggItem("flying_fish", TOWEntities.FLYING_FISH, 1342389, 16769243);
    public static final RegistryObject<Item> SQUILL_SPAWN_EGG = TOWItems.registerSpawnEggItem("squill", TOWEntities.SQUILL, 14809086, 9814231);

    private static <I extends Item> RegistryObject<I> registerItem(String name, Supplier<? extends I> supplier) {
        RegistryObject item = ITEMS.register(name, supplier);
        AUTO_TRANSLATE.add((RegistryObject<? extends Item>)item);
        return item;
    }

    private static <I extends Item> RegistryObject<I> registerItemNoLang(String name, Supplier<? extends I> supplier) {
        RegistryObject item = ITEMS.register(name, supplier);
        return item;
    }

    private static RegistryObject<Item> registerSpawnEggItem(String name, RegistryObject type, int baseColor, int spotColor) {
        return TOWItems.registerItem(name + "_spawn_egg", () -> new ForgeSpawnEggItem((Supplier)type, baseColor, spotColor, new Item.Properties()));
    }

    public static Item.Properties foodItem(FoodProperties food) {
        return new Item.Properties().m_41489_(food);
    }
}

