/*
 * Decompiled with CFR 0.152.
 */
package net.lugo.utools.util;

import org.apache.commons.lang3.function.TriFunction;

public enum Easing {
    LINEAR((TriFunction<Float, Float, Float, Float>)((TriFunction)(start, end, x) -> {
        float difference = end.floatValue() - start.floatValue();
        return Float.valueOf(start.floatValue() + difference * x.floatValue());
    })),
    INSTANT((TriFunction<Float, Float, Float, Float>)((TriFunction)(start, end, x) -> end)),
    EASE_OUT_EXPONENTIAL((TriFunction<Float, Float, Float, Float>)((TriFunction)(start, end, x) -> {
        float ease = x.floatValue() >= 1.0f ? 1.0f : (float)(1.0 - Math.pow(2.0, -10.0f * x.floatValue()));
        return (Float)Easing.LINEAR.function.apply(start, end, (Object)Float.valueOf(ease));
    })),
    EASE_OUT_SINE((TriFunction<Float, Float, Float, Float>)((TriFunction)(start, end, x) -> {
        float ease = (float)Math.sin((double)x.floatValue() * Math.PI / 2.0);
        return (Float)Easing.LINEAR.function.apply(start, end, (Object)Float.valueOf(ease));
    })),
    EASE_OUT_BACK((TriFunction<Float, Float, Float, Float>)((TriFunction)(start, end, x) -> {
        float c1 = 1.70158f;
        float c3 = c1 + 1.0f;
        float ease = (float)(1.0 + (double)c3 * Math.pow(x.floatValue() - 1.0f, 3.0) + (double)c1 * Math.pow(x.floatValue() - 1.0f, 2.0));
        return (Float)Easing.LINEAR.function.apply(start, end, (Object)Float.valueOf(ease));
    }));

    public final TriFunction<Float, Float, Float, Float> function;

    private Easing(TriFunction<Float, Float, Float, Float> function) {
        this.function = function;
    }
}

