/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.enchantmentmachine.block;

import com.mojang.serialization.MapCodec;
import de.cheaterpaul.enchantmentmachine.block.EnchantmentBaseBlock;
import de.cheaterpaul.enchantmentmachine.block.StorageBlock;
import de.cheaterpaul.enchantmentmachine.block.entity.DisenchanterBlockEntity;
import de.cheaterpaul.enchantmentmachine.core.ModData;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class DisenchanterBlock
extends EnchantmentBaseBlock {
    protected static final VoxelShape SHAPE = DisenchanterBlock.makeShape();
    private static final MapCodec<DisenchanterBlock> CODEC = DisenchanterBlock.simpleCodec(DisenchanterBlock::new);

    public DisenchanterBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public BlockEntity newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return ((BlockEntityType)ModData.disenchanter_tile.get()).create(pos, state);
    }

    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHitResult) {
        BlockEntity tile = pLevel.getBlockEntity(pPos);
        if (tile instanceof DisenchanterBlockEntity) {
            pPlayer.openMenu((MenuProvider)((DisenchanterBlockEntity)tile));
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state1, boolean p_60519_) {
        if (!state.is(state1.getBlock())) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof DisenchanterBlockEntity) {
                DisenchanterBlockEntity entity = (DisenchanterBlockEntity)blockEntity;
                Containers.dropContents((Level)level, (BlockPos)pos, (Container)entity);
            }
            level.updateNeighbourForOutputSignal(pos, (Block)this);
            super.onRemove(state, level, pos, state1, p_60519_);
        }
    }

    public void appendHoverText(@NotNull ItemStack itemStack, @Nullable Item.TooltipContext context, @NotNull List<Component> tooltips, @NotNull TooltipFlag flag) {
        super.appendHoverText(itemStack, context, tooltips, flag);
        tooltips.add((Component)Component.translatable((String)"text.enchantmentmachine.next_to_storage_block", (Object[])new Object[]{((StorageBlock)((Object)ModData.storage_block.get())).getName()}).withStyle(ChatFormatting.GRAY));
    }

    @Nonnull
    public VoxelShape getShape(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@Nonnull Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> type) {
        return DisenchanterBlock.createStorageTicker(level, type, (BlockEntityType<? extends DisenchanterBlockEntity>)((BlockEntityType)ModData.disenchanter_tile.get()));
    }

    protected static <T extends BlockEntity> BlockEntityTicker<T> createStorageTicker(Level level, BlockEntityType<T> type, BlockEntityType<? extends DisenchanterBlockEntity> tile) {
        return level.isClientSide ? null : DisenchanterBlock.createTickerHelper(type, tile, DisenchanterBlockEntity::serverTick);
    }

    public static VoxelShape makeShape() {
        VoxelShape a = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
        VoxelShape a1 = Block.box((double)5.0, (double)11.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0);
        VoxelShape a2 = Block.box((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)11.0, (double)10.0);
        VoxelShape a3 = Block.box((double)7.0, (double)9.0, (double)7.0, (double)9.0, (double)10.0, (double)9.0);
        a1 = Shapes.or((VoxelShape)a1, (VoxelShape[])new VoxelShape[]{a2, a3});
        VoxelShape b = Block.box((double)3.0, (double)12.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0);
        VoxelShape b1 = Block.box((double)4.0, (double)12.0, (double)4.0, (double)12.0, (double)13.0, (double)12.0);
        VoxelShape c = Block.box((double)2.0, (double)13.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);
        VoxelShape c1 = Block.box((double)3.0, (double)13.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0);
        VoxelShape d = Block.box((double)1.0, (double)14.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
        VoxelShape d1 = Block.box((double)2.0, (double)14.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0);
        VoxelShape e = Block.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape e1 = Block.box((double)1.0, (double)15.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
        a = Shapes.joinUnoptimized((VoxelShape)a, (VoxelShape)a1, (first, second) -> first & !second || !first & second);
        b = Shapes.joinUnoptimized((VoxelShape)b, (VoxelShape)b1, (first, second) -> first & !second || !first & second);
        c = Shapes.joinUnoptimized((VoxelShape)c, (VoxelShape)c1, (first, second) -> first & !second || !first & second);
        d = Shapes.joinUnoptimized((VoxelShape)d, (VoxelShape)d1, (first, second) -> first & !second || !first & second);
        e = Shapes.joinUnoptimized((VoxelShape)e, (VoxelShape)e1, (first, second) -> first & !second || !first & second);
        return Shapes.or((VoxelShape)a, (VoxelShape[])new VoxelShape[]{b, c, d, e});
    }
}

