/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.enchantmentmachine.block;

import com.mojang.serialization.MapCodec;
import de.cheaterpaul.enchantmentmachine.block.EnchantmentBaseBlock;
import de.cheaterpaul.enchantmentmachine.block.StorageBlock;
import de.cheaterpaul.enchantmentmachine.block.entity.EnchanterBlockEntity;
import de.cheaterpaul.enchantmentmachine.block.entity.StorageBlockEntity;
import de.cheaterpaul.enchantmentmachine.core.ModData;
import de.cheaterpaul.enchantmentmachine.network.message.EnchantmentPacket;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class EnchanterBlock
extends EnchantmentBaseBlock {
    protected static final VoxelShape SHAPE = EnchanterBlock.makeShape();
    private static final MapCodec<EnchanterBlock> CODEC = EnchanterBlock.simpleCodec(EnchanterBlock::new);

    public EnchanterBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public boolean useShapeForLightOcclusion(@Nonnull BlockState state) {
        return true;
    }

    public BlockEntity newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return ((BlockEntityType)ModData.enchanter_tile.get()).create(pos, state);
    }

    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHitResult) {
        BlockEntity tile = pLevel.getBlockEntity(pPos);
        if (tile instanceof EnchanterBlockEntity) {
            pPlayer.openMenu((MenuProvider)((EnchanterBlockEntity)tile));
            if (!pLevel.isClientSide() && pPlayer instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
                Optional<StorageBlockEntity> s = ((EnchanterBlockEntity)tile).getConnectedEnchantmentTE();
                s.ifPresent(enchantmentTileEntity -> serverPlayer.connection.send((CustomPacketPayload)new EnchantmentPacket(enchantmentTileEntity.getEnchantments(), false)));
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    public void appendHoverText(@NotNull ItemStack itemStack, @Nullable Item.TooltipContext context, @NotNull List<Component> tooltips, @NotNull TooltipFlag flag) {
        super.appendHoverText(itemStack, context, tooltips, flag);
        tooltips.add((Component)Component.translatable((String)"text.enchantmentmachine.next_to_storage_block", (Object[])new Object[]{((StorageBlock)((Object)ModData.storage_block.get())).getName()}).withStyle(ChatFormatting.GRAY));
    }

    @Nonnull
    public VoxelShape getShape(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE;
    }

    public static VoxelShape makeShape() {
        VoxelShape a = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
        VoxelShape b = Block.box((double)2.0, (double)12.0, (double)2.0, (double)7.0, (double)15.0, (double)5.0);
        VoxelShape c = Block.box((double)9.0, (double)12.0, (double)11.0, (double)14.0, (double)15.0, (double)14.0);
        VoxelShape d = Block.box((double)4.0, (double)13.0, (double)5.0, (double)5.0, (double)14.0, (double)11.0);
        VoxelShape e = Block.box((double)11.0, (double)13.0, (double)5.0, (double)12.0, (double)14.0, (double)11.0);
        return Shapes.or((VoxelShape)a, (VoxelShape[])new VoxelShape[]{b, c, d, e});
    }
}

