/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.enchantmentmachine.block.entity;

import de.cheaterpaul.enchantmentmachine.block.entity.EnchantmentBaseBlockEntity;
import de.cheaterpaul.enchantmentmachine.core.ModConfig;
import de.cheaterpaul.enchantmentmachine.core.ModData;
import de.cheaterpaul.enchantmentmachine.inventory.DisenchanterContainerMenu;
import de.cheaterpaul.enchantmentmachine.util.EnchantmentInstanceMod;
import de.cheaterpaul.enchantmentmachine.util.Utils;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.Hopper;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class DisenchanterBlockEntity
extends EnchantmentBaseBlockEntity
implements WorldlyContainer,
Hopper {
    private static final Component name = Utils.genTranslation("tile", "disenchanter.name");
    private static final int DURATION = 20;
    private NonNullList<ItemStack> inventory = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
    private int timer;
    private int transferCooldown;

    public DisenchanterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModData.disenchanter_tile.get(), pos, state);
    }

    @Nonnull
    protected Component getDefaultName() {
        return name;
    }

    @Nonnull
    protected AbstractContainerMenu createMenu(int i, @Nonnull Inventory playerInventory) {
        return new DisenchanterContainerMenu(i, (Container)this, playerInventory);
    }

    public int getContainerSize() {
        return this.inventory.size();
    }

    public boolean isEmpty() {
        return this.inventory.isEmpty();
    }

    @Nonnull
    public ItemStack getItem(int i) {
        return (ItemStack)this.inventory.get(i);
    }

    @Nonnull
    public ItemStack removeItem(int i, int i1) {
        ItemStack result = ContainerHelper.removeItem(this.inventory, (int)i, (int)i1);
        this.setTimer();
        return result;
    }

    @Nonnull
    public ItemStack removeItemNoUpdate(int i) {
        ItemStack stack = ContainerHelper.takeItem(this.inventory, (int)i);
        this.setTimer();
        return stack;
    }

    public void setItem(int i, @Nonnull ItemStack itemStack) {
        this.inventory.set(i, (Object)itemStack);
        if (itemStack.getCount() > this.getMaxStackSize()) {
            itemStack.setCount(this.getMaxStackSize());
        }
        this.setTimer();
    }

    protected NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    protected void setItems(NonNullList<ItemStack> nonNullList) {
        this.inventory = nonNullList;
    }

    private void setTimer() {
        this.timer = !this.getItem(0).isEmpty() && (this.getItem(1).isEmpty() || ItemStack.isSameItem((ItemStack)this.resultItem(this.getItem(0)), (ItemStack)this.getItem(1)) && this.getItem(1).getCount() + 1 <= this.getItem(1).getMaxStackSize()) ? 20 : 0;
    }

    private ItemStack resultItem(ItemStack stack) {
        ItemEnchantments.Mutable remainingEnchantments = this.getRemainingEnchantments(stack);
        if (stack.getItem() instanceof EnchantedBookItem && remainingEnchantments.keySet().isEmpty()) {
            return new ItemStack((ItemLike)Items.BOOK);
        }
        stack = stack.copy();
        EnchantmentHelper.setEnchantments((ItemStack)stack, (ItemEnchantments)remainingEnchantments.toImmutable());
        return stack;
    }

    private ItemEnchantments.Mutable getRemainingEnchantments(ItemStack stack) {
        ItemEnchantments allEnchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack);
        boolean allowCurses = (Boolean)ModConfig.SERVER.allowDisenchantingCurses.get();
        Set<ResourceLocation> disallowedEnchantments = ModConfig.SERVER.getDisallowedDisenchantingEnchantments();
        ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(allEnchantments);
        mutable.removeIf(holder -> !disallowedEnchantments.contains(holder.getKey().location()) && (allowCurses || !holder.is(EnchantmentTags.CURSE)));
        return mutable;
    }

    private ItemEnchantments.Mutable getExtractedEnchantments(ItemStack stack) {
        ItemEnchantments allEnchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack);
        ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(allEnchantments);
        boolean allowCurses = (Boolean)ModConfig.SERVER.allowDisenchantingCurses.get();
        Set<ResourceLocation> disallowedEnchantments = ModConfig.SERVER.getDisallowedDisenchantingEnchantments();
        mutable.removeIf(entry -> disallowedEnchantments.contains(entry.getKey().location()) || !allowCurses && entry.is(EnchantmentTags.CURSE));
        return mutable;
    }

    public void clearContent() {
        this.inventory.clear();
    }

    public double getLevelX() {
        return (double)this.worldPosition.getX() + 0.5;
    }

    @Nonnull
    public int[] getSlotsForFace(@Nonnull Direction side) {
        if (side == Direction.DOWN) {
            return new int[]{1};
        }
        return new int[]{0};
    }

    public boolean canPlaceItem(int index, @Nonnull ItemStack stack) {
        if (index == 0) {
            DataComponentType componentType = EnchantmentHelper.getComponentType((ItemStack)stack);
            if (((Boolean)ModConfig.SERVER.allowDisenchantingItems.get()).booleanValue() || componentType == DataComponents.STORED_ENCHANTMENTS) {
                ItemEnchantments allEnchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack);
                return (Boolean)ModConfig.SERVER.allowDisenchantingCurses.get() != false || allEnchantments.entrySet().stream().noneMatch(s -> ((Holder)s.getKey()).is(EnchantmentTags.CURSE));
            }
        }
        return false;
    }

    public boolean canPlaceItemThroughFace(int index, @Nonnull ItemStack itemStackIn, @Nullable Direction direction) {
        return index == 0 && this.canPlaceItem(index, itemStackIn);
    }

    public boolean canTakeItemThroughFace(int index, @Nonnull ItemStack stack, @Nonnull Direction direction) {
        return index == 1;
    }

    @Override
    public void loadAdditional(@Nonnull CompoundTag nbt, HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        this.inventory.clear();
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.inventory, (HolderLookup.Provider)provider);
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        ContainerHelper.saveAllItems((CompoundTag)compound, this.inventory, (HolderLookup.Provider)provider);
    }

    @Nonnull
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, provider);
        return tag;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider provider) {
        this.loadAdditional(pkt.getTag(), provider);
    }

    public double getLevelY() {
        return (double)this.worldPosition.getY() + 0.5;
    }

    public double getLevelZ() {
        return (double)this.worldPosition.getZ() + 0.5;
    }

    public boolean isGridAligned() {
        return false;
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState state, DisenchanterBlockEntity entity) {
        if (entity.timer > 0 && entity.hasConnectedTE() && --entity.timer == 0) {
            entity.getConnectedEnchantmentTE().ifPresent(te -> {
                ItemStack stack = (ItemStack)entity.inventory.get(0);
                if (entity.canDisenchant(stack)) {
                    ItemEnchantments.Mutable map = entity.getExtractedEnchantments(stack);
                    map.keySet().forEach(e -> te.addEnchantment(new EnchantmentInstanceMod((Holder<Enchantment>)e, map.getLevel(e))));
                    stack = entity.resultItem(stack);
                    ItemStack slot = entity.getItem(1);
                    if (!slot.isEmpty() && slot.is(stack.getItem())) {
                        stack.shrink(-slot.getCount());
                    }
                    entity.setItem(1, stack);
                    entity.setItem(0, ItemStack.EMPTY);
                }
            });
        }
        if (entity.level != null) {
            --entity.transferCooldown;
            if (entity.transferCooldown <= 0) {
                entity.transferCooldown = 0;
                if (HopperBlockEntity.suckInItems((Level)level, (Hopper)entity)) {
                    entity.transferCooldown = 0;
                }
            }
        }
    }

    private boolean canDisenchant(ItemStack stack) {
        DataComponentType componentType = EnchantmentHelper.getComponentType((ItemStack)stack);
        if (componentType == DataComponents.ENCHANTMENTS) {
            ItemEnchantments extractedEnchantments;
            if (((Boolean)ModConfig.SERVER.allowDisenchantingItems.get()).booleanValue() && !(extractedEnchantments = this.getExtractedEnchantments(stack).toImmutable()).isEmpty()) {
                return ((ItemStack)this.inventory.get(1)).isEmpty() || (Boolean)ModConfig.SERVER.allowDisenchantingCurses.get() != false || extractedEnchantments.keySet().stream().noneMatch(s -> s.is(EnchantmentTags.CURSE));
            }
            return false;
        }
        return !((ItemEnchantments)stack.getOrDefault(componentType, (Object)ItemEnchantments.EMPTY)).isEmpty();
    }
}

