/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.enchantmentmachine.block.entity;

import de.cheaterpaul.enchantmentmachine.block.entity.EnchantmentBaseBlockEntity;
import de.cheaterpaul.enchantmentmachine.block.entity.StorageBlockEntity;
import de.cheaterpaul.enchantmentmachine.core.ModData;
import de.cheaterpaul.enchantmentmachine.inventory.EnchanterContainerMenu;
import de.cheaterpaul.enchantmentmachine.util.EnchantmentInstanceMod;
import de.cheaterpaul.enchantmentmachine.util.Utils;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class EnchanterBlockEntity
extends EnchantmentBaseBlockEntity {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Component name = Utils.genTranslation("tile", "enchanter.name");
    private NonNullList<ItemStack> inventory = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);

    public EnchanterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModData.enchanter_tile.get(), pos, state);
    }

    @Nonnull
    protected Component getDefaultName() {
        return name;
    }

    @NotNull
    protected NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    protected void setItems(@NotNull NonNullList<ItemStack> nonNullList) {
        this.inventory = nonNullList;
    }

    @Nonnull
    protected AbstractContainerMenu createMenu(int i, @Nonnull Inventory playerInventory) {
        return new EnchanterContainerMenu(i, (Container)this, playerInventory, ContainerLevelAccess.create((Level)this.level, (BlockPos)this.worldPosition));
    }

    public int getContainerSize() {
        return this.inventory.size();
    }

    public boolean isEmpty() {
        for (ItemStack item : this.inventory) {
            if (item.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public ItemStack getItem(int i) {
        return (ItemStack)this.inventory.get(i);
    }

    @Nonnull
    public ItemStack removeItem(int i, int i1) {
        return ContainerHelper.removeItem(this.inventory, (int)i, (int)i1);
    }

    @Nonnull
    public ItemStack removeItemNoUpdate(int i) {
        return ContainerHelper.takeItem(this.inventory, (int)i);
    }

    public void setItem(int i, @Nonnull ItemStack itemStack) {
        this.inventory.set(i, (Object)itemStack);
        if (itemStack.getCount() > this.getMaxStackSize()) {
            itemStack.setCount(this.getMaxStackSize());
        }
    }

    public void clearContent() {
        this.inventory.clear();
    }

    public boolean executeEnchantments(Player user, List<EnchantmentInstanceMod> enchantments) {
        if (this.getConnectedEnchantmentTE().isEmpty()) {
            return false;
        }
        ItemStack stack = (ItemStack)this.inventory.get(0);
        if (stack.isEmpty()) {
            return false;
        }
        stack = stack.getItem().applyEnchantments(stack, Collections.emptyList());
        DataComponentType type = EnchantmentHelper.getComponentType((ItemStack)stack);
        ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack));
        StorageBlockEntity te = this.getConnectedEnchantmentTE().get();
        int requiredLevels = 0;
        for (EnchantmentInstanceMod enchInst : enchantments) {
            if (!te.hasEnchantment(enchInst)) {
                LOGGER.warn("Enchantment {} requested but not available", (Object)enchInst);
                return false;
            }
            if (type != DataComponents.STORED_ENCHANTMENTS && !stack.is(enchInst.getEnchantment().definition().supportedItems())) {
                LOGGER.warn("Enchantment {} cannot be applied to {}", (Object)enchInst.getEnchantment(), (Object)stack);
                return false;
            }
            int levelCost = Utils.tryApplyEnchantment(enchInst, mutable, true);
            if (levelCost == -1) {
                return false;
            }
            requiredLevels += levelCost;
        }
        if (!user.getAbilities().instabuild) {
            if (user.experienceLevel < requiredLevels) {
                LOGGER.warn("Not enough levels to enchant {} {}", (Object)requiredLevels, (Object)user.experienceLevel);
                return false;
            }
            user.giveExperienceLevels(-requiredLevels);
        }
        stack.set(type, (Object)mutable.toImmutable());
        enchantments.forEach(te::consumeEnchantment);
        this.inventory.set(0, (Object)stack);
        return true;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, pRegistries);
        return tag;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, pkt, lookupProvider);
    }
}

