/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.enchantmentmachine.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import de.cheaterpaul.enchantmentmachine.core.ModData;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModDataGenerator {
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        generator.addProvider(event.includeClient(), (DataProvider)new BlockStateGenerator(packOutput, event.getExistingFileHelper()));
        generator.addProvider(event.includeClient(), (DataProvider)new ItemModelGenerator(packOutput, event.getExistingFileHelper()));
        generator.addProvider(event.includeServer(), (DataProvider)new ModLootTableProvider(packOutput, event.getLookupProvider()));
        generator.addProvider(event.includeServer(), (DataProvider)new RecipeGenerator(packOutput, event.getLookupProvider()));
        generator.addProvider(event.includeServer(), (DataProvider)new ModBlockTagsProvider(packOutput, event.getLookupProvider(), event.getExistingFileHelper()));
    }

    public static class BlockStateGenerator
    extends BlockStateProvider {
        public BlockStateGenerator(PackOutput packOutput, ExistingFileHelper exFileHelper) {
            super(packOutput, "enchantmentmachine", exFileHelper);
        }

        protected void registerStatesAndModels() {
            ModelFile.ExistingModelFile enchanter = new ModelFile.ExistingModelFile(this.blockTexture((Block)ModData.enchanter_block.get()), this.models().existingFileHelper);
            ModelBuilder enchantment_block = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(BuiltInRegistries.BLOCK.getKey((Object)((Block)ModData.storage_block.get())).toString(), "block/enchanting_table")).texture("particle", ResourceLocation.fromNamespaceAndPath((String)"enchantmentmachine", (String)"block/enchanting_table_bottom"))).texture("top", ResourceLocation.fromNamespaceAndPath((String)"enchantmentmachine", (String)"block/enchanting_table_top"))).texture("side", ResourceLocation.fromNamespaceAndPath((String)"enchantmentmachine", (String)"block/enchanting_table_side"))).texture("bottom", ResourceLocation.fromNamespaceAndPath((String)"enchantmentmachine", (String)"block/enchanting_table_bottom"))).renderType(ResourceLocation.withDefaultNamespace((String)"cutout"));
            ModelFile.ExistingModelFile disenchanter = new ModelFile.ExistingModelFile(this.blockTexture((Block)ModData.disenchanter_block.get()), this.models().existingFileHelper);
            this.simpleBlock((Block)ModData.enchanter_block.get(), (ModelFile)enchanter);
            this.simpleBlock((Block)ModData.disenchanter_block.get(), (ModelFile)disenchanter);
            this.simpleBlock((Block)ModData.storage_block.get(), (ModelFile)enchantment_block);
        }
    }

    public static class ItemModelGenerator
    extends ItemModelProvider {
        public ItemModelGenerator(PackOutput output, ExistingFileHelper existingFileHelper) {
            super(output, "enchantmentmachine", existingFileHelper);
        }

        protected void registerModels() {
            ((ItemModelBuilder)this.getBuilder(ModData.enchanter_block.getId().toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("enchantmentmachine:block/" + ModData.enchanter_block.getId().getPath()));
            ((ItemModelBuilder)this.getBuilder(ModData.disenchanter_block.getId().toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("enchantmentmachine:block/" + ModData.disenchanter_block.getId().getPath()));
            ((ItemModelBuilder)this.getBuilder(ModData.storage_block.getId().toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("enchantmentmachine:block/" + ModData.storage_block.getId().getPath()));
        }
    }

    private static class ModLootTableProvider
    extends LootTableProvider {
        public ModLootTableProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> pRegistries) {
            super(packOutput, Collections.emptySet(), (List)ImmutableList.of((Object)new LootTableProvider.SubProviderEntry(Tables::new, LootContextParamSets.BLOCK)), pRegistries);
        }

        private static class Tables
        extends BlockLootSubProvider {
            protected Tables(HolderLookup.Provider provider) {
                super(Collections.emptySet(), FeatureFlags.REGISTRY.allFlags(), provider);
            }

            protected void generate() {
                this.dropSelf((Block)ModData.disenchanter_block.get());
                this.dropSelf((Block)ModData.enchanter_block.get());
                this.dropSelf((Block)ModData.storage_block.get());
            }

            @Nonnull
            protected Iterable<Block> getKnownBlocks() {
                return Lists.newArrayList((Object[])new Block[]{(Block)ModData.disenchanter_block.get(), (Block)ModData.enchanter_block.get(), (Block)ModData.storage_block.get()});
            }
        }
    }

    public static class RecipeGenerator
    extends RecipeProvider {
        public RecipeGenerator(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> pRegistries) {
            super(packOutput, pRegistries);
        }

        protected void buildRecipes(@Nonnull RecipeOutput consumer) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModData.storage_block.get())).define(Character.valueOf('B'), (ItemLike)Items.BOOK).define(Character.valueOf('#'), (ItemLike)Blocks.CRYING_OBSIDIAN).define(Character.valueOf('D'), (ItemLike)Items.DIAMOND).pattern("BBB").pattern("D#D").pattern("###").unlockedBy("has_obsidian", RecipeGenerator.has((ItemLike)Blocks.CRYING_OBSIDIAN)).save(consumer);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModData.disenchanter_block.get())).define(Character.valueOf('B'), (ItemLike)Items.BOOK).define(Character.valueOf('#'), (ItemLike)Blocks.CRYING_OBSIDIAN).define(Character.valueOf('D'), (ItemLike)Items.DIAMOND_AXE).pattern(" B ").pattern("D#D").pattern("###").unlockedBy("has_obsidian", RecipeGenerator.has((ItemLike)Blocks.CRYING_OBSIDIAN)).save(consumer);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModData.enchanter_block.get())).define(Character.valueOf('B'), (ItemLike)Items.BOOK).define(Character.valueOf('#'), (ItemLike)Blocks.CRYING_OBSIDIAN).define(Character.valueOf('D'), (ItemLike)Items.DIAMOND).pattern(" B ").pattern("D#D").pattern("###").unlockedBy("has_obsidian", RecipeGenerator.has((ItemLike)Blocks.CRYING_OBSIDIAN)).save(consumer);
        }
    }

    public static class ModBlockTagsProvider
    extends BlockTagsProvider {
        public ModBlockTagsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
            super(output, lookupProvider, "enchantmentmachine", existingFileHelper);
        }

        protected void addTags(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider holderLookup) {
            this.tag(BlockTags.MINEABLE_WITH_PICKAXE).add((Object[])new Block[]{(Block)ModData.disenchanter_block.get(), (Block)ModData.enchanter_block.get(), (Block)ModData.storage_block.get()});
        }
    }
}

