/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.enchantmentmachine.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cheaterpaul.enchantmentmachine.core.ModConfig;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.enchantment.Enchantment;

public record EnchantmentInstanceMod(@Nonnull Holder<Enchantment> enchantment, int level) {
    public static final Codec<EnchantmentInstanceMod> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Enchantment.CODEC.fieldOf("enchantment").forGetter(EnchantmentInstanceMod::enchantment), (App)Codec.INT.fieldOf("level").forGetter(EnchantmentInstanceMod::level)).apply((Applicative)inst, EnchantmentInstanceMod::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, EnchantmentInstanceMod> STREAM_CODEC = StreamCodec.composite((StreamCodec)Enchantment.STREAM_CODEC, EnchantmentInstanceMod::enchantment, (StreamCodec)ByteBufCodecs.INT, EnchantmentInstanceMod::level, EnchantmentInstanceMod::new);

    @Nonnull
    public Enchantment getEnchantment() {
        return (Enchantment)this.enchantment.value();
    }

    public Component getEnchantmentName() {
        return Enchantment.getFullname(this.enchantment, (int)this.level);
    }

    public boolean canEnchant() {
        int maxLevel = ModConfig.SERVER.getMaxEnchantmentLevels().getOrDefault(this.enchantment.getKey().location(), ((Enchantment)this.enchantment.value()).getMaxLevel());
        return maxLevel >= this.level;
    }
}

