/*
 * Decompiled with CFR 0.152.
 */
package com.mc1510ty.SyncChat;

import com.mc1510ty.SyncChat.GroupManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MessageCache {
    private static final Map<String, Set<String>> sentMessages = new HashMap<String, Set<String>>();

    public static void addSentMessage(String group, String message) {
        sentMessages.computeIfAbsent(message, k -> new HashSet()).add(group);
    }

    public static boolean shouldProcess(String incomingGroup, String message, GroupManager groupManager) {
        Set<String> sentGroups = sentMessages.get(message);
        if (sentGroups == null) {
            return true;
        }
        String highestPriorityGroup = null;
        int highestPriority = Integer.MAX_VALUE;
        for (String sentGroup : sentGroups) {
            int priority = groupManager.getPriority(sentGroup);
            if (priority == -1 || priority >= highestPriority) continue;
            highestPriority = priority;
            highestPriorityGroup = sentGroup;
        }
        int incomingPriority = groupManager.getPriority(incomingGroup);
        return incomingPriority <= highestPriority;
    }
}

