/*
 * Decompiled with CFR 0.152.
 */
package com.mc1510ty.SyncChat;

import com.mc1510ty.SyncChat.MessageCache;
import com.mc1510ty.SyncChat.SyncChat;
import com.mc1510ty.SyncChat.libs.redis.clients.jedis.Jedis;
import com.mc1510ty.SyncChat.libs.redis.clients.jedis.JedisPubSub;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class RedisManager {
    private final SyncChat plugin;
    private final Jedis subscriberJedis;
    private final Jedis publisherJedis;
    private final List<String> groups;

    public RedisManager(SyncChat plugin, String host, int port, List<String> groups) {
        this.plugin = plugin;
        this.subscriberJedis = new Jedis(host, port);
        this.publisherJedis = new Jedis(host, port);
        this.groups = groups;
    }

    public void startSubscriber() {
        new Thread(() -> {
            try {
                this.subscriberJedis.subscribe(new JedisPubSub(){

                    @Override
                    public void onMessage(String channel, String message) {
                        String group = channel.replace("chat_group:", "");
                        RedisManager.this.plugin.getLogger().info("[Redis] " + group + ": " + message);
                        if (!MessageCache.shouldProcess(group, message, RedisManager.this.plugin.getGroupManager())) {
                            return;
                        }
                        Bukkit.getScheduler().runTask((Plugin)RedisManager.this.plugin, () -> Bukkit.broadcastMessage((String)("[" + group + "] " + message)));
                    }
                }, (String[])this.groups.stream().map(group -> "chat_group:" + group).toArray(String[]::new));
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Redis subscriber stopped: " + e.getMessage());
            }
        }, "Redis-Subscriber").start();
    }

    public void publish(String group, String message) {
        this.publisherJedis.publish("chat_group:" + group, message);
        MessageCache.addSentMessage(group, message);
    }

    public void close() {
        this.subscriberJedis.close();
        this.publisherJedis.close();
    }
}

