/*
 * Decompiled with CFR 0.152.
 */
package com.mc1510ty.SyncChat;

import com.mc1510ty.SyncChat.ChatListener;
import com.mc1510ty.SyncChat.GroupManager;
import com.mc1510ty.SyncChat.RedisManager;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SyncChat
extends JavaPlugin {
    private GroupManager groupManager;
    private RedisManager redisManager;

    public void onEnable() {
        this.saveDefaultConfig();
        FileConfiguration config = this.getConfig();
        String host = config.getString("redis.host", "localhost");
        int port = config.getInt("redis.port", 6379);
        List groups = config.getStringList("groups");
        this.groupManager = new GroupManager(groups);
        this.redisManager = new RedisManager(this, host, port, groups);
        this.redisManager.startSubscriber();
        this.getServer().getPluginManager().registerEvents((Listener)new ChatListener(this), (Plugin)this);
        this.getLogger().info("SyncChat enabled. Groups: " + String.valueOf(groups));
    }

    public void onDisable() {
        this.redisManager.close();
    }

    public GroupManager getGroupManager() {
        return this.groupManager;
    }

    public RedisManager getRedisManager() {
        return this.redisManager;
    }
}

