/*
 * Decompiled with CFR 0.152.
 */
package com.mc1510ty.SyncChat.libs.redis.clients.authentication.core;

import com.mc1510ty.SyncChat.libs.redis.clients.authentication.core.IdentityProvider;
import com.mc1510ty.SyncChat.libs.redis.clients.authentication.core.Request;
import com.mc1510ty.SyncChat.libs.redis.clients.authentication.core.Token;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Dispatcher {
    private ExecutorService executor = Executors.newFixedThreadPool(2);
    private Exception error;
    private long tokenRequestExecTimeoutInMs;
    private IdentityProvider identityProvider;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public Dispatcher(IdentityProvider provider, long tokenRequestExecTimeoutInMs) {
        this.tokenRequestExecTimeoutInMs = tokenRequestExecTimeoutInMs;
        this.identityProvider = provider;
    }

    public Request requestTokenAsync() {
        Future<Token> request = this.executor.submit(() -> this.requestToken());
        return () -> (Token)request.get(this.tokenRequestExecTimeoutInMs, TimeUnit.MILLISECONDS);
    }

    public Exception getError() {
        return this.error;
    }

    public void stop() {
        this.executor.shutdown();
    }

    private Token requestToken() {
        this.error = null;
        try {
            return this.identityProvider.requestToken();
        }
        catch (Exception e) {
            this.error = e;
            this.logger.error("Request to identity provider failed with message: " + e.getMessage(), e);
            throw e;
        }
    }
}

