/*
 * Decompiled with CFR 0.152.
 */
package com.mc1510ty.SyncChat.libs.redis.clients.authentication.core;

import com.mc1510ty.SyncChat.libs.redis.clients.authentication.core.IdentityProviderConfig;
import com.mc1510ty.SyncChat.libs.redis.clients.authentication.core.TokenManagerConfig;

public class TokenAuthConfig {
    private TokenManagerConfig tokenManagerConfig;
    private IdentityProviderConfig identityProviderConfig;

    public TokenAuthConfig(TokenManagerConfig tokenManagerConfig, IdentityProviderConfig identityProviderConfig) {
        this.tokenManagerConfig = tokenManagerConfig;
        this.identityProviderConfig = identityProviderConfig;
    }

    public TokenManagerConfig getTokenManagerConfig() {
        return this.tokenManagerConfig;
    }

    public IdentityProviderConfig getIdentityProviderConfig() {
        return this.identityProviderConfig;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder<T extends Builder<T>> {
        private IdentityProviderConfig identityProviderConfig;
        private int lowerRefreshBoundMillis;
        private float expirationRefreshRatio;
        private int tokenRequestExecTimeoutInMs;
        private int maxAttemptsToRetry;
        private int delayInMsToRetry;

        public T expirationRefreshRatio(float expirationRefreshRatio) {
            this.expirationRefreshRatio = expirationRefreshRatio;
            return (T)this;
        }

        public T lowerRefreshBoundMillis(int lowerRefreshBoundMillis) {
            this.lowerRefreshBoundMillis = lowerRefreshBoundMillis;
            return (T)this;
        }

        public T tokenRequestExecTimeoutInMs(int tokenRequestExecTimeoutInMs) {
            this.tokenRequestExecTimeoutInMs = tokenRequestExecTimeoutInMs;
            return (T)this;
        }

        public T maxAttemptsToRetry(int maxAttemptsToRetry) {
            this.maxAttemptsToRetry = maxAttemptsToRetry;
            return (T)this;
        }

        public T delayInMsToRetry(int delayInMsToRetry) {
            this.delayInMsToRetry = delayInMsToRetry;
            return (T)this;
        }

        public T identityProviderConfig(IdentityProviderConfig identityProviderConfig) {
            this.identityProviderConfig = identityProviderConfig;
            return (T)this;
        }

        public TokenAuthConfig build() {
            return new TokenAuthConfig(new TokenManagerConfig(this.expirationRefreshRatio, this.lowerRefreshBoundMillis, this.tokenRequestExecTimeoutInMs, new TokenManagerConfig.RetryPolicy(this.maxAttemptsToRetry, this.delayInMsToRetry)), this.identityProviderConfig);
        }

        public static Builder from(Builder sample) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)new Builder().expirationRefreshRatio(sample.expirationRefreshRatio)).lowerRefreshBoundMillis(sample.lowerRefreshBoundMillis)).tokenRequestExecTimeoutInMs(sample.tokenRequestExecTimeoutInMs)).maxAttemptsToRetry(sample.maxAttemptsToRetry)).delayInMsToRetry(sample.delayInMsToRetry)).identityProviderConfig(sample.identityProviderConfig);
        }
    }
}

