/*
 * Decompiled with CFR 0.152.
 */
package com.mc1510ty.SyncChat.libs.redis.clients.jedis;

import com.mc1510ty.SyncChat.libs.redis.clients.jedis.Connection;
import com.mc1510ty.SyncChat.libs.redis.clients.jedis.ConnectionFactory;
import com.mc1510ty.SyncChat.libs.redis.clients.jedis.HostAndPort;
import com.mc1510ty.SyncChat.libs.redis.clients.jedis.JedisClientConfig;
import com.mc1510ty.SyncChat.libs.redis.clients.jedis.annots.Experimental;
import com.mc1510ty.SyncChat.libs.redis.clients.jedis.authentication.AuthXManager;
import com.mc1510ty.SyncChat.libs.redis.clients.jedis.csc.Cache;
import com.mc1510ty.SyncChat.libs.redis.clients.jedis.exceptions.JedisException;
import com.mc1510ty.SyncChat.libs.redis.clients.jedis.util.Pool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class ConnectionPool
extends Pool<Connection> {
    private AuthXManager authXManager;

    public ConnectionPool(HostAndPort hostAndPort, JedisClientConfig clientConfig) {
        this(new ConnectionFactory(hostAndPort, clientConfig));
        this.attachAuthenticationListener(clientConfig.getAuthXManager());
    }

    @Experimental
    public ConnectionPool(HostAndPort hostAndPort, JedisClientConfig clientConfig, Cache clientSideCache) {
        this(new ConnectionFactory(hostAndPort, clientConfig, clientSideCache));
        this.attachAuthenticationListener(clientConfig.getAuthXManager());
    }

    public ConnectionPool(PooledObjectFactory<Connection> factory) {
        super(factory);
    }

    public ConnectionPool(HostAndPort hostAndPort, JedisClientConfig clientConfig, GenericObjectPoolConfig<Connection> poolConfig) {
        this(new ConnectionFactory(hostAndPort, clientConfig), poolConfig);
        this.attachAuthenticationListener(clientConfig.getAuthXManager());
    }

    @Experimental
    public ConnectionPool(HostAndPort hostAndPort, JedisClientConfig clientConfig, Cache clientSideCache, GenericObjectPoolConfig<Connection> poolConfig) {
        this(new ConnectionFactory(hostAndPort, clientConfig, clientSideCache), poolConfig);
        this.attachAuthenticationListener(clientConfig.getAuthXManager());
    }

    public ConnectionPool(PooledObjectFactory<Connection> factory, GenericObjectPoolConfig<Connection> poolConfig) {
        super(factory, poolConfig);
    }

    @Override
    public Connection getResource() {
        Connection conn = (Connection)super.getResource();
        conn.setHandlingPool(this);
        return conn;
    }

    @Override
    public void close() {
        try {
            if (this.authXManager != null) {
                this.authXManager.stop();
            }
        }
        finally {
            super.close();
        }
    }

    private void attachAuthenticationListener(AuthXManager authXManager) {
        this.authXManager = authXManager;
        if (authXManager != null) {
            authXManager.addPostAuthenticationHook(token -> {
                try {
                    this.evict();
                }
                catch (Exception e) {
                    throw new JedisException("Failed to evict connections from pool", e);
                }
            });
        }
    }
}

