/*
 * Decompiled with CFR 0.152.
 */
package com.mc1510ty.SyncChat.libs.redis.clients.jedis.params;

import com.mc1510ty.SyncChat.libs.redis.clients.jedis.CommandArguments;
import com.mc1510ty.SyncChat.libs.redis.clients.jedis.Protocol;
import com.mc1510ty.SyncChat.libs.redis.clients.jedis.params.IParams;
import java.util.Objects;

abstract class BaseGetExParams<T extends BaseGetExParams>
implements IParams {
    private Protocol.Keyword expiration;
    private Long expirationValue;

    BaseGetExParams() {
    }

    private T expiration(Protocol.Keyword type, Long value) {
        this.expiration = type;
        this.expirationValue = value;
        return (T)this;
    }

    public T ex(long secondsToExpire) {
        return this.expiration(Protocol.Keyword.EX, secondsToExpire);
    }

    public T px(long millisecondsToExpire) {
        return this.expiration(Protocol.Keyword.PX, millisecondsToExpire);
    }

    public T exAt(long seconds) {
        return this.expiration(Protocol.Keyword.EXAT, seconds);
    }

    public T pxAt(long milliseconds) {
        return this.expiration(Protocol.Keyword.PXAT, milliseconds);
    }

    public T persist() {
        return this.expiration(Protocol.Keyword.PERSIST, null);
    }

    @Override
    public void addParams(CommandArguments args) {
        if (this.expiration != null) {
            args.add(this.expiration);
            if (this.expirationValue != null) {
                args.add(this.expirationValue);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseGetExParams that = (BaseGetExParams)o;
        return this.expiration == that.expiration && Objects.equals(this.expirationValue, that.expirationValue);
    }

    public int hashCode() {
        return Objects.hash(this.expiration, this.expirationValue);
    }
}

