/*
 * Decompiled with CFR 0.152.
 */
package com.mc1510ty.SyncChat.libs.redis.clients.jedis.resps;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

public class AccessControlLogEntry
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String COUNT = "count";
    public static final String REASON = "reason";
    public static final String CONTEXT = "context";
    public static final String OBJECT = "object";
    public static final String USERNAME = "username";
    public static final String AGE_SECONDS = "age-seconds";
    public static final String CLIENT_INFO = "client-info";
    public static final String ENTRY_ID = "entry-id";
    public static final String TIMESTAMP_CREATED = "timestamp-created";
    public static final String TIMESTAMP_LAST_UPDATED = "timestamp-last-updated";
    private final long count;
    private final String reason;
    private final String context;
    private final String object;
    private final String username;
    private final Double ageSeconds;
    private final Map<String, String> clientInfo;
    private final Map<String, Object> logEntry;
    private final long entryId;
    private final long timestampCreated;
    private final long timestampLastUpdated;

    public AccessControlLogEntry(Map<String, Object> map) {
        this.count = (Long)map.get(COUNT);
        this.reason = (String)map.get(REASON);
        this.context = (String)map.get(CONTEXT);
        this.object = (String)map.get(OBJECT);
        this.username = (String)map.get(USERNAME);
        this.ageSeconds = (Double)map.get(AGE_SECONDS);
        this.clientInfo = this.getMapFromRawClientInfo((String)map.get(CLIENT_INFO));
        this.logEntry = map;
        this.entryId = map.containsKey(ENTRY_ID) ? (Long)map.get(ENTRY_ID) : -1L;
        this.timestampCreated = map.containsKey(TIMESTAMP_CREATED) ? (Long)map.get(TIMESTAMP_CREATED) : -1L;
        this.timestampLastUpdated = map.containsKey(TIMESTAMP_LAST_UPDATED) ? (Long)map.get(TIMESTAMP_LAST_UPDATED) : -1L;
    }

    public long getCount() {
        return this.count;
    }

    public String getReason() {
        return this.reason;
    }

    public String getContext() {
        return this.context;
    }

    public String getObject() {
        return this.object;
    }

    public String getUsername() {
        return this.username;
    }

    public Double getAgeSeconds() {
        return this.ageSeconds;
    }

    public Map<String, String> getClientInfo() {
        return this.clientInfo;
    }

    public Map<String, Object> getlogEntry() {
        return this.logEntry;
    }

    public long getEntryId() {
        return this.entryId;
    }

    public long getTimestampCreated() {
        return this.timestampCreated;
    }

    public long getTimestampLastUpdated() {
        return this.timestampLastUpdated;
    }

    private Map<String, String> getMapFromRawClientInfo(String clientInfo) {
        String[] entries = clientInfo.split(" ");
        LinkedHashMap<String, String> clientInfoMap = new LinkedHashMap<String, String>(entries.length);
        for (String entry : entries) {
            String[] kvArray = entry.split("=");
            clientInfoMap.put(kvArray[0], kvArray.length == 2 ? kvArray[1] : "");
        }
        return clientInfoMap;
    }

    public String toString() {
        return "AccessControlLogEntry{count=" + this.count + ", reason='" + this.reason + '\'' + ", context='" + this.context + '\'' + ", object='" + this.object + '\'' + ", username='" + this.username + '\'' + ", ageSeconds='" + this.ageSeconds + '\'' + ", clientInfo=" + this.clientInfo + ", entryId=" + this.entryId + ", timestampCreated=" + this.timestampCreated + ", timestampLastUpdated=" + this.timestampLastUpdated + '}';
    }
}

