/*
 * Decompiled with CFR 0.152.
 */
package com.mc1510ty.SyncChat.libs.redis.clients.jedis.resps;

import com.mc1510ty.SyncChat.libs.redis.clients.jedis.Builder;
import com.mc1510ty.SyncChat.libs.redis.clients.jedis.BuilderFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommandInfo {
    private final String name;
    private final long arity;
    private final List<String> flags;
    private final long firstKey;
    private final long lastKey;
    private final long step;
    private final List<String> aclCategories;
    private final List<String> tips;
    private final Map<String, CommandInfo> subcommands;
    public static final Builder<CommandInfo> COMMAND_INFO_BUILDER = new Builder<CommandInfo>(){

        @Override
        public CommandInfo build(Object data) {
            if (data == null) {
                return null;
            }
            List commandData = (List)data;
            if (commandData.isEmpty()) {
                return null;
            }
            String name = BuilderFactory.STRING.build(commandData.get(0));
            long arity = BuilderFactory.LONG.build(commandData.get(1));
            List<String> flags = BuilderFactory.STRING_LIST.build(commandData.get(2));
            long firstKey = BuilderFactory.LONG.build(commandData.get(3));
            long lastKey = BuilderFactory.LONG.build(commandData.get(4));
            long step = BuilderFactory.LONG.build(commandData.get(5));
            List<String> aclCategories = commandData.size() >= 7 ? BuilderFactory.STRING_LIST.build(commandData.get(6)) : null;
            List<String> tips = commandData.size() >= 8 ? BuilderFactory.STRING_LIST.build(commandData.get(7)) : null;
            Map<String, CommandInfo> subcommands = commandData.size() >= 10 ? COMMAND_INFO_RESPONSE.build(commandData.get(9)) : null;
            return new CommandInfo(name, arity, flags, firstKey, lastKey, step, aclCategories, tips, subcommands);
        }
    };
    public static final Builder<Map<String, CommandInfo>> COMMAND_INFO_RESPONSE = new Builder<Map<String, CommandInfo>>(){

        @Override
        public Map<String, CommandInfo> build(Object data) {
            if (data == null) {
                return null;
            }
            List rawList = (List)data;
            HashMap<String, CommandInfo> map = new HashMap<String, CommandInfo>(rawList.size());
            for (Object rawCommandInfo : rawList) {
                CommandInfo info = COMMAND_INFO_BUILDER.build(rawCommandInfo);
                if (info == null) continue;
                map.put(info.getName(), info);
            }
            return map;
        }
    };

    @Deprecated
    public CommandInfo(long arity, List<String> flags, long firstKey, long lastKey, long step, List<String> aclCategories, List<String> tips, List<String> subcommands) {
        this(null, arity, flags, firstKey, lastKey, step, aclCategories, tips, null);
    }

    private CommandInfo(String name, long arity, List<String> flags, long firstKey, long lastKey, long step, List<String> aclCategories, List<String> tips, Map<String, CommandInfo> subcommands) {
        this.name = name;
        this.arity = arity;
        this.flags = flags;
        this.firstKey = firstKey;
        this.lastKey = lastKey;
        this.step = step;
        this.aclCategories = aclCategories;
        this.tips = tips;
        this.subcommands = subcommands;
    }

    public String getName() {
        return this.name;
    }

    public long getArity() {
        return this.arity;
    }

    public List<String> getFlags() {
        return this.flags;
    }

    public long getFirstKey() {
        return this.firstKey;
    }

    public long getLastKey() {
        return this.lastKey;
    }

    public long getStep() {
        return this.step;
    }

    public List<String> getAclCategories() {
        return this.aclCategories;
    }

    public List<String> getTips() {
        return this.tips;
    }

    public Map<String, CommandInfo> getSubcommands() {
        return this.subcommands;
    }
}

