/*
 * Decompiled with CFR 0.152.
 */
package com.mc1510ty.SyncChat.libs.redis.clients.jedis.search;

import com.mc1510ty.SyncChat.libs.redis.clients.jedis.Builder;
import com.mc1510ty.SyncChat.libs.redis.clients.jedis.BuilderFactory;
import com.mc1510ty.SyncChat.libs.redis.clients.jedis.annots.Internal;
import com.mc1510ty.SyncChat.libs.redis.clients.jedis.search.Document;
import com.mc1510ty.SyncChat.libs.redis.clients.jedis.util.KeyValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class SearchResult {
    private final long totalResults;
    private final List<Document> documents;
    private final List<String> warnings;
    public static Builder<SearchResult> SEARCH_RESULT_BUILDER = new PerFieldDecoderSearchResultBuilder(Document.SEARCH_DOCUMENT);

    private SearchResult(long totalResults, List<Document> documents) {
        this(totalResults, documents, (List<String>)null);
    }

    private SearchResult(long totalResults, List<Document> documents, List<String> warnings) {
        this.totalResults = totalResults;
        this.documents = documents;
        this.warnings = warnings;
    }

    public long getTotalResults() {
        return this.totalResults;
    }

    public List<Document> getDocuments() {
        return Collections.unmodifiableList(this.documents);
    }

    public List<String> getWarnings() {
        return this.warnings;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{Total results:" + this.totalResults + ", Documents:" + this.documents + (this.warnings != null ? ", Warnings:" + this.warnings : "") + "}";
    }

    @Internal
    public static final class PerFieldDecoderSearchResultBuilder
    extends Builder<SearchResult> {
        private static final String TOTAL_RESULTS_STR = "total_results";
        private static final String RESULTS_STR = "results";
        private static final String WARNINGS_STR = "warning";
        private final Builder<Document> documentBuilder;

        public PerFieldDecoderSearchResultBuilder(Map<String, Boolean> isFieldDecode) {
            this(new Document.PerFieldDecoderDocumentBuilder(isFieldDecode));
        }

        private PerFieldDecoderSearchResultBuilder(Builder<Document> builder) {
            this.documentBuilder = Objects.requireNonNull(builder);
        }

        @Override
        public SearchResult build(Object data) {
            List list = (List)data;
            long totalResults = -1L;
            List results = null;
            List<String> warnings = null;
            for (KeyValue kv : list) {
                String key = BuilderFactory.STRING.build(kv.getKey());
                Object rawVal = kv.getValue();
                switch (key) {
                    case "total_results": {
                        totalResults = BuilderFactory.LONG.build(rawVal);
                        break;
                    }
                    case "results": {
                        results = ((List)rawVal).stream().map(this.documentBuilder::build).collect(Collectors.toList());
                        break;
                    }
                    case "warning": {
                        warnings = BuilderFactory.STRING_LIST.build(rawVal);
                    }
                }
            }
            return new SearchResult(totalResults, results, warnings);
        }
    }

    public static class SearchResultBuilder
    extends Builder<SearchResult> {
        private final boolean hasContent;
        private final boolean hasScores;
        private final boolean decode;
        private final Map<String, Boolean> isFieldDecode;

        public SearchResultBuilder(boolean hasContent, boolean hasScores, boolean decode) {
            this(hasContent, hasScores, decode, null);
        }

        public SearchResultBuilder(boolean hasContent, boolean hasScores, boolean decode, Map<String, Boolean> isFieldDecode) {
            this.hasContent = hasContent;
            this.hasScores = hasScores;
            this.decode = decode;
            this.isFieldDecode = isFieldDecode;
        }

        @Override
        public SearchResult build(Object data) {
            List resp = (List)data;
            int step = 1;
            int scoreOffset = 0;
            int contentOffset = 1;
            if (this.hasScores) {
                ++step;
                scoreOffset = 1;
                ++contentOffset;
            }
            if (this.hasContent) {
                ++step;
            }
            long totalResults = (Long)resp.get(0);
            ArrayList<Document> documents = new ArrayList<Document>(resp.size() - 1);
            for (int i = 1; i < resp.size(); i += step) {
                String id = BuilderFactory.STRING.build(resp.get(i));
                double score = this.hasScores ? BuilderFactory.DOUBLE.build(resp.get(i + scoreOffset)) : 1.0;
                List fields = this.hasContent ? (List)resp.get(i + contentOffset) : null;
                documents.add(Document.load(id, score, fields, this.decode, this.isFieldDecode));
            }
            return new SearchResult(totalResults, documents);
        }
    }
}

