/*
 * Decompiled with CFR 0.152.
 */
package com.mc1510ty.SyncChat.libs.redis.clients.jedis.search.aggr;

import com.mc1510ty.SyncChat.libs.redis.clients.jedis.Builder;
import com.mc1510ty.SyncChat.libs.redis.clients.jedis.BuilderFactory;
import com.mc1510ty.SyncChat.libs.redis.clients.jedis.exceptions.JedisDataException;
import com.mc1510ty.SyncChat.libs.redis.clients.jedis.search.aggr.Row;
import com.mc1510ty.SyncChat.libs.redis.clients.jedis.util.KeyValue;
import com.mc1510ty.SyncChat.libs.redis.clients.jedis.util.SafeEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class AggregationResult {
    private final long totalResults;
    private final List<Map<String, Object>> results;
    private final List<String> warnings;
    private Long cursorId = -1L;
    public static final Builder<AggregationResult> SEARCH_AGGREGATION_RESULT = new Builder<AggregationResult>(){
        private static final String TOTAL_RESULTS_STR = "total_results";
        private static final String RESULTS_STR = "results";
        private static final String FIELDS_STR = "extra_attributes";
        private static final String WARNINGS_STR = "warning";

        @Override
        public AggregationResult build(Object data) {
            List list = (List)data;
            if (list.get(0) instanceof KeyValue) {
                List kvList = (List)data;
                long totalResults = -1L;
                ArrayList<Map<String, Object>> results = null;
                List<String> warnings = null;
                block10: for (KeyValue kv : kvList) {
                    String key = BuilderFactory.STRING.build(kv.getKey());
                    Object rawVal = kv.getValue();
                    switch (key) {
                        case "total_results": {
                            totalResults = BuilderFactory.LONG.build(rawVal);
                            break;
                        }
                        case "results": {
                            List resList = (List)rawVal;
                            results = new ArrayList<Map<String, Object>>(resList.size());
                            block11: for (List rikv : resList) {
                                for (KeyValue ikv : rikv) {
                                    if (!FIELDS_STR.equals(BuilderFactory.STRING.build(ikv.getKey()))) continue;
                                    results.add(BuilderFactory.ENCODED_OBJECT_MAP.build(ikv.getValue()));
                                    continue block11;
                                }
                            }
                            continue block10;
                        }
                        case "warning": {
                            warnings = BuilderFactory.STRING_LIST.build(rawVal);
                        }
                    }
                }
                return new AggregationResult(totalResults, results, warnings);
            }
            list = (List)SafeEncoder.encodeObject(data);
            long totalResults = (Long)list.get(0);
            ArrayList results = new ArrayList(list.size() - 1);
            for (int i = 1; i < list.size(); ++i) {
                List mapList = (List)list.get(i);
                HashMap map = new HashMap(mapList.size() / 2, 1.0f);
                for (int j = 0; j < mapList.size(); j += 2) {
                    Object r = mapList.get(j);
                    if (r instanceof JedisDataException) {
                        throw (JedisDataException)r;
                    }
                    map.put((String)r, mapList.get(j + 1));
                }
                results.add(map);
            }
            return new AggregationResult(totalResults, (List)results);
        }
    };
    public static final Builder<AggregationResult> SEARCH_AGGREGATION_RESULT_WITH_CURSOR = new Builder<AggregationResult>(){

        @Override
        public AggregationResult build(Object data) {
            List list = (List)data;
            AggregationResult r = SEARCH_AGGREGATION_RESULT.build(list.get(0));
            r.setCursorId((Long)list.get(1));
            return r;
        }
    };

    private AggregationResult(long totalResults, List<Map<String, Object>> results) {
        this(totalResults, results, (List<String>)null);
    }

    private AggregationResult(long totalResults, List<Map<String, Object>> results, List<String> warnings) {
        this.totalResults = totalResults;
        this.results = results;
        this.warnings = warnings;
    }

    private void setCursorId(Long cursorId) {
        this.cursorId = cursorId;
    }

    public Long getCursorId() {
        return this.cursorId;
    }

    public long getTotalResults() {
        return this.totalResults;
    }

    public List<Map<String, Object>> getResults() {
        return Collections.unmodifiableList(this.results);
    }

    public List<Row> getRows() {
        return this.results.stream().map(Row::new).collect(Collectors.toList());
    }

    public Row getRow(int index) {
        return new Row(this.results.get(index));
    }

    public List<String> getWarnings() {
        return this.warnings;
    }
}

