/*
 * Decompiled with CFR 0.152.
 */
package com.mc1510ty.SyncChat.libs.redis.clients.jedis.timeseries;

import com.mc1510ty.SyncChat.libs.redis.clients.jedis.CommandArguments;
import com.mc1510ty.SyncChat.libs.redis.clients.jedis.params.IParams;
import com.mc1510ty.SyncChat.libs.redis.clients.jedis.timeseries.TimeSeriesProtocol;
import java.util.Arrays;

public class TSMGetParams
implements IParams {
    private boolean latest;
    private boolean withLabels;
    private String[] selectedLabels;

    public static TSMGetParams multiGetParams() {
        return new TSMGetParams();
    }

    public TSMGetParams latest() {
        this.latest = true;
        return this;
    }

    public TSMGetParams withLabels(boolean withLabels) {
        this.withLabels = withLabels;
        return this;
    }

    public TSMGetParams withLabels() {
        return this.withLabels(true);
    }

    public TSMGetParams selectedLabels(String ... labels) {
        this.selectedLabels = labels;
        return this;
    }

    @Override
    public void addParams(CommandArguments args) {
        if (this.latest) {
            args.add(TimeSeriesProtocol.TimeSeriesKeyword.LATEST);
        }
        if (this.withLabels) {
            args.add(TimeSeriesProtocol.TimeSeriesKeyword.WITHLABELS);
        } else if (this.selectedLabels != null) {
            args.add(TimeSeriesProtocol.TimeSeriesKeyword.SELECTED_LABELS);
            for (String label : this.selectedLabels) {
                args.add(label);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TSMGetParams that = (TSMGetParams)o;
        return this.latest == that.latest && this.withLabels == that.withLabels && Arrays.equals(this.selectedLabels, that.selectedLabels);
    }

    public int hashCode() {
        int result = Boolean.hashCode(this.latest);
        result = 31 * result + Boolean.hashCode(this.withLabels);
        result = 31 * result + Arrays.hashCode(this.selectedLabels);
        return result;
    }
}

