/*
 * Decompiled with CFR 0.152.
 */
package net.p1nero.ss.animation;

import java.util.Comparator;
import java.util.List;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import net.p1nero.ss.animation.ILinkArtifactSpiritAnimation;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class PlayerScanAnimation
extends AttackAnimation
implements ILinkArtifactSpiritAnimation {
    private AnimationManager.AnimationAccessor<? extends StaticAnimation> artifactSpiritAnimation;

    public PlayerScanAnimation(float transitionTime, float antic, float preDelay, float contact, float recovery, @Nullable Collider collider, Joint colliderJoint, AnimationManager.AnimationAccessor<? extends AttackAnimation> accessor, AssetAccessor<? extends Armature> armature) {
        super(transitionTime, antic, preDelay, contact, recovery, collider, colliderJoint, accessor, armature);
    }

    public PlayerScanAnimation(float transitionTime, float antic, float preDelay, float contact, float recovery, InteractionHand hand, @Nullable Collider collider, Joint colliderJoint, AnimationManager.AnimationAccessor<? extends AttackAnimation> accessor, AssetAccessor<? extends Armature> armature) {
        super(transitionTime, antic, preDelay, contact, recovery, hand, collider, colliderJoint, accessor, armature);
    }

    public PlayerScanAnimation(float transitionTime, AnimationManager.AnimationAccessor<? extends AttackAnimation> accessor, AssetAccessor<? extends Armature> armature, AttackAnimation.Phase ... phases) {
        super(transitionTime, accessor, armature, phases);
    }

    public PlayerScanAnimation(float convertTime, float antic, float preDelay, float contact, float recovery, InteractionHand hand, @Nullable Collider collider, Joint colliderJoint, String path, AssetAccessor<? extends Armature> armature) {
        super(convertTime, antic, preDelay, contact, recovery, hand, collider, colliderJoint, path, armature);
    }

    public PlayerScanAnimation(float convertTime, String path, AssetAccessor<? extends Armature> armature, AttackAnimation.Phase ... phases) {
        super(convertTime, path, armature, phases);
    }

    public PlayerScanAnimation setArtifactSpiritAnimation(AnimationManager.AnimationAccessor<? extends StaticAnimation> artifactSpiritAnimation) {
        this.artifactSpiritAnimation = artifactSpiritAnimation;
        return this;
    }

    public void begin(LivingEntityPatch<?> entityPatch) {
        super.begin(entityPatch);
        if (entityPatch instanceof ServerPlayerPatch) {
            ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)entityPatch;
            serverPlayerPatch.setAttackTarget(null);
        }
        this.callArtifactSpiritAnimation(entityPatch);
    }

    protected void attackTick(LivingEntityPatch<?> entityPatch, AssetAccessor<? extends DynamicAnimation> animation) {
        LivingEntity target;
        AnimationPlayer player = entityPatch.getAnimator().getPlayerFor((AssetAccessor)this.getAccessor());
        float elapsedTime = player.getElapsedTime();
        float prevElapsedTime = player.getPrevElapsedTime();
        EntityState state = this.getState(entityPatch, elapsedTime);
        EntityState prevState = this.getState(entityPatch, prevElapsedTime);
        AttackAnimation.Phase phase = this.getPhaseByTime(elapsedTime);
        if (state.getLevel() == 1 && !state.turningLocked() && entityPatch instanceof MobPatch) {
            MobPatch mobpatch = (MobPatch)entityPatch;
            ((Mob)mobpatch.getOriginal()).m_21573_().m_26573_();
            ((LivingEntity)entityPatch.getOriginal()).f_20921_ = 2.0f;
        }
        if ((target = entityPatch.getTarget()) != null && elapsedTime <= phase.contact) {
            entityPatch.rotateTo((Entity)target, entityPatch.getYRotLimit(), false);
            Vec3 pos = ((LivingEntity)entityPatch.getOriginal()).m_20182_();
            Vec3 targetPos = target.m_20182_();
            Vec3 toTarget = targetPos.m_82546_(pos);
            float yRot = (float)MathUtils.getYRotOfVector((Vec3)toTarget);
            float clampedYRot = MathUtils.rotlerp((float)((LivingEntity)entityPatch.getOriginal()).m_146908_(), (float)yRot, (float)entityPatch.getYRotLimit());
            ((LivingEntity)entityPatch.getOriginal()).m_146922_(clampedYRot);
        }
        if (prevState.attacking() || state.attacking() || prevState.getLevel() < 2 && state.getLevel() > 2) {
            if (!prevState.attacking() || phase != this.getPhaseByTime(prevElapsedTime) && (state.attacking() || prevState.getLevel() < 2 && state.getLevel() > 2)) {
                entityPatch.removeHurtEntities();
            }
            this.searchAndSetTarget(entityPatch, prevElapsedTime, elapsedTime, prevState, state, phase);
        }
    }

    protected void searchAndSetTarget(LivingEntityPatch<?> entityPatch, float prevElapsedTime, float elapsedTime, EntityState prevState, EntityState state, AttackAnimation.Phase phase) {
        float prevPoseTime = prevState.attacking() ? prevElapsedTime : phase.preDelay;
        float poseTime = state.attacking() ? elapsedTime : phase.contact;
        List list = this.getPhaseByTime(elapsedTime).getCollidingEntities(entityPatch, (AttackAnimation)this, prevPoseTime, poseTime, this.getPlaySpeed(entityPatch, (DynamicAnimation)this));
        if (list.contains(entityPatch.getTarget())) {
            return;
        }
        list.sort(Comparator.comparingDouble(entity -> entity.m_20270_(entityPatch.getOriginal())));
        for (Entity target : list) {
            LivingEntity trueEntity = this.getTrueEntity(target);
            if (trueEntity == null || !trueEntity.m_6084_() || entityPatch.isTargetInvulnerable((Entity)trueEntity) || !(target instanceof LivingEntity) && !(target instanceof PartEntity) || !(entityPatch instanceof ServerPlayerPatch)) continue;
            ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)entityPatch;
            serverPlayerPatch.setAttackTarget(trueEntity);
            break;
        }
    }

    @Override
    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getArtifactSpiritAnimation() {
        return this.artifactSpiritAnimation;
    }

    @Override
    public float getConvertTime() {
        return this.transitionTime;
    }
}

