/*
 * Decompiled with CFR 0.152.
 */
package net.p1nero.ss.collider;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.entity.PartEntity;
import net.p1nero.ss.entity.ReplaceableArmature;
import net.p1nero.ss.mixin.ColliderInvoker;
import net.p1nero.ss.mixin.MultiColliderAccessor;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.collider.MultiCollider;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class WrappedCollider<T extends Collider>
extends Collider {
    public T originalCollider;
    boolean corrected;
    protected Armature originalArmature = null;

    public WrappedCollider(T originalCollider) {
        super(Vec3.f_82478_, null);
        this.originalCollider = originalCollider;
    }

    public T getOriginalCollider() {
        return this.originalCollider;
    }

    protected void transform(OpenMatrix4f mat) {
        if (this.originalArmature != null && !this.corrected) {
            mat.rotateDeg(90.0f, Vec3f.X_AXIS);
            mat.rotateDeg(90.0f, Vec3f.Z_AXIS);
            this.corrected = true;
        }
        ((ColliderInvoker)this.originalCollider).sword_soaring$transform(mat);
    }

    protected AABB getHitboxAABB() {
        return ((ColliderInvoker)this.originalCollider).sword_soaring$getHitboxAABB();
    }

    public List<Entity> getCollideEntities(Entity entity) {
        return this.originalCollider.getCollideEntities(entity);
    }

    public List<Entity> updateAndSelectCollideEntity(LivingEntityPatch<?> entityPatch, AttackAnimation attackAnimation, float prevElapsedTime, float elapsedTime, Joint joint, float attackSpeed) {
        T t;
        if (this.originalArmature == null) {
            this.originalArmature = entityPatch.getArmature();
        }
        if ((t = this.originalCollider) instanceof MultiCollider) {
            MultiCollider multiCollider = (MultiCollider)t;
            int numberOf = Math.max(Math.round((float)(((MultiColliderAccessor)multiCollider).getNumberOfColliders() + attackAnimation.getProperty((AnimationProperty)AnimationProperty.AttackAnimationProperty.EXTRA_COLLIDERS).orElse(0)) * attackSpeed), ((MultiColliderAccessor)multiCollider).getNumberOfColliders());
            float partialScale = 1.0f / (float)(numberOf - 1);
            float interpolation = 0.0f;
            ArrayList colliders = Lists.newArrayList();
            LivingEntity original = (LivingEntity)entityPatch.getOriginal();
            float index = 0.0f;
            float interIndex = Math.min((float)(((MultiColliderAccessor)multiCollider).getNumberOfColliders() - 1) / (float)(numberOf - 1), 1.0f);
            for (int i = 0; i < numberOf; ++i) {
                colliders.add(((Collider)((MultiColliderAccessor)multiCollider).getColliders().get((int)index)).deepCopy());
                index += interIndex;
            }
            AABB outerBox = null;
            for (Collider collider : colliders) {
                OpenMatrix4f transformMatrix;
                Armature armature = entityPatch.getArmature();
                if (armature.rootJoint.equals((Object)joint)) {
                    Pose rootPose = new Pose();
                    rootPose.putJointData("Root", JointTransform.empty());
                    attackAnimation.modifyPose((DynamicAnimation)attackAnimation, rootPose, entityPatch, elapsedTime, 1.0f);
                    transformMatrix = rootPose.get("Root").getAnimationBoundMatrix(entityPatch.getArmature().rootJoint, new OpenMatrix4f()).removeTranslation();
                } else {
                    float interpolateTime = prevElapsedTime + (elapsedTime - prevElapsedTime) * interpolation;
                    transformMatrix = armature.getBoundTransformFor(attackAnimation.getPoseByTime(entityPatch, interpolateTime, 1.0f), joint);
                }
                double x = entityPatch.getXOld() + (original.m_20185_() - entityPatch.getXOld()) * (double)interpolation;
                double y = entityPatch.getYOld() + (original.m_20186_() - entityPatch.getYOld()) * (double)interpolation;
                double z = entityPatch.getZOld() + (original.m_20189_() - entityPatch.getZOld()) * (double)interpolation;
                OpenMatrix4f mvMatrix = OpenMatrix4f.createTranslation((float)(-((float)x)), (float)((float)y), (float)(-((float)z)));
                transformMatrix.mulFront(mvMatrix.mulBack(entityPatch.getModelMatrix(interpolation)));
                if (armature instanceof ReplaceableArmature) {
                    transformMatrix.rotateDeg(90.0f, Vec3f.X_AXIS);
                    transformMatrix.rotateDeg(90.0f, Vec3f.Z_AXIS);
                }
                ((ColliderInvoker)collider).sword_soaring$transform(transformMatrix);
                interpolation += partialScale;
                if (outerBox == null) {
                    outerBox = ((ColliderInvoker)collider).sword_soaring$getHitboxAABB();
                    continue;
                }
                outerBox.m_82367_(((ColliderInvoker)collider).sword_soaring$getHitboxAABB());
            }
            List entities = ((LivingEntity)entityPatch.getOriginal()).m_9236_().m_6249_(entityPatch.getOriginal(), outerBox, entity -> {
                Collider collider;
                if (entity.m_5833_()) {
                    return false;
                }
                if (entity instanceof PartEntity && ((PartEntity)entity).getParent().m_7306_(entityPatch.getOriginal())) {
                    return false;
                }
                Iterator var3 = colliders.iterator();
                do {
                    if (var3.hasNext()) continue;
                    return false;
                } while (!(collider = (Collider)var3.next()).isCollide(entity));
                return true;
            });
            return entities;
        }
        return this.originalCollider.updateAndSelectCollideEntity(entityPatch, attackAnimation, prevElapsedTime, elapsedTime, joint, attackSpeed);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawInternal(PoseStack poseStack, VertexConsumer vertexConsumer, Armature armature, Joint joint, Pose pose, Pose pose1, float v, int i) {
        this.originalCollider.drawInternal(poseStack, vertexConsumer, armature, joint, pose, pose1, v, i);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void draw(PoseStack poseStack, MultiBufferSource buffer, LivingEntityPatch<?> entityPatch, AttackAnimation animation, Joint joint, float prevElapsedTime, float elapsedTime, float partialTicks, float attackSpeed) {
        this.originalCollider.draw(poseStack, buffer, entityPatch, animation, joint, prevElapsedTime, elapsedTime, partialTicks, attackSpeed);
    }

    public Collider deepCopy() {
        return this.originalCollider.deepCopy();
    }

    public boolean isCollide(Entity entity) {
        return this.originalCollider.isCollide(entity);
    }

    public RenderType getRenderType() {
        return this.originalCollider.getRenderType();
    }

    public CompoundTag serialize(CompoundTag resultTag) {
        return this.originalCollider.serialize(resultTag);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WrappedCollider)) {
            return false;
        }
        return this.originalCollider.equals(((WrappedCollider)((Object)obj)).originalCollider);
    }

    public String toString() {
        return this.originalCollider.toString();
    }
}

