/*
 * Decompiled with CFR 0.152.
 */
package net.p1nero.ss.entity.sword.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.p1nero.ss.entity.AbstractArtifactSpiritEntity;
import net.p1nero.ss.entity.client.layer.PatchedReplaceableLayer;
import net.p1nero.ss.entity.client.layer.ReplaceableRenderLayer;
import net.p1nero.ss.entity.sword.AbstractSwordEntity;
import net.p1nero.ss.item.VatanseverItem;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.client.model.SkinnedMesh;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.client.renderer.patched.entity.PatchedLivingEntityRenderer;
import yesman.epicfight.mixin.client.MixinLivingEntityRenderer;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@OnlyIn(value=Dist.CLIENT)
public abstract class PatchedReplaceableRenderer<E extends AbstractSwordEntity, T extends LivingEntityPatch<E>, M extends EntityModel<E>, R extends LivingEntityRenderer<E, M>, AM extends SkinnedMesh>
extends PatchedLivingEntityRenderer<E, T, M, R, AM> {
    public PatchedReplaceableRenderer(EntityRendererProvider.Context context, EntityType<?> entityType) {
        super(context, entityType);
        this.addReplaceablePatchedLayer();
    }

    public void render(E entityIn, T entityPatch, R renderer, MultiBufferSource buffer, PoseStack poseStack, int packedLight, float partialTicks) {
        if (((AbstractArtifactSpiritEntity)((Object)entityIn)).m_269323_() != null && !(((AbstractSwordEntity)entityIn).getItemStack((LivingEntityPatch<?>)entityPatch).m_41720_() instanceof VatanseverItem)) {
            Armature armature = entityPatch.getArmature();
            this.mulPoseStack(poseStack, armature, (LivingEntity)entityIn, (LivingEntityPatch)entityPatch, partialTicks);
            this.setArmaturePose((LivingEntityPatch)entityPatch, armature, partialTicks);
            OpenMatrix4f[] poseMatrices = armature.getPoseMatrices();
            this.renderLayer((LivingEntityRenderer)renderer, (LivingEntityPatch)entityPatch, (LivingEntity)entityIn, poseMatrices, buffer, poseStack, 0xF000F0, partialTicks);
            this.renderDebug(entityIn, entityPatch, (LivingEntityRenderer<E, M>)renderer, buffer, poseStack, partialTicks);
        } else {
            super.render(entityIn, entityPatch, renderer, buffer, poseStack, packedLight, partialTicks);
        }
    }

    protected void addReplaceablePatchedLayer() {
        this.addPatchedLayer(ReplaceableRenderLayer.class, new PatchedReplaceableLayer());
    }

    public void renderDebug(E entityIn, T entityPatch, LivingEntityRenderer<E, M> renderer, MultiBufferSource buffer, PoseStack poseStack, float partialTicks) {
        boolean isGlowing;
        MixinLivingEntityRenderer livingEntityRendererAccessor;
        boolean isVisible;
        Minecraft mc = Minecraft.m_91087_();
        boolean isVisibleToPlayer = !(isVisible = (livingEntityRendererAccessor = (MixinLivingEntityRenderer)renderer).invokeIsBodyVisible(entityIn)) && !entityIn.m_20177_((Player)Objects.requireNonNull(mc.f_91074_));
        RenderType renderType = livingEntityRendererAccessor.invokeGetRenderType(entityIn, isVisible, isVisibleToPlayer, isGlowing = mc.m_91314_(entityIn));
        if (renderType != null && Minecraft.m_91087_().m_91290_().m_114377_()) {
            for (Layer layer : entityPatch.getClientAnimator().getAllLayers()) {
                AnimationPlayer animPlayer = layer.animationPlayer;
                float playTime = animPlayer.getPrevElapsedTime() + (animPlayer.getElapsedTime() - animPlayer.getPrevElapsedTime()) * partialTicks;
                ((DynamicAnimation)animPlayer.getAnimation().get()).renderDebugging(poseStack, buffer, entityPatch, playTime, partialTicks);
            }
        }
    }
}

