/*
 * Decompiled with CFR 0.152.
 */
package net.p1nero.ss.entity.sword.fly_sword;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.p1nero.ss.entity.AbstractArtifactSpiritEntity;
import net.p1nero.ss.entity.SwordSoaringEntities;
import net.p1nero.ss.entity.sword.AbstractSwordEntity;
import net.p1nero.ss.entity.sword.fly_sword.FlySwordArmature;
import net.p1nero.ss.entity.sword.fly_sword.FlySwordPatch;
import net.p1nero.ss.gameassets.SwordSoaringArmatures;
import net.p1nero.ss.gameassets.SwordSoaringDatakeys;
import net.p1nero.ss.gameassets.animations.FlySwordAnimations;
import net.p1nero.ss.util.AnimationUtils;
import net.p1nero.ss.util.vfx.ParticleVFX;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class FlySwordEntity
extends AbstractSwordEntity {
    private int maxTickCount = -1;
    private static final EntityDataAccessor<Boolean> ROTATION_LOCK = SynchedEntityData.m_135353_(FlySwordEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ANIMATION_END = SynchedEntityData.m_135353_(FlySwordEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FLYING_BACK = SynchedEntityData.m_135353_(FlySwordEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> READY_TO_FLY_BACK = SynchedEntityData.m_135353_(FlySwordEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private LivingEntity target;

    public FlySwordEntity(EntityType<? extends AbstractArtifactSpiritEntity> entityType, Level level) {
        super(entityType, level);
    }

    public FlySwordEntity(LivingEntity owner, int maxTickCount, LivingEntity target) {
        super((EntityType<? extends AbstractArtifactSpiritEntity>)((EntityType)SwordSoaringEntities.FLY_SWORD.get()), owner.m_21205_().m_41777_(), owner);
        this.maxTickCount = maxTickCount;
        this.target = target;
        if (target != null && target.m_6084_()) {
            this.m_146884_(target.m_20182_());
        }
        this.m_20242_(true);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(ROTATION_LOCK, (Object)true);
        this.m_20088_().m_135372_(FLYING_BACK, (Object)false);
        this.m_20088_().m_135372_(READY_TO_FLY_BACK, (Object)false);
        this.m_20088_().m_135372_(ANIMATION_END, (Object)false);
    }

    public boolean isRotationLock() {
        return (Boolean)this.m_20088_().m_135370_(ROTATION_LOCK);
    }

    public void setRotationLock(boolean rotationLock) {
        this.m_20088_().m_135381_(ROTATION_LOCK, (Object)rotationLock);
    }

    public boolean isAnimationEnd() {
        return (Boolean)this.m_20088_().m_135370_(ANIMATION_END);
    }

    public void setAnimationEnd(boolean flying) {
        this.m_20088_().m_135381_(ANIMATION_END, (Object)flying);
    }

    public boolean isFlyingBack() {
        return (Boolean)this.m_20088_().m_135370_(FLYING_BACK);
    }

    public void setFlyingBack(boolean flying) {
        this.m_20088_().m_135381_(FLYING_BACK, (Object)flying);
    }

    public boolean isReadyToFlyBack() {
        return (Boolean)this.m_20088_().m_135370_(READY_TO_FLY_BACK);
    }

    public void setReadyToFlyBack(boolean flying) {
        this.m_20088_().m_135381_(READY_TO_FLY_BACK, (Object)flying);
    }

    public boolean callFlyingBack() {
        LivingEntityPatch<?> livingEntityPatch = this.getPatch();
        if (livingEntityPatch instanceof FlySwordPatch) {
            FlySwordPatch flySwordPatch = (FlySwordPatch)livingEntityPatch;
            if (flySwordPatch.getEntityState().inaction()) {
                return false;
            }
            flySwordPatch.playAnimationSynchronized((AssetAccessor)FlySwordAnimations.FLY_SWORD_ATK_FLY_BACK, 0.001f);
            if (this.m_269323_() != null) {
                flySwordPatch.rotateTo((Entity)this.m_269323_(), 30.0f, true);
                this.setReadyToFlyBack(true);
            }
            return true;
        }
        return false;
    }

    public LivingEntity m_5448_() {
        return this.target;
    }

    public void m_6710_(LivingEntity target) {
        this.target = target;
    }

    @Override
    protected void moveToOwner(LivingEntity owner) {
        this.f_19794_ = true;
        if (this.isFlyingBack()) {
            Vec3 vec3 = AnimationUtils.getJointWorldPos(this.getPatch(), ((FlySwordArmature)SwordSoaringArmatures.FLY_SWORD_ARMATURE.get()).body);
            ParticleVFX.createSphereParticles(this.m_9236_(), vec3, (ParticleOptions)ParticleTypes.f_123762_, 0.2, 0.01, 0.05, 100);
            this.flySwordDamage(2.0f, 2.5f);
            if (!this.m_9236_().f_46443_) {
                if (this.m_20182_().m_82554_(owner.m_146892_()) < 1.5) {
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 300, 0.5, 0.5, 0.5, 0.5);
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11937_, owner.m_5720_(), 1.0f, 1.0f);
                    this.addOwnerSwordCount();
                    this.m_146870_();
                    return;
                }
                Vec3 dir = owner.m_146892_().m_82546_(this.m_146892_()).m_82541_().m_82490_((double)0.8f);
                this.m_20256_(dir);
            }
        } else {
            if (this.isReadyToFlyBack()) {
                this.getPatch().rotateTo((Entity)owner, 30.0f, true);
            } else if (this.isRotationLock()) {
                this.m_146922_(0.0f);
                this.m_5618_(0.0f);
                this.m_5616_(0.0f);
            }
            if (!this.m_9236_().f_46443_) {
                if (this.target != null && this.target.m_6084_() && !this.isAnimationEnd()) {
                    this.m_146884_(this.target.m_20182_());
                }
                if (this.f_19797_ == this.maxTickCount) {
                    this.addOwnerSwordCount();
                    this.m_146870_();
                }
            }
        }
        this.f_19794_ = false;
    }

    public void addOwnerSwordCount() {
        ServerPlayerPatch serverPlayerPatch;
        SkillDataManager manager;
        LivingEntityPatch<?> livingEntityPatch = this.getOwnerPatch();
        if (livingEntityPatch instanceof ServerPlayerPatch && (manager = (serverPlayerPatch = (ServerPlayerPatch)livingEntityPatch).getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager()).hasData((SkillDataKey)SwordSoaringDatakeys.SWORD_COUNT.get())) {
            int currentCnt = (Integer)manager.getDataValue((SkillDataKey)SwordSoaringDatakeys.SWORD_COUNT.get());
            manager.setDataSync((SkillDataKey)SwordSoaringDatakeys.SWORD_COUNT.get(), (Object)Math.min(currentCnt + 1, 6));
        }
    }

    public void flySwordDamage(float attractRadius, float damageRadius) {
        if (this.m_269323_() == null) {
            return;
        }
        double baseDamage = this.m_269323_().m_21133_(Attributes.f_22281_) * 3.0;
        Vec3 pos = this.m_20182_();
        if (this.m_9236_() instanceof ServerLevel) {
            AABB damageArea = new AABB(pos.m_7096_() - (double)damageRadius, pos.m_7098_() - (double)damageRadius, pos.m_7094_() - (double)damageRadius, pos.m_7096_() + (double)damageRadius, pos.m_7098_() + (double)damageRadius, pos.m_7094_() + (double)damageRadius);
            List entities = this.m_9236_().m_6443_(LivingEntity.class, damageArea, entity -> {
                Player player;
                return entity.m_6084_() && entity.m_20238_(pos) <= (double)(damageRadius * damageRadius) && (!(entity instanceof Player) || !(player = (Player)entity).m_7500_() && !player.m_5833_()) && entity != this.m_269323_() && !(entity instanceof AbstractArtifactSpiritEntity);
            });
            for (LivingEntity entity2 : new ArrayList(entities)) {
                if (entity2.m_20270_((Entity)this) < attractRadius) {
                    Vec3 entityPos = entity2.m_20182_();
                    Vec3 delta = pos.m_82546_(entityPos);
                    double distance = delta.m_82553_();
                    if (distance > 1.0) {
                        Vec3 direction = delta.m_82541_();
                        double speed = 0.5;
                        entity2.m_20256_(entity2.m_20184_().m_82549_(direction.m_82490_(speed)));
                    } else {
                        Vec3 safePos = pos.m_82546_(delta.m_82541_().m_82490_(1.0));
                        entity2.m_6034_(safePos.f_82479_, safePos.f_82480_, safePos.f_82481_);
                        entity2.m_20256_(Vec3.f_82478_);
                    }
                }
                if (entity2.f_19802_ != 0) continue;
                entity2.m_6469_(this.m_269291_().m_269104_((Entity)this.m_269323_(), (Entity)this.m_269323_()), (float)baseDamage);
                entity2.f_19802_ = 10;
                if (entity2.m_9236_().f_46443_) continue;
                entity2.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 200, 0));
                entity2.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 200, 1));
            }
        }
    }

    @Override
    protected Item getOriginalItem() {
        return null;
    }

    @Override
    protected boolean shouldRemoveWhenOwnerLost() {
        return false;
    }
}

