/*
 * Decompiled with CFR 0.152.
 */
package net.p1nero.ss.entity.sword.gate_of_babylon;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.p1nero.ss.SwordSoaringConfig;
import net.p1nero.ss.entity.AbstractArtifactSpiritEntity;
import net.p1nero.ss.entity.ReplaceableArmature;
import net.p1nero.ss.entity.SwordSoaringEntities;
import net.p1nero.ss.entity.sword.AbstractSwordEntity;
import net.p1nero.ss.gameassets.SwordSoaringArmatures;
import net.p1nero.ss.network.PacketHandler;
import net.p1nero.ss.network.PacketRelay;
import net.p1nero.ss.network.packet.server.RequestBabylonSyncPacket;
import net.p1nero.ss.util.AnimationUtils;
import net.p1nero.ss.util.ItemUtils;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.utils.LevelUtil;
import yesman.epicfight.api.utils.math.OpenMatrix4f;

public class BabylonEntity
extends AbstractSwordEntity {
    private ArrayList<ItemStack> validBabylonItems = new ArrayList();
    private float startYRot;
    private final Map<Integer, OpenMatrix4f> startJointTransformMap = new HashMap<Integer, OpenMatrix4f>();
    private final Map<Integer, Double> jointDamageMap = new HashMap<Integer, Double>();
    private final Map<Integer, Boolean> jointsHittenGroundMap = new HashMap<Integer, Boolean>();
    private boolean clientInit;

    public BabylonEntity(EntityType<? extends AbstractArtifactSpiritEntity> entityType, Level level) {
        super(entityType, level);
        this.m_21008_(InteractionHand.MAIN_HAND, Items.f_42430_.m_7968_());
    }

    public BabylonEntity(EntityType<? extends BabylonEntity> entityType, LivingEntity owner, Vec3 startPos, float yRot) {
        super(entityType, owner.m_21205_().m_41777_(), owner);
        this.m_21008_(InteractionHand.MAIN_HAND, Items.f_42430_.m_7968_());
        this.m_146884_(startPos);
        this.m_5618_(yRot);
        this.m_146922_(yRot);
        this.m_5616_(yRot);
        if (!this.m_9236_().f_46443_) {
            this.startYRot = yRot;
        }
        this.m_20242_(true);
        this.f_19794_ = true;
    }

    public BabylonEntity(LivingEntity owner, Vec3 startPos, float yRot) {
        this((EntityType<? extends BabylonEntity>)((EntityType)SwordSoaringEntities.BABYLON.get()), owner, startPos, yRot);
    }

    public void bindStartTransform(int jointId, OpenMatrix4f startTransform) {
        this.startJointTransformMap.put(jointId, startTransform);
    }

    public OpenMatrix4f getStartTransform(int jointId) {
        return this.startJointTransformMap.get(jointId);
    }

    public int m_19876_() {
        return 16382836;
    }

    public boolean m_142038_() {
        return (Boolean)SwordSoaringConfig.ITEMS_BLOOM.get();
    }

    public void initBabylonItems(ArrayList<ItemStack> babylonItems, boolean shuffle) {
        this.validBabylonItems = babylonItems;
        if (shuffle) {
            Collections.shuffle(this.validBabylonItems);
        }
        if (!this.m_9236_().f_46443_) {
            List<Joint> joints = this.getArmature().getJoints(this.getPatch());
            for (int i = 0; i < joints.size() && i < this.validBabylonItems.size(); ++i) {
                Joint joint = joints.get(i);
                ItemStack itemStack = this.validBabylonItems.get(i);
                this.jointDamageMap.put(joint.getId(), ItemUtils.getItemAttackDamage(this.m_269323_(), itemStack));
            }
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_269323_() != null && this.m_9236_().f_46443_ && !this.clientInit && this.m_269323_().equals((Object)Minecraft.m_91087_().f_91074_)) {
            PacketRelay.sendToServer(PacketHandler.INSTANCE, new RequestBabylonSyncPacket(this.m_19879_()));
            this.clientInit = true;
        }
        if (!this.m_9236_().f_46443_ && !this.jointDamageMap.isEmpty() && this.getPatch() != null && this.shouldGroundSlam() && this.getPatch().getAnimator().getPlayerFor(null).getElapsedTime() > 1.33f) {
            for (int id : this.jointDamageMap.keySet()) {
                if (this.jointsHittenGroundMap.getOrDefault(id, false).booleanValue()) continue;
                Joint joint = this.getArmature().searchJointById(id);
                Vec3 jointPos = AnimationUtils.getJointWorldPos(this.getPatch(), joint);
                if (!(jointPos.m_7098_() <= this.m_20186_() + 0.5)) continue;
                LevelUtil.circleSlamFracture((LivingEntity)this.m_269323_(), (Level)this.m_9236_(), (Vec3)jointPos.m_82520_(0.0, -1.0, 0.0), (double)2.5, (boolean)false);
                this.jointsHittenGroundMap.put(id, true);
                if (!((Boolean)SwordSoaringConfig.REMOVE_ITEM.get()).booleanValue()) continue;
                ItemEntity itemEntity = new ItemEntity(this.m_9236_(), jointPos.f_82479_, jointPos.f_82480_, jointPos.f_82481_, this.validBabylonItems.get(this.getArmature().joints.indexOf(joint)));
                this.m_9236_().m_7967_((Entity)itemEntity);
            }
        }
    }

    @Override
    protected boolean shouldRemoveWhenOwnerLost() {
        return false;
    }

    public boolean shouldGroundSlam() {
        return true;
    }

    public void updateBabylonItems(ArrayList<ItemStack> items) {
        this.validBabylonItems = items;
    }

    public ArrayList<ItemStack> getValidBabylonItems() {
        return this.validBabylonItems;
    }

    public Map<Integer, Double> getJointDamageMap() {
        return this.jointDamageMap;
    }

    public double getJointDamage(Joint joint) {
        return Objects.requireNonNullElse(this.jointDamageMap.get(joint.getId()), 0.0);
    }

    @Override
    protected void moveToOwner(LivingEntity owner) {
        if (!this.m_9236_().f_46443_) {
            this.m_146922_(this.startYRot);
            this.m_5618_(this.startYRot);
            this.m_5616_(this.startYRot);
        }
    }

    @Override
    protected Item getOriginalItem() {
        return null;
    }

    public ReplaceableArmature getArmature() {
        return (ReplaceableArmature)SwordSoaringArmatures.BABYLON_ARMATURE.get();
    }

    public boolean hasJoint(Joint joint) {
        for (int i = 0; i < this.validBabylonItems.size() && i < this.getArmature().joints.size(); ++i) {
            if (this.getArmature().joints.get(i).getId() != joint.getId()) continue;
            return true;
        }
        return false;
    }
}

