/*
 * Decompiled with CFR 0.152.
 */
package net.p1nero.ss.entity.sword.gate_of_babylon.client.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.p1nero.ss.entity.AbstractArtifactSpiritPatch;
import net.p1nero.ss.entity.ReplaceableArmature;
import net.p1nero.ss.entity.sword.gate_of_babylon.BabylonEntity;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.QuaternionUtils;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.renderer.patched.layer.PatchedLayer;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@OnlyIn(value=Dist.CLIENT)
public class PatchedBabylonRandomReplaceableLayer<E extends BabylonEntity, T extends AbstractArtifactSpiritPatch<E>, M extends EntityModel<E>>
extends PatchedLayer<E, T, M, RenderLayer<E, M>> {
    public static final int FADE_TIME = 20;
    public static final int LIFE_TIME = 130;
    public static final ResourceLocation LIGHT_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"sword_soaring", (String)"textures/entity/light_new.png");
    public static final ResourceLocation PORTAL_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"sword_soaring", (String)"textures/entity/portal_new.png");

    protected void renderLayer(T entityPatch, E entity, RenderLayer<E, M> vanillaLayer, PoseStack postStack, MultiBufferSource buffer, int packedLightIn, OpenMatrix4f[] poses, float bob, float yRot, float xRot, float partialTicks) {
        Armature armature = entityPatch.getArmature();
        if (armature instanceof ReplaceableArmature) {
            ReplaceableArmature armature2 = (ReplaceableArmature)armature;
            PatchedBabylonRandomReplaceableLayer.renderItemInJoint(entity, entityPatch, armature2, poses, buffer, postStack, 0xF000F0);
        }
    }

    public static void renderItemInJoint(BabylonEntity entity, AbstractArtifactSpiritPatch<?> artifactSpiritPatch, ReplaceableArmature armature, OpenMatrix4f[] poses, MultiBufferSource buffer, PoseStack poseStack, int packedLight) {
        if (entity.m_269323_() != null) {
            ArrayList<ItemStack> babylons = entity.getValidBabylonItems();
            if (babylons.isEmpty()) {
                return;
            }
            List<Joint> jointList = armature.getJoints((LivingEntityPatch<?>)artifactSpiritPatch);
            for (int i = 0; i < jointList.size() && i < babylons.size(); ++i) {
                Joint joint = jointList.get(i);
                ItemStack itemStack = (ItemStack)babylons.get(i);
                if (itemStack == null) continue;
                OpenMatrix4f jointTransform = poses[joint.getId()];
                if (entity.getStartTransform(joint.getId()) == null && jointTransform.toScaleVector().length() > 0.0f) {
                    PatchedBabylonRandomReplaceableLayer.removeRotationFromMatrix(jointTransform);
                    jointTransform.rotateDeg(90.0f, Vec3f.X_AXIS);
                    entity.bindStartTransform(joint.getId(), jointTransform.removeScale());
                }
                poseStack.m_85836_();
                OpenMatrix4f startMatrix = entity.getStartTransform(joint.getId());
                MathUtils.mulStack((PoseStack)poseStack, (OpenMatrix4f)(startMatrix == null ? jointTransform : startMatrix));
                poseStack.m_252781_(QuaternionUtils.XP.rotationDegrees(90.0f));
                float alpha = 1.0f;
                int currentTickCount = entity.f_19797_ - 15;
                if (currentTickCount < 20) {
                    alpha = (float)currentTickCount * 1.0f / 20.0f;
                }
                if (currentTickCount > 110) {
                    alpha = (float)(130 - currentTickCount) * 1.0f / 20.0f;
                }
                float outerAlpha = alpha;
                float frame = (float)currentTickCount * 1.0f % 20.0f;
                poseStack.m_85836_();
                poseStack.m_85841_(outerAlpha, outerAlpha, outerAlpha);
                poseStack.m_85841_(0.7f, 0.7f, 0.7f);
                PatchedBabylonRandomReplaceableLayer.renderPortal(poseStack, 0.5f, 1.0f, 1.0f, 1.0f, LIGHT_TEXTURE, buffer, frame);
                PatchedBabylonRandomReplaceableLayer.renderPortal(poseStack, 1.0f, 1.0f, 1.0f, 1.0f, PORTAL_TEXTURE, buffer, frame);
                poseStack.m_85849_();
                poseStack.m_85849_();
                poseStack.m_85836_();
                MathUtils.mulStack((PoseStack)poseStack, (OpenMatrix4f)jointTransform);
                ItemDisplayContext transformType = ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
                Minecraft.m_91087_().f_91063_.f_109055_.m_269530_((LivingEntity)artifactSpiritPatch.getOriginal(), itemStack, transformType, false, poseStack, buffer, packedLight);
                poseStack.m_85849_();
            }
        }
    }

    public static void renderPortal(PoseStack poseStack, float alpha, float r, float g, float b, ResourceLocation portalTexture, MultiBufferSource buffer, float frame) {
        poseStack.m_85836_();
        Matrix4f pMatrix = poseStack.m_85850_().m_252922_();
        Matrix3f normal = poseStack.m_85850_().m_252943_();
        VertexConsumer consumer = buffer.m_6299_(RenderType.m_110454_((ResourceLocation)portalTexture, (boolean)false));
        consumer.m_252986_(pMatrix, -1.0f, -1.0f, 0.0f).m_85950_(r, g, b, alpha).m_7421_(0.0f, 0.05f * frame - 0.05f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(pMatrix, 1.0f, -1.0f, 0.0f).m_85950_(r, g, b, alpha).m_7421_(1.0f, 0.05f * frame - 0.05f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(pMatrix, 1.0f, 1.0f, 0.0f).m_85950_(r, g, b, alpha).m_7421_(1.0f, 0.05f * frame).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(pMatrix, -1.0f, 1.0f, 0.0f).m_85950_(r, g, b, alpha).m_7421_(0.0f, 0.05f * frame).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        poseStack.m_85849_();
    }

    public static void removeRotationFromMatrix(OpenMatrix4f matrix) {
        float sx = (float)Math.sqrt(matrix.m00 * matrix.m00 + matrix.m10 * matrix.m10 + matrix.m20 * matrix.m20);
        float sy = (float)Math.sqrt(matrix.m01 * matrix.m01 + matrix.m11 * matrix.m11 + matrix.m21 * matrix.m21);
        float sz = (float)Math.sqrt(matrix.m02 * matrix.m02 + matrix.m12 * matrix.m12 + matrix.m22 * matrix.m22);
        matrix.m00 = sx;
        matrix.m01 = 0.0f;
        matrix.m02 = 0.0f;
        matrix.m10 = 0.0f;
        matrix.m11 = sy;
        matrix.m12 = 0.0f;
        matrix.m20 = 0.0f;
        matrix.m21 = 0.0f;
        matrix.m22 = sz;
    }
}

