/*
 * Decompiled with CFR 0.152.
 */
package net.p1nero.ss.gameassets.animations;

import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.RegistryObject;
import net.p1nero.ss.animation.ArtifactSpiritMultiPhaseAttackAnimation;
import net.p1nero.ss.entity.sword.screen_sword.ScreenSwordArmature;
import net.p1nero.ss.gameassets.SwordSoaringArmatures;
import net.p1nero.ss.gameassets.animations.VatanseverAnimations;
import net.p1nero.ss.util.AnimationUtils;
import net.p1nero.ss.util.vfx.ParticleVFX;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.property.AnimationEvent;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.ActionAnimation;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.model.armature.HumanoidArmature;
import yesman.epicfight.particle.EpicFightParticles;

public class ScreenSwordAnimations {
    public static AnimationManager.AnimationAccessor<StaticAnimation> SCREEN_SWORD_IDLE;
    public static AnimationManager.AnimationAccessor<AttackAnimation> KILL_AURA_1;
    public static AnimationManager.AnimationAccessor<ActionAnimation> KILL_AURA_1_SUMMON;
    public static AnimationManager.AnimationAccessor<AttackAnimation> KILL_AURA_2;
    public static AnimationManager.AnimationAccessor<ActionAnimation> KILL_AURA_2_SUMMON;
    public static AnimationManager.AnimationAccessor<ActionAnimation> SCREEN_SWORD;
    public static AnimationManager.AnimationAccessor<ActionAnimation> SCREEN_SWORD_SUMMON;
    public static AnimationManager.AnimationAccessor<ActionAnimation> PLAYER_SUMMON_RAIN_SWORD;
    public static AnimationManager.AnimationAccessor<ActionAnimation> PLAYER_SUMMON_SCREEN_SWORD;
    public static AnimationManager.AnimationAccessor<ActionAnimation> PLAYER_SUMMON_KILL_AURA_1;
    public static AnimationManager.AnimationAccessor<ActionAnimation> PLAYER_SUMMON_KILL_AURA_2;
    public static AnimationEvent.InTimeEvent RESET_ANIM;
    public static AnimationEvent SET_GLOWING;

    public static AnimationEvent.InTimeEvent spawnSummonParticle(float time, Supplier<ParticleOptions> particleOptionsSupplier1, Supplier<ParticleOptions> particleOptionsSupplier2) {
        return AnimationEvent.InTimeEvent.create((float)time, (entityPatch, self, params) -> {
            OpenMatrix4f transformMatrix = entityPatch.getArmature().getBoundTransformFor(entityPatch.getAnimator().getPose(0.0f), entityPatch.getArmature() instanceof HumanoidArmature ? ((HumanoidArmature)Armatures.BIPED.get()).toolR : ((HumanoidArmature)Armatures.BIPED.get()).rootJoint);
            transformMatrix.translate(new Vec3f(0.0f, 0.0f, 0.0f));
            OpenMatrix4f.mul((OpenMatrix4f)new OpenMatrix4f().rotate(-((float)Math.toRadians(((LivingEntity)entityPatch.getOriginal()).f_20884_ + 180.0f)), new Vec3f(0.0f, 1.0f, 0.0f)), (OpenMatrix4f)transformMatrix, (OpenMatrix4f)transformMatrix);
            int n = 70;
            double r = 0.1;
            for (int i = 0; i < n; ++i) {
                double theta = 6.28 * new Random().nextDouble();
                double phi = Math.acos(2.0 * new Random().nextDouble() - 1.0);
                double x = r * Math.sin(phi) * Math.cos(theta);
                double y = r * Math.sin(phi) * Math.sin(theta);
                double z = r * Math.cos(phi);
                ((LivingEntity)entityPatch.getOriginal()).m_9236_().m_7106_((ParticleOptions)particleOptionsSupplier1.get(), (double)transformMatrix.m30 + ((LivingEntity)entityPatch.getOriginal()).m_20185_(), (double)transformMatrix.m31 + ((LivingEntity)entityPatch.getOriginal()).m_20186_(), (double)transformMatrix.m32 + ((LivingEntity)entityPatch.getOriginal()).m_20189_(), (double)((float)x), (double)((float)y), (double)((float)z));
                if (i % 2 != 0) continue;
                ((LivingEntity)entityPatch.getOriginal()).m_9236_().m_7106_((ParticleOptions)particleOptionsSupplier2.get(), (double)transformMatrix.m30 + ((LivingEntity)entityPatch.getOriginal()).m_20185_(), (double)transformMatrix.m31 + ((LivingEntity)entityPatch.getOriginal()).m_20186_(), (double)transformMatrix.m32 + ((LivingEntity)entityPatch.getOriginal()).m_20189_(), (double)((float)x), (double)((float)y), (double)((float)z));
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.CLIENT);
    }

    public static AnimationEvent.InTimeEvent spawnParticles(float time, Supplier<List<Joint>> joints, int count, Supplier<ParticleOptions> particleOptions) {
        return AnimationEvent.InTimeEvent.create((float)time, (livingEntityPatch, staticAnimation, objects) -> {
            for (Joint joint : (List)joints.get()) {
                Vec3 worldPos = AnimationUtils.getJointWorldPos(livingEntityPatch, joint);
                for (int i = 0; i < count; ++i) {
                    ((ServerLevel)((LivingEntity)livingEntityPatch.getOriginal()).m_9236_()).m_8767_((ParticleOptions)particleOptions.get(), worldPos.f_82479_, worldPos.f_82480_, worldPos.f_82481_, count, 0.0, 0.0, 0.0, 0.1);
                }
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER);
    }

    public static AnimationEvent.InTimeEvent spawnFireParticle(float time, Supplier<List<Joint>> joints, int count) {
        return ScreenSwordAnimations.spawnParticles(time, joints, count, () -> ParticleTypes.f_123744_);
    }

    public static AnimationEvent.InTimeEvent spawnStaticHexagram(float time, Supplier<ParticleOptions> particleOptions, float interval, float radius, float height) {
        return AnimationEvent.InTimeEvent.create((float)time, (livingEntityPatch, staticAnimation, objects) -> ParticleVFX.createHexagramParticle((ParticleOptions)particleOptions.get(), ((LivingEntity)livingEntityPatch.getOriginal()).m_9236_(), ((LivingEntity)livingEntityPatch.getOriginal()).m_20182_().m_82520_(0.0, (double)height, 0.0), interval, radius, time / ((StaticAnimation)staticAnimation.get()).getTotalTime() * 360.0f), (AnimationEvent.Side)AnimationEvent.Side.CLIENT);
    }

    public static AnimationEvent.InTimeEvent spawnStaticHexagram(float time, Supplier<ParticleOptions> particleOptions, float interval, float radius) {
        return ScreenSwordAnimations.spawnStaticHexagram(time, particleOptions, interval, radius, 1.0f);
    }

    public static AnimationEvent.InTimeEvent spawnDynamicHexagram(float time, Supplier<ParticleOptions> particleOptions, int count, Supplier<ScreenSwordArmature> armature) {
        return AnimationEvent.InTimeEvent.create((float)time, (livingEntityPatch, staticAnimation, objects) -> {
            ParticleVFX.createLineBetweenJoint(livingEntityPatch, ((ScreenSwordArmature)((Object)((Object)armature.get()))).W4, ((ScreenSwordArmature)((Object)((Object)armature.get()))).W3, (ParticleOptions)particleOptions.get(), count);
            ParticleVFX.createLineBetweenJoint(livingEntityPatch, ((ScreenSwordArmature)((Object)((Object)armature.get()))).W3, ((ScreenSwordArmature)((Object)((Object)armature.get()))).W5, (ParticleOptions)particleOptions.get(), count);
            ParticleVFX.createLineBetweenJoint(livingEntityPatch, ((ScreenSwordArmature)((Object)((Object)armature.get()))).W5, ((ScreenSwordArmature)((Object)((Object)armature.get()))).W4, (ParticleOptions)particleOptions.get(), count);
            ParticleVFX.createLineBetweenJoint(livingEntityPatch, ((ScreenSwordArmature)((Object)((Object)armature.get()))).W1, ((ScreenSwordArmature)((Object)((Object)armature.get()))).W2, (ParticleOptions)particleOptions.get(), count);
            ParticleVFX.createLineBetweenJoint(livingEntityPatch, ((ScreenSwordArmature)((Object)((Object)armature.get()))).W2, ((ScreenSwordArmature)((Object)((Object)armature.get()))).W6, (ParticleOptions)particleOptions.get(), count);
            ParticleVFX.createLineBetweenJoint(livingEntityPatch, ((ScreenSwordArmature)((Object)((Object)armature.get()))).W6, ((ScreenSwordArmature)((Object)((Object)armature.get()))).W1, (ParticleOptions)particleOptions.get(), count);
        }, (AnimationEvent.Side)AnimationEvent.Side.CLIENT);
    }

    public static AnimationEvent onEndPlay(AnimationManager.AnimationAccessor<? extends StaticAnimation> provider) {
        return AnimationEvent.SimpleEvent.create((livingEntityPatch, staticAnimation, objects) -> livingEntityPatch.reserveAnimation((AssetAccessor)provider), (AnimationEvent.Side)AnimationEvent.Side.SERVER);
    }

    public static AnimationEvent.InTimeEvent setGlowing(float time) {
        return AnimationEvent.InTimeEvent.create((float)time, (livingEntityPatch, staticAnimation, objects) -> ((LivingEntity)livingEntityPatch.getOriginal()).m_146915_(true), (AnimationEvent.Side)AnimationEvent.Side.SERVER);
    }

    public static AnimationEvent.InTimeEvent playSound(float time, Supplier<SoundEvent> soundEventSupplier, float minPitch, float maxPitch, float volume) {
        return AnimationEvent.InTimeEvent.create((float)time, (livingEntityPatch, staticAnimation, objects) -> livingEntityPatch.playSound((SoundEvent)soundEventSupplier.get(), volume, minPitch, maxPitch), (AnimationEvent.Side)AnimationEvent.Side.SERVER);
    }

    public static void buildScreenSwordAnim(AnimationManager.AnimationBuilder builder) {
        Armatures.ArmatureAccessor<ScreenSwordArmature> screenSwordArmature = SwordSoaringArmatures.SCREEN_SWORD_ARMATURE;
        SCREEN_SWORD_IDLE = builder.nextAccessor("screen_sword/screen_sword_idle", accessor -> new StaticAnimation(true, accessor, (AssetAccessor)screenSwordArmature).addProperty(AnimationProperty.StaticAnimationProperty.PLAY_SPEED_MODIFIER, (dynamicAnimation, livingEntityPatch, v, v1, v2) -> 2.0f));
        KILL_AURA_1 = builder.nextAccessor("screen_sword/kill_aura_1", accessor -> (AttackAnimation)new ArtifactSpiritMultiPhaseAttackAnimation(0.001f, (AnimationManager.AnimationAccessor<? extends AttackAnimation>)accessor, (AssetAccessor<? extends Armature>)screenSwordArmature, AnimationUtils.getPhases(((ScreenSwordArmature)screenSwordArmature.get()).joints, 0.5f)).addProperty(AnimationProperty.AttackPhaseProperty.MAX_STRIKES_MODIFIER, ValueModifier.setter((float)10.0f)).addProperty(AnimationProperty.StaticAnimationProperty.PLAY_SPEED_MODIFIER, (dynamicAnimation, livingEntityPatch, v, v1, v2) -> 0.2f).addEvents(new AnimationEvent[]{RESET_ANIM, ScreenSwordAnimations.spawnDynamicHexagram(0.05f, () -> ParticleTypes.f_175828_, 30, (Supplier<ScreenSwordArmature>)screenSwordArmature), ScreenSwordAnimations.playSound(0.05f, () -> SoundEvents.f_144054_, -0.5f, 0.5f, 2.5f), ScreenSwordAnimations.spawnStaticHexagram(0.25f, () -> ParticleTypes.f_123810_, 0.2f, 2.0f, 0.0f), ScreenSwordAnimations.playSound(0.25f, () -> SoundEvents.f_144054_, -0.5f, 0.5f, 2.5f), ScreenSwordAnimations.playSound(0.45f, () -> SoundEvents.f_144049_, -0.5f, 0.5f, 2.5f), ScreenSwordAnimations.spawnDynamicHexagram(0.45f, () -> ParticleTypes.f_175829_, 30, (Supplier<ScreenSwordArmature>)screenSwordArmature)}));
        KILL_AURA_1_SUMMON = builder.nextAccessor("screen_sword/kill_aura_1_summon", accessor -> (ActionAnimation)new ActionAnimation(0.15f, accessor, (AssetAccessor)screenSwordArmature).addEvents(new AnimationEvent[]{ScreenSwordAnimations.spawnDynamicHexagram(0.05f, () -> ParticleTypes.f_175828_, 30, (Supplier<ScreenSwordArmature>)screenSwordArmature), ScreenSwordAnimations.spawnStaticHexagram(0.25f, () -> ParticleTypes.f_123810_, 0.2f, 4.0f), ScreenSwordAnimations.spawnDynamicHexagram(0.45f, () -> ParticleTypes.f_175829_, 30, (Supplier<ScreenSwordArmature>)screenSwordArmature)}).addProperty(AnimationProperty.StaticAnimationProperty.PLAY_SPEED_MODIFIER, (dynamicAnimation, livingEntityPatch, v, v1, v2) -> 0.5f).addEvents(AnimationProperty.StaticAnimationProperty.ON_BEGIN_EVENTS, new AnimationEvent[]{SET_GLOWING}).addEvents(AnimationProperty.StaticAnimationProperty.ON_END_EVENTS, new AnimationEvent[]{ScreenSwordAnimations.onEndPlay(KILL_AURA_1)}));
        KILL_AURA_2 = builder.nextAccessor("screen_sword/kill_aura_2", accessor -> {
            AnimationEvent[] animationEventArray = new AnimationEvent[4];
            animationEventArray[0] = RESET_ANIM;
            animationEventArray[1] = ScreenSwordAnimations.spawnFireParticle(0.1f, () -> ((ScreenSwordArmature)screenSwordArmature.get()).joints, 5);
            animationEventArray[2] = ScreenSwordAnimations.spawnParticles(0.3f, () -> ((ScreenSwordArmature)screenSwordArmature.get()).joints, 5, () -> ((RegistryObject)EpicFightParticles.BLOOD).get());
            animationEventArray[3] = ScreenSwordAnimations.spawnSummonParticle(0.49f, () -> ParticleTypes.f_123744_, () -> ParticleTypes.f_123756_);
            return (AttackAnimation)new ArtifactSpiritMultiPhaseAttackAnimation(0.001f, (AnimationManager.AnimationAccessor<? extends AttackAnimation>)accessor, (AssetAccessor<? extends Armature>)screenSwordArmature, AnimationUtils.getPhases(((ScreenSwordArmature)screenSwordArmature.get()).joints, 0.5f)).addProperty(AnimationProperty.AttackPhaseProperty.MAX_STRIKES_MODIFIER, ValueModifier.setter((float)10.0f)).addProperty(AnimationProperty.StaticAnimationProperty.PLAY_SPEED_MODIFIER, (dynamicAnimation, livingEntityPatch, v, v1, v2) -> 0.2f).addEvents(AnimationProperty.StaticAnimationProperty.ON_BEGIN_EVENTS, new AnimationEvent[]{AnimationEvent.SimpleEvent.create((livingEntityPatch, staticAnimation, objects) -> livingEntityPatch.playSound(SoundEvents.f_11936_, 0.0f, 0.0f), (AnimationEvent.Side)AnimationEvent.Side.SERVER)}).addEvents(animationEventArray);
        });
        KILL_AURA_2_SUMMON = builder.nextAccessor("screen_sword/kill_aura_2_summon", accessor -> {
            AnimationEvent[] animationEventArray = new AnimationEvent[1];
            animationEventArray[0] = ScreenSwordAnimations.spawnParticles(0.3f, () -> ((ScreenSwordArmature)screenSwordArmature.get()).joints, 5, () -> ((RegistryObject)EpicFightParticles.BLOOD).get());
            return (ActionAnimation)new ActionAnimation(0.15f, accessor, (AssetAccessor)screenSwordArmature).addEvents(animationEventArray).addProperty(AnimationProperty.StaticAnimationProperty.PLAY_SPEED_MODIFIER, (dynamicAnimation, livingEntityPatch, v, v1, v2) -> 0.5f).addEvents(AnimationProperty.StaticAnimationProperty.ON_END_EVENTS, new AnimationEvent[]{ScreenSwordAnimations.onEndPlay(KILL_AURA_2)});
        });
        SCREEN_SWORD = builder.nextAccessor("screen_sword/screen_sword", accessor -> (ActionAnimation)new ActionAnimation(0.001f, accessor, (AssetAccessor)screenSwordArmature).addProperty(AnimationProperty.StaticAnimationProperty.PLAY_SPEED_MODIFIER, (dynamicAnimation, livingEntityPatch, v, v1, v2) -> 0.1f).addEvents(new AnimationEvent[]{RESET_ANIM}));
        SCREEN_SWORD_SUMMON = builder.nextAccessor("screen_sword/screen_sword_summon", accessor -> (ActionAnimation)new ActionAnimation(0.15f, accessor, (AssetAccessor)screenSwordArmature).addProperty(AnimationProperty.StaticAnimationProperty.PLAY_SPEED_MODIFIER, (dynamicAnimation, livingEntityPatch, v, v1, v2) -> 0.5f).addEvents(AnimationProperty.StaticAnimationProperty.ON_BEGIN_EVENTS, new AnimationEvent[]{SET_GLOWING}).addEvents(AnimationProperty.StaticAnimationProperty.ON_END_EVENTS, new AnimationEvent[]{ScreenSwordAnimations.onEndPlay(SCREEN_SWORD)}));
        Armatures.ArmatureAccessor biped = Armatures.BIPED;
        PLAYER_SUMMON_RAIN_SWORD = builder.nextAccessor("screen_sword/rain_sword_summon_player", accessor -> (ActionAnimation)new ActionAnimation(0.15f, accessor, (AssetAccessor)biped).addEvents(new AnimationEvent[]{AnimationEvent.InTimeEvent.create((float)0.7f, (livingEntityPatch, staticAnimation, objects) -> VatanseverAnimations.groundSplit(livingEntityPatch, 0.0, 0.0, 0.0, 0.0, 0.0f, 2.0f, 0), (AnimationEvent.Side)AnimationEvent.Side.BOTH), ScreenSwordAnimations.spawnSummonParticle(0.5f, () -> ParticleTypes.f_123810_, () -> ParticleTypes.f_175829_), ScreenSwordAnimations.spawnSummonParticle(2.3f, () -> ParticleTypes.f_123810_, () -> ParticleTypes.f_123796_)}));
        PLAYER_SUMMON_SCREEN_SWORD = builder.nextAccessor("screen_sword/screen_sword_summon_player", accessor -> (ActionAnimation)new ActionAnimation(0.15f, accessor, (AssetAccessor)biped).addEvents(new AnimationEvent[]{AnimationEvent.InTimeEvent.create((float)0.7f, (livingEntityPatch, staticAnimation, objects) -> {
            VatanseverAnimations.groundSplit(livingEntityPatch, 0.0, 0.0, 0.0, 0.0, 0.0f, 2.0f, 0);
            ParticleVFX.createSphereParticles(((LivingEntity)livingEntityPatch.getOriginal()).m_9236_(), ((LivingEntity)livingEntityPatch.getOriginal()).m_146892_(), (ParticleOptions)ParticleTypes.f_123810_, 5.0, 0.1, 0.2, 100);
        }, (AnimationEvent.Side)AnimationEvent.Side.BOTH), ScreenSwordAnimations.spawnSummonParticle(2.3f, () -> ParticleTypes.f_123810_, () -> ParticleTypes.f_123796_), ScreenSwordAnimations.playSound(1.7f, () -> SoundEvents.f_11668_, -0.5f, 0.0f, 1.0f), ScreenSwordAnimations.playSound(1.7f, () -> SoundEvents.f_11699_, -0.5f, 0.0f, 2.5f), ScreenSwordAnimations.setGlowing(1.7f)}));
        PLAYER_SUMMON_KILL_AURA_1 = builder.nextAccessor("screen_sword/kill_aura_1_summon_player", accessor -> (ActionAnimation)new ActionAnimation(0.15f, accessor, (AssetAccessor)biped).addEvents(new AnimationEvent[]{AnimationEvent.InTimeEvent.create((float)0.7f, (livingEntityPatch, staticAnimation, objects) -> VatanseverAnimations.groundSplit(livingEntityPatch, 0.0, 0.0, 0.0, 0.0, 0.0f, 2.0f, 0), (AnimationEvent.Side)AnimationEvent.Side.BOTH), ScreenSwordAnimations.playSound(0.25f, () -> SoundEvents.f_144054_, 0.0f, 0.1f, 0.6f), ScreenSwordAnimations.playSound(0.45f, () -> SoundEvents.f_144054_, 0.0f, 0.5f, 0.8f), ScreenSwordAnimations.playSound(0.7f, () -> SoundEvents.f_144054_, 0.5f, 1.0f, 1.0f), ScreenSwordAnimations.spawnStaticHexagram(0.7f, () -> ParticleTypes.f_123810_, 0.2f, 2.0f, 3.0f), ScreenSwordAnimations.spawnStaticHexagram(0.7f, () -> ParticleTypes.f_123810_, 0.2f, 2.0f), ScreenSwordAnimations.spawnStaticHexagram(1.7f, () -> ParticleTypes.f_175829_, 0.2f, 4.0f), ScreenSwordAnimations.spawnStaticHexagram(0.7f, () -> ParticleTypes.f_175828_, 0.2f, 3.0f), ScreenSwordAnimations.spawnSummonParticle(2.3f, () -> ParticleTypes.f_123810_, () -> ParticleTypes.f_175829_)}));
        PLAYER_SUMMON_KILL_AURA_2 = builder.nextAccessor("screen_sword/kill_aura_2_summon_player", accessor -> (ActionAnimation)new ActionAnimation(0.15f, accessor, (AssetAccessor)biped).addEvents(new AnimationEvent[]{AnimationEvent.InTimeEvent.create((float)0.7f, (livingEntityPatch, staticAnimation, objects) -> VatanseverAnimations.groundSplit(livingEntityPatch, 0.0, 0.0, 0.0, 0.0, 0.0f, 2.0f, 0), (AnimationEvent.Side)AnimationEvent.Side.BOTH), AnimationEvent.InTimeEvent.create((float)0.7f, (livingEntityPatch, staticAnimation, objects) -> livingEntityPatch.playSound(SoundEvents.f_11937_, 0.0f, 0.3f), (AnimationEvent.Side)AnimationEvent.Side.SERVER), ScreenSwordAnimations.spawnSummonParticle(0.5f, () -> ParticleTypes.f_123744_, () -> ParticleTypes.f_123756_), ScreenSwordAnimations.spawnSummonParticle(2.3f, () -> ParticleTypes.f_123744_, () -> ParticleTypes.f_123756_)}));
    }

    static {
        RESET_ANIM = AnimationEvent.InTimeEvent.create((float)0.49f, (livingEntityPatch, staticAnimation, objects) -> livingEntityPatch.reserveAnimation(staticAnimation), (AnimationEvent.Side)AnimationEvent.Side.SERVER);
        SET_GLOWING = AnimationEvent.SimpleEvent.create((livingEntityPatch, staticAnimation, objects) -> ((LivingEntity)livingEntityPatch.getOriginal()).m_146915_(true), (AnimationEvent.Side)AnimationEvent.Side.SERVER);
    }
}

