/*
 * Decompiled with CFR 0.152.
 */
package net.p1nero.ss.gameassets.animations;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.p1nero.ss.animation.AutoDiscardActionAnimation;
import net.p1nero.ss.entity.AbstractArtifactSpiritEntity;
import net.p1nero.ss.entity.vatansever_storm.VatanseverStormArmature;
import net.p1nero.ss.entity.vatansever_storm.VatanseverStormEntity;
import net.p1nero.ss.entity.vatansever_storm.VatanseverStormEntityPatch;
import net.p1nero.ss.gameassets.SwordSoaringArmatures;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.property.AnimationEvent;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.ActionAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class VatanseverStormAnimations {
    public static AnimationManager.AnimationAccessor<StaticAnimation> VATANSEVER_STORM_IDLE;
    public static AnimationManager.AnimationAccessor<ActionAnimation> VATANSEVER_STORM_UP;
    public static AnimationManager.AnimationAccessor<ActionAnimation> VATANSEVER_STORM_MIDDLE;
    public static AnimationManager.AnimationAccessor<ActionAnimation> VATANSEVER_STORM_MIDDLE_2;
    public static AnimationManager.AnimationAccessor<ActionAnimation> VATANSEVER_STORM_DOWN;
    public static AnimationManager.AnimationAccessor<ActionAnimation> VATANSEVER_STORM_RISE_1;
    public static AnimationManager.AnimationAccessor<ActionAnimation> VATANSEVER_STORM_RISE_2;
    public static AnimationManager.AnimationAccessor<ActionAnimation> VATANSEVER_STORM_RISE_3;
    public static AnimationManager.AnimationAccessor<ActionAnimation> VATANSEVER_STORM_RISE_4;

    public static void buildVatanseverStormAnim(AnimationManager.AnimationBuilder builder) {
        Armatures.ArmatureAccessor<VatanseverStormArmature> stormArmature = SwordSoaringArmatures.VATANSEVER_STORM_ARMATURE;
        VATANSEVER_STORM_IDLE = builder.nextAccessor("vatansever_storm/vatansever_storm_idle", accessor -> new StaticAnimation(true, accessor, (AssetAccessor)stormArmature));
        VATANSEVER_STORM_UP = builder.nextAccessor("vatansever_storm/vatansever_storm_up", accessor -> (ActionAnimation)new ActionAnimation(1.0E-4f, accessor, (AssetAccessor)stormArmature).addEvents(new AnimationEvent[]{AnimationEvent.InPeriodEvent.create((float)0.0f, (float)3.0f, (entityPatch, self, params) -> VatanseverStormAnimations.stormVFX(entityPatch), (AnimationEvent.Side)AnimationEvent.Side.CLIENT)}).addEvents(AnimationProperty.StaticAnimationProperty.ON_END_EVENTS, new AnimationEvent[]{AnimationEvent.SimpleEvent.create((livingEntityPatch, staticAnimation, objects) -> livingEntityPatch.reserveAnimation(VATANSEVER_STORM_UP), (AnimationEvent.Side)AnimationEvent.Side.SERVER)}).addProperty(AnimationProperty.StaticAnimationProperty.PLAY_SPEED_MODIFIER, (dynamicAnimation, livingEntityPatch, v, v1, v2) -> 0.8f));
        VATANSEVER_STORM_MIDDLE = builder.nextAccessor("vatansever_storm/vatansever_storm_middle", accessor -> (ActionAnimation)new ActionAnimation(1.0E-4f, accessor, (AssetAccessor)stormArmature).addEvents(new AnimationEvent[]{AnimationEvent.InPeriodEvent.create((float)0.0f, (float)3.0f, (entityPatch, self, params) -> VatanseverStormAnimations.stormVFX(entityPatch), (AnimationEvent.Side)AnimationEvent.Side.CLIENT)}).addEvents(AnimationProperty.StaticAnimationProperty.ON_END_EVENTS, new AnimationEvent[]{AnimationEvent.SimpleEvent.create((livingEntityPatch, staticAnimation, objects) -> livingEntityPatch.reserveAnimation(VATANSEVER_STORM_MIDDLE), (AnimationEvent.Side)AnimationEvent.Side.SERVER)}).addProperty(AnimationProperty.StaticAnimationProperty.PLAY_SPEED_MODIFIER, (dynamicAnimation, livingEntityPatch, v, v1, v2) -> 0.9f));
        VATANSEVER_STORM_MIDDLE_2 = builder.nextAccessor("vatansever_storm/vatansever_storm_middle_2", accessor -> (ActionAnimation)new ActionAnimation(1.0E-4f, accessor, (AssetAccessor)stormArmature).addEvents(new AnimationEvent[]{AnimationEvent.InPeriodEvent.create((float)0.0f, (float)3.0f, (entityPatch, self, params) -> {
            VatanseverStormAnimations.stormVFX(entityPatch);
            if (entityPatch instanceof VatanseverStormEntityPatch) {
                VatanseverStormEntityPatch vatanseverStormEntityPatch = (VatanseverStormEntityPatch)entityPatch;
                VatanseverStormAnimations.stormDamage(vatanseverStormEntityPatch, 35.0f, 2.0f, 25.0f);
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.BOTH)}).addEvents(AnimationProperty.StaticAnimationProperty.ON_END_EVENTS, new AnimationEvent[]{AnimationEvent.SimpleEvent.create((livingEntityPatch, staticAnimation, objects) -> livingEntityPatch.reserveAnimation(VATANSEVER_STORM_MIDDLE_2), (AnimationEvent.Side)AnimationEvent.Side.SERVER)}).addProperty(AnimationProperty.StaticAnimationProperty.PLAY_SPEED_MODIFIER, (dynamicAnimation, livingEntityPatch, v, v1, v2) -> 0.9f));
        VATANSEVER_STORM_DOWN = builder.nextAccessor("vatansever_storm/vatansever_storm_down", accessor -> (ActionAnimation)new ActionAnimation(1.0E-4f, accessor, (AssetAccessor)stormArmature).addEvents(new AnimationEvent[]{AnimationEvent.InPeriodEvent.create((float)0.0f, (float)3.0f, (entityPatch, self, params) -> VatanseverStormAnimations.stormVFX(entityPatch), (AnimationEvent.Side)AnimationEvent.Side.CLIENT)}).addEvents(AnimationProperty.StaticAnimationProperty.ON_END_EVENTS, new AnimationEvent[]{AnimationEvent.SimpleEvent.create((livingEntityPatch, staticAnimation, objects) -> livingEntityPatch.reserveAnimation(VATANSEVER_STORM_DOWN), (AnimationEvent.Side)AnimationEvent.Side.SERVER)}).addProperty(AnimationProperty.StaticAnimationProperty.PLAY_SPEED_MODIFIER, (dynamicAnimation, livingEntityPatch, v, v1, v2) -> 0.8f));
        VATANSEVER_STORM_RISE_1 = builder.nextAccessor("vatansever_storm/vatansever_storm_rise_1", accessor -> new AutoDiscardActionAnimation(1.0E-4f, (AnimationManager.AnimationAccessor<? extends ActionAnimation>)accessor, (AssetAccessor<? extends Armature>)stormArmature));
        VATANSEVER_STORM_RISE_2 = builder.nextAccessor("vatansever_storm/vatansever_storm_rise_2", accessor -> new AutoDiscardActionAnimation(1.0E-4f, (AnimationManager.AnimationAccessor<? extends ActionAnimation>)accessor, (AssetAccessor<? extends Armature>)stormArmature));
        VATANSEVER_STORM_RISE_3 = builder.nextAccessor("vatansever_storm/vatansever_storm_rise_3", accessor -> new AutoDiscardActionAnimation(1.0E-4f, (AnimationManager.AnimationAccessor<? extends ActionAnimation>)accessor, (AssetAccessor<? extends Armature>)stormArmature));
        VATANSEVER_STORM_RISE_4 = builder.nextAccessor("vatansever_storm/vatansever_storm_rise_4", accessor -> new AutoDiscardActionAnimation(1.0E-4f, (AnimationManager.AnimationAccessor<? extends ActionAnimation>)accessor, (AssetAccessor<? extends Armature>)stormArmature));
    }

    private static void stormParticle(VatanseverStormEntityPatch vatanseverStormEntityPatch, Joint toolJoint, int particleCount) {
        int j;
        float currentY;
        float z;
        float y;
        float x;
        float zOffset;
        float yOffset;
        float xOffset;
        int i;
        VatanseverStormEntity vatanseverStormEntity = (VatanseverStormEntity)vatanseverStormEntityPatch.getOriginal();
        if (vatanseverStormEntity.m_269323_() == null) {
            return;
        }
        Level world = vatanseverStormEntity.m_9236_();
        RandomSource random = world.f_46441_;
        float minSpeed = -0.5f;
        float maxSpeed = 0.5f;
        float rxv = minSpeed + (maxSpeed - minSpeed) * random.m_188501_();
        float ryv = minSpeed + (maxSpeed - minSpeed) * random.m_188501_();
        float rzv = minSpeed + (maxSpeed - minSpeed) * random.m_188501_();
        OpenMatrix4f transformMatrix = vatanseverStormEntityPatch.getArmature().getBoundTransformFor(vatanseverStormEntityPatch.getAnimator().getPose(1.0f), toolJoint);
        OpenMatrix4f rotation = new OpenMatrix4f().rotate(-((float)Math.toRadians(vatanseverStormEntity.f_20883_ + 180.0f)), new Vec3f(0.0f, 1.0f, 0.0f));
        OpenMatrix4f.mul((OpenMatrix4f)rotation, (OpenMatrix4f)transformMatrix, (OpenMatrix4f)transformMatrix);
        float baseX = transformMatrix.m30 + (float)vatanseverStormEntity.m_20185_();
        float baseY = transformMatrix.m31 + (float)vatanseverStormEntity.m_20186_();
        float baseZ = transformMatrix.m32 + (float)vatanseverStormEntity.m_20189_();
        for (i = 0; i < 5 * particleCount; ++i) {
            while ((xOffset = random.m_188501_() * 4.0f - 2.0f) * xOffset + (yOffset = random.m_188501_() * 4.0f - 2.0f) * yOffset + (zOffset = random.m_188501_() * 4.0f - 2.0f) * zOffset > 4.0f) {
            }
            x = baseX + xOffset;
            y = baseY + yOffset;
            z = baseZ + zOffset;
            world.m_6493_((ParticleOptions)ParticleTypes.f_123746_, true, (double)x, (double)y, (double)z, (double)rxv, (double)ryv, (double)rzv);
            if (!(random.m_188501_() < 0.05f)) continue;
            currentY = y;
            for (j = 0; j < 15; ++j) {
                world.m_6493_((ParticleOptions)ParticleTypes.f_123762_, true, (double)(x + (random.m_188501_() - 0.5f) * 0.2f), (double)(currentY -= 3.0f), (double)(z + (random.m_188501_() - 0.5f) * 0.2f), 0.0, (double)-0.2f, 0.0);
            }
        }
        for (i = 0; i < 2 * particleCount; ++i) {
            while ((xOffset = random.m_188501_() * 4.0f - 2.0f) * xOffset + (yOffset = random.m_188501_() * 4.0f - 2.0f) * yOffset + (zOffset = random.m_188501_() * 4.0f - 2.0f) * zOffset > 4.0f) {
            }
            x = baseX + xOffset;
            y = baseY + yOffset;
            z = baseZ + zOffset;
            world.m_6493_((ParticleOptions)ParticleTypes.f_123755_, true, (double)x, (double)y, (double)z, (double)rxv, (double)ryv, (double)rzv);
            if (!(random.m_188501_() < 0.05f)) continue;
            currentY = y;
            for (j = 0; j < 20; ++j) {
                world.m_6493_((ParticleOptions)ParticleTypes.f_123762_, true, (double)(x + (random.m_188501_() - 0.5f) * 0.2f), (double)(currentY -= 2.0f), (double)(z + (random.m_188501_() - 0.5f) * 0.2f), 0.0, (double)-0.2f, 0.0);
            }
        }
    }

    public static void stormDamage(VatanseverStormEntityPatch vatanseverStormEntityPatch, float attractRadius, float damage, float damageRadius) {
        VatanseverStormEntity storm = (VatanseverStormEntity)vatanseverStormEntityPatch.getOriginal();
        LivingEntity source = storm.m_269323_();
        Vec3 Pos = storm.m_20182_();
        Level level = storm.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            AABB area = new AABB(Pos.f_82479_ - (double)attractRadius, Pos.f_82480_ - (double)attractRadius, Pos.f_82481_ - (double)attractRadius, Pos.f_82479_ + (double)attractRadius, Pos.f_82480_ + (double)attractRadius, Pos.f_82481_ + (double)attractRadius);
            storm.m_9236_().m_45976_(Entity.class, area).forEach(entity -> {
                Player player;
                if (entity == storm) {
                    return;
                }
                if (entity instanceof Player && ((player = (Player)entity).m_7500_() || player.m_5833_())) {
                    return;
                }
                Vec3 entityPos = entity.m_20182_();
                Vec3 delta = Pos.m_82546_(entityPos);
                double distance = delta.m_82553_();
                if (distance > 1.0) {
                    Vec3 direction = delta.m_82541_();
                    double speed = 0.5;
                    entity.m_20256_(entity.m_20184_().m_82549_(direction.m_82490_(speed)));
                } else {
                    Vec3 safePos = Pos.m_82546_(delta.m_82541_().m_82490_(1.0));
                    entity.m_6034_(safePos.f_82479_, safePos.f_82480_, safePos.f_82481_);
                    entity.m_20256_(Vec3.f_82478_);
                }
            });
            AABB damageArea = new AABB(Pos.m_7096_() - (double)damageRadius, Pos.m_7098_() - (double)damageRadius, Pos.m_7094_() - (double)damageRadius, Pos.m_7096_() + (double)damageRadius, Pos.m_7098_() + (double)damageRadius, Pos.m_7094_() + (double)damageRadius);
            List entities = level2.m_6443_(LivingEntity.class, damageArea, entity -> {
                Player player;
                return entity.m_6084_() && entity.m_20238_(Pos) <= (double)(damageRadius * damageRadius) && (!(entity instanceof Player) || !(player = (Player)entity).m_7500_()) && entity != source && !(entity instanceof AbstractArtifactSpiritEntity);
            });
            for (LivingEntity entity2 : new ArrayList(entities)) {
                Level level3;
                if (entity2.f_19802_ != 0 || source == null) continue;
                entity2.m_6469_(entity2.m_269291_().m_269104_((Entity)source, (Entity)source), damage);
                entity2.f_19802_ = 5;
                if (!entity2.m_9236_().f_46443_) {
                    entity2.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 200, 0));
                    entity2.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 200, 1));
                }
                if (!((level3 = entity2.m_9236_()) instanceof ServerLevel)) continue;
                ServerLevel serverLevel = (ServerLevel)level3;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, entity2.m_20185_(), entity2.m_20186_() + (double)(entity2.m_20206_() / 2.0f), entity2.m_20189_(), 5, 0.5, 0.25, 0.5, 0.2);
                serverLevel.m_6263_(null, entity2.m_20185_(), entity2.m_20186_(), entity2.m_20189_(), (SoundEvent)EpicFightSounds.BLADE_HIT.get(), SoundSource.HOSTILE, 1.0f, 0.8f + entity2.m_9236_().f_46441_.m_188501_() * 0.4f);
            }
        }
    }

    public static void stormVFX(LivingEntityPatch<?> entityPatch) {
        int particleCount = 1;
        Level world = ((LivingEntity)entityPatch.getOriginal()).m_9236_();
        if (entityPatch instanceof VatanseverStormEntityPatch) {
            VatanseverStormEntityPatch vatanseverStormEntityPatch = (VatanseverStormEntityPatch)entityPatch;
            if (world.f_46443_) {
                for (Joint joint : ((VatanseverStormArmature)SwordSoaringArmatures.VATANSEVER_STORM_ARMATURE.get()).rootJoints) {
                    VatanseverStormAnimations.stormParticle(vatanseverStormEntityPatch, joint, particleCount);
                }
            }
        }
    }
}

