/*
 * Decompiled with CFR 0.152.
 */
package net.p1nero.ss.gameassets.skills;

import com.p1nero.invincible.api.EventPresets;
import com.p1nero.invincible.api.events.TimeStampedEvent;
import com.p1nero.invincible.api.skill.ComboNode;
import com.p1nero.invincible.conditions.CooldownCondition;
import com.p1nero.invincible.conditions.CustomCondition;
import com.p1nero.invincible.conditions.StackCondition;
import com.p1nero.invincible.skill.ComboBasicAttack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.CreativeModeTab;
import net.p1nero.ss.entity.vatansever.VatanseverEntity;
import net.p1nero.ss.gameassets.SwordSoaringDatakeys;
import net.p1nero.ss.gameassets.animations.VatanseverAnimations;
import net.p1nero.ss.item.SwordSoaringItems;
import net.p1nero.ss.skill.weapon_innate.VatanseverWeaponInnateSkill;
import net.p1nero.ss.skill.weapon_passive.VatanseverDodgeSkill;
import net.p1nero.ss.skill.weapon_passive.VatanseverPassive;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.forgeevent.SkillBuildEvent;
import yesman.epicfight.data.conditions.Condition;
import yesman.epicfight.data.conditions.entity.TargetInDistance;
import yesman.epicfight.model.armature.HumanoidArmature;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.dodge.DodgeSkill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class VatanseverSkills {
    public static Skill VATANSEVER_INNATE;
    public static Skill VATANSEVER_PASSIVE;
    public static Skill VATANSEVER_DODGE;

    public static void buildVatanseverSkills(SkillBuildEvent.ModRegistryWorker registryWorker) {
        ComboNode root = ComboNode.create();
        ComboNode a = ComboNode.createNode(VatanseverAnimations.PLAYER_AUTO1).addCondition((Condition)VatanseverSkills.checkSwordCount(1, 6)).setCanBeInterrupt(false);
        ComboNode aa_1 = ComboNode.createNode(VatanseverAnimations.PLAYER_AUTO2_1).addCondition((Condition)VatanseverSkills.checkSwordCount(2, 6)).setCanBeInterrupt(false);
        ComboNode aa_2 = ComboNode.createNode(VatanseverAnimations.PLAYER_AUTO2_2).addCondition((Condition)VatanseverSkills.checkSwordCount(2, 6)).setCanBeInterrupt(false);
        ComboNode aaa = ComboNode.createNode(VatanseverAnimations.PLAYER_AUTO3).addCondition((Condition)VatanseverSkills.checkSwordCount(1, 6)).setCanBeInterrupt(false);
        ComboNode aab = ComboNode.createNode(VatanseverAnimations.PLAYER_AUTO3_B).addCondition((Condition)VatanseverSkills.checkSwordCount(5, 6)).setCanBeInterrupt(false);
        ComboNode aaaa = ComboNode.createNode(VatanseverAnimations.PLAYER_AUTO4).addCondition((Condition)VatanseverSkills.checkSwordCount(6)).setCanBeInterrupt(false);
        ComboNode aaab = ComboNode.createNode(VatanseverAnimations.PLAYER_AUTO4_B).addCondition((Condition)VatanseverSkills.checkSwordCount(6)).setCanBeInterrupt(false);
        ComboNode storm = ComboNode.createNode(VatanseverAnimations.PLAYER_STORM_START).addCondition((Condition)VatanseverSkills.checkSwordCount(6)).setCooldown(1200).addCondition((Condition)new StackCondition(1, 7)).addTimeEvent(EventPresets.consumeStack((int)1)).addCondition((Condition)new CooldownCondition(false)).setPriority(10).setCanBeInterrupt(false);
        ComboNode execute = ComboNode.createNode(VatanseverAnimations.PLAYER_EXECUTE).setConvertTime(0.15f).addCondition((Condition)new StackCondition(7, 7)).addCondition((Condition)new CustomCondition(){

            public boolean predicate(LivingEntityPatch<?> entityPatch) {
                return entityPatch.getTarget() != null;
            }
        }).addCondition((Condition)new TargetInDistance(0.0, 5.0)).addTimeEvent(new TimeStampedEvent(0.0f, entityPatch -> {
            if (entityPatch instanceof ServerPlayerPatch) {
                ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)entityPatch;
                SkillContainer container = serverPlayerPatch.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE);
                container.getSkill().setStackSynchronize(container, 0);
                container.getSkill().setConsumptionSynchronize(container, 0.0f);
                serverPlayerPatch.getTarget().m_20219_(((ServerPlayer)serverPlayerPatch.getOriginal()).m_20182_());
                serverPlayerPatch.getTarget().m_146922_(serverPlayerPatch.getYRot());
                serverPlayerPatch.getTarget().m_5618_(serverPlayerPatch.getYRot());
                serverPlayerPatch.getTarget().m_5616_(serverPlayerPatch.getYRot());
                LivingEntityPatch livingEntityPatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)serverPlayerPatch.getTarget(), LivingEntityPatch.class);
                if (livingEntityPatch.getArmature() instanceof HumanoidArmature) {
                    livingEntityPatch.playAnimationSynchronized(VatanseverAnimations.PLAYER_BE_EXECUTED, 0.1f);
                }
            }
        }));
        ComboNode shootL3 = ComboNode.createNode(VatanseverAnimations.PLAYER_SHOOT_L3).addCondition((Condition)VatanseverSkills.checkSwordCount(6)).addCondition((Condition)VatanseverSkills.checkIsNotInaction()).setPriority(6).setCanBeInterrupt(false);
        ComboNode shootR3 = ComboNode.createNode(VatanseverAnimations.PLAYER_SHOOT_R3).addCondition((Condition)VatanseverSkills.checkSwordCount(5)).addCondition((Condition)VatanseverSkills.checkIsNotInaction()).setPriority(5).setCanBeInterrupt(false);
        ComboNode shootL2 = ComboNode.createNode(VatanseverAnimations.PLAYER_SHOOT_L2).addCondition((Condition)VatanseverSkills.checkSwordCount(4)).addCondition((Condition)VatanseverSkills.checkIsNotInaction()).setPriority(4).setCanBeInterrupt(false);
        ComboNode shootR2 = ComboNode.createNode(VatanseverAnimations.PLAYER_SHOOT_R2).addCondition((Condition)VatanseverSkills.checkSwordCount(3)).addCondition((Condition)VatanseverSkills.checkIsNotInaction()).setPriority(3).setCanBeInterrupt(false);
        ComboNode shootL1 = ComboNode.createNode(VatanseverAnimations.PLAYER_SHOOT_L1).addCondition((Condition)VatanseverSkills.checkSwordCount(2)).addCondition((Condition)VatanseverSkills.checkIsNotInaction()).setPriority(2).setCanBeInterrupt(false);
        ComboNode shootR1 = ComboNode.createNode(VatanseverAnimations.PLAYER_SHOOT_R1).addCondition((Condition)VatanseverSkills.checkSwordCount(1)).addCondition((Condition)VatanseverSkills.checkIsNotInaction()).setPriority(1).setCanBeInterrupt(false);
        ComboNode shoot = ComboNode.create().addConditionNode(shootL1).addConditionNode(shootL2).addConditionNode(shootL3).addConditionNode(shootR1).addConditionNode(shootR2).addConditionNode(shootR3).addConditionNode(storm);
        root.key1(a);
        a.key1(aa_1);
        aa_1.key1(aa_2);
        aa_2.key1(aaa);
        aa_2.key2(aab);
        aaa.key1(aaaa);
        aaa.key2(aaab);
        aaaa.key1(a);
        a.key3(shoot);
        aa_1.key3(shoot);
        aa_2.key3(shoot);
        aaa.key3(shoot);
        aaaa.key3(shoot);
        shoot.key1(a);
        shoot.key3(shoot);
        root.key3(shoot);
        root.key1_4(execute);
        VATANSEVER_INNATE = registryWorker.build("vatansever_innate", VatanseverWeaponInnateSkill::new, (SkillBuilder)ComboBasicAttack.createComboBasicAttack().setCombo(root).setReserveTime(16).setShouldDrawGui(true));
        VATANSEVER_PASSIVE = registryWorker.build("vatansever_passive", VatanseverPassive::new, Skill.createBuilder().setCategory((SkillCategory)SkillCategories.WEAPON_PASSIVE).setResource(Skill.Resource.NONE));
        VATANSEVER_DODGE = registryWorker.build("vatansever_dodge", VatanseverDodgeSkill::new, (SkillBuilder)((DodgeSkill.Builder)VatanseverDodgeSkill.createDodgeBuilder().setAnimations(new AnimationManager.AnimationAccessor[]{VatanseverAnimations.PLAYER_DODGE_F, VatanseverAnimations.PLAYER_DODGE_B, VatanseverAnimations.PLAYER_DODGE_L, VatanseverAnimations.PLAYER_DODGE_R}).setCreativeTab((CreativeModeTab)SwordSoaringItems.DEFAULT_TAB.get())));
    }

    public static CustomCondition checkSwordCount(int swordCount) {
        return VatanseverSkills.checkSwordCount(swordCount, swordCount);
    }

    public static CustomCondition checkSwordCount(final int min, final int max) {
        return new CustomCondition(){

            public boolean predicate(LivingEntityPatch<?> entityPatch) {
                if (entityPatch instanceof ServerPlayerPatch) {
                    ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)entityPatch;
                    int swordCount = (Integer)serverPlayerPatch.getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().getDataValue((SkillDataKey)SwordSoaringDatakeys.SWORD_COUNT.get());
                    return min <= swordCount && max >= swordCount;
                }
                return false;
            }
        };
    }

    public static CustomCondition checkIsNotInaction() {
        return new CustomCondition(){

            public boolean predicate(LivingEntityPatch<?> entityPatch) {
                if (entityPatch instanceof ServerPlayerPatch) {
                    ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)entityPatch;
                    int id = (Integer)serverPlayerPatch.getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().getDataValue((SkillDataKey)SwordSoaringDatakeys.ARTIFACT_SPIRIT_ENTITY_ID.get());
                    Entity entity = ((ServerPlayer)serverPlayerPatch.getOriginal()).m_9236_().m_6815_(id);
                    if (entity instanceof VatanseverEntity) {
                        VatanseverEntity vatansever = (VatanseverEntity)entity;
                        return !vatansever.getPatch().getEntityState().movementLocked();
                    }
                }
                return false;
            }
        };
    }
}

