/*
 * Decompiled with CFR 0.152.
 */
package net.p1nero.ss.skill.sword_controller;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.p1nero.ss.capability.SSCapabilityProvider;
import net.p1nero.ss.capability.SSPlayer;
import net.p1nero.ss.client.CameraAnim;
import net.p1nero.ss.client.keymapping.SwordSoaringKeyMappings;
import net.p1nero.ss.entity.sword.gate_of_babylon.BabylonArmature;
import net.p1nero.ss.entity.sword.gate_of_babylon.BabylonEntity;
import net.p1nero.ss.gameassets.SwordSoaringArmatures;
import net.p1nero.ss.gameassets.SwordSoaringDatakeys;
import net.p1nero.ss.gameassets.animations.BabylonAnimations;
import net.p1nero.ss.item.VatanseverItem;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class GateOfBabylonSkill
extends Skill {
    private int cooldown;
    private int interval;
    private int count = -1;
    private int perShootCount;
    private Vec3 startPos;
    private float startYRot;

    public GateOfBabylonSkill(SkillBuilder<? extends Skill> builder) {
        super(builder);
    }

    public void setParams(CompoundTag parameters) {
        super.setParams(parameters);
        this.cooldown = parameters.m_128451_("cooldown");
        this.interval = parameters.m_128451_("interval");
        this.cooldown += this.cooldown % this.interval;
    }

    public boolean canExecute(SkillContainer container) {
        PlayerPatch executer = container.getExecutor();
        if (((Player)executer.getOriginal()).m_21205_().m_41720_() instanceof VatanseverItem) {
            return false;
        }
        return ((Integer)container.getDataManager().getDataValue((SkillDataKey)SwordSoaringDatakeys.COOLDOWN_TIMER.get()) <= 0 || ((Player)executer.getOriginal()).m_7500_()) && !((Player)executer.getOriginal()).m_21205_().m_41619_() && ((Player)executer.getOriginal()).m_20096_();
    }

    public void executeOnServer(SkillContainer container, FriendlyByteBuf args) {
        super.executeOnServer(container, args);
        this.perShootCount = ((BabylonArmature)SwordSoaringArmatures.BABYLON_ARMATURE.get()).joints.size();
        ServerPlayerPatch executor = container.getServerExecutor();
        container.getDataManager().setDataSync((SkillDataKey)SwordSoaringDatakeys.COOLDOWN_TIMER.get(), (Object)this.cooldown);
        executor.playAnimationSynchronized(BabylonAnimations.BABYLON_SUMMON_PLAYER, 0.15f);
        ((ServerPlayer)executor.getOriginal()).getCapability(SSCapabilityProvider.SS_PLAYER).ifPresent(ssPlayer -> {
            int size = ssPlayer.initBabylonItems((ServerPlayer)executor.getOriginal());
            this.count = size / (this.perShootCount + 1) + 1;
            container.getDataManager().setDataSync((SkillDataKey)SwordSoaringDatakeys.CAMERA_TIMER.get(), (Object)(this.count * this.interval));
        });
        this.startPos = ((ServerPlayer)executor.getOriginal()).m_20182_();
        this.startYRot = ((ServerPlayer)executor.getOriginal()).m_146908_();
    }

    public void updateContainer(SkillContainer container) {
        int currentCameraTimer;
        super.updateContainer(container);
        int currentCooldown = (Integer)container.getDataManager().getDataValue((SkillDataKey)SwordSoaringDatakeys.COOLDOWN_TIMER.get());
        if (currentCooldown > 0) {
            container.getDataManager().setData((SkillDataKey)SwordSoaringDatakeys.COOLDOWN_TIMER.get(), (Object)(currentCooldown - 1));
        }
        if ((currentCameraTimer = ((Integer)container.getDataManager().getDataValue((SkillDataKey)SwordSoaringDatakeys.CAMERA_TIMER.get())).intValue()) > 0) {
            container.getDataManager().setData((SkillDataKey)SwordSoaringDatakeys.CAMERA_TIMER.get(), (Object)(currentCameraTimer - 1));
        }
        if (!container.getExecutor().isLogicalClient()) {
            ServerPlayer serverPlayer = (ServerPlayer)container.getExecutor().getOriginal();
            SSPlayer ssPlayer = (SSPlayer)serverPlayer.getCapability(SSCapabilityProvider.SS_PLAYER).orElse((Object)new SSPlayer());
            if ((currentCooldown == this.cooldown - 1 || currentCooldown % this.interval == 0) && this.count > 0) {
                BabylonEntity babylonEntity = new BabylonEntity((LivingEntity)container.getExecutor().getOriginal(), this.startPos, this.startYRot);
                ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
                for (int i = this.perShootCount * (this.count - 1); i < this.count * this.perShootCount && i < ssPlayer.getValidBabylonItems().size(); ++i) {
                    itemStacks.add(ssPlayer.getValidBabylonItems().get(i));
                }
                babylonEntity.initBabylonItems(itemStacks, true);
                babylonEntity.setAnimationToPlay(currentCooldown == this.cooldown - 1 ? BabylonAnimations.BABYLON_SHOOT_START : BabylonAnimations.BABYLON_SHOOT_LOOP);
                serverPlayer.m_9236_().m_7967_((Entity)babylonEntity);
                --this.count;
                container.getExecutor().playSound(SoundEvents.f_12286_, 3.0f, 0.0f, 0.0f);
            }
        } else if (currentCameraTimer > 0 && ((Player)container.getExecutor().getOriginal()).equals((Object)Minecraft.m_91087_().f_91074_)) {
            CameraAnim.zoomIn(new Vec3f(0.0f, -3.0f, -6.0f), 200);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        return (Integer)container.getDataManager().getDataValue((SkillDataKey)SwordSoaringDatakeys.COOLDOWN_TIMER.get()) > 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y, float partialTick) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, (float)gui.getSlidingProgression(), 0.0f);
        guiGraphics.m_280411_(this.getSkillTexture(), (int)x, (int)y, 24, 24, 0.0f, 0.0f, 1, 1, 1, 1);
        guiGraphics.drawString(gui.getFont(), String.format("%.1f", (double)((Integer)container.getDataManager().getDataValue((SkillDataKey)SwordSoaringDatakeys.COOLDOWN_TIMER.get())).intValue() / 20.0), x + 6.0f, y + 8.0f, 0xFFFFFF, true);
        poseStack.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Object> getTooltipArgsOfScreen(List<Object> list) {
        list.add((double)this.cooldown / 20.0);
        list.add(SwordSoaringKeyMappings.SWORD_SKILL.m_90863_());
        return list;
    }
}

