/*
 * Decompiled with CFR 0.152.
 */
package net.p1nero.ss.skill.sword_controller;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.p1nero.ss.SwordSoaringMod;
import net.p1nero.ss.client.keymapping.SwordSoaringKeyMappings;
import net.p1nero.ss.entity.sword.screen_sword.ScreenSwordEntity;
import net.p1nero.ss.gameassets.SwordSoaringDatakeys;
import net.p1nero.ss.gameassets.SwordSoaringSkillCategories;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class KillAuraSkill
extends Skill {
    protected int lifeTime;
    protected int cooldown;
    protected AnimationManager.AnimationAccessor<? extends StaticAnimation> playerSummonAnim;
    protected AnimationManager.AnimationAccessor<? extends StaticAnimation> swordSummonAnim;

    public KillAuraSkill(Builder builder) {
        super((SkillBuilder)builder);
        this.playerSummonAnim = builder.playerSummonAnim;
        this.swordSummonAnim = builder.swordSummonAnim;
    }

    public void setParams(CompoundTag parameters) {
        super.setParams(parameters);
        this.lifeTime = parameters.m_128451_("life_time");
        this.cooldown = parameters.m_128451_("cooldown");
        this.cooldown += this.lifeTime;
    }

    public int getMaxCooldown() {
        return this.cooldown;
    }

    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getSwordSummonAnim() {
        return this.swordSummonAnim;
    }

    public static Builder createKillAuraBuilder() {
        return new Builder().setCategory(SwordSoaringSkillCategories.SWORD_CONTROLLER).setResource(Skill.Resource.NONE);
    }

    public void onRemoved(SkillContainer container) {
        ScreenSwordEntity abstractArtifactSpiritEntity;
        Entity entity;
        super.onRemoved(container);
        int id = this.getSwordEntityId(container);
        if (id != 0 && (entity = ((Player)container.getExecutor().getOriginal()).m_9236_().m_6815_(id)) instanceof ScreenSwordEntity && (abstractArtifactSpiritEntity = (ScreenSwordEntity)entity).m_6084_()) {
            abstractArtifactSpiritEntity.m_146870_();
        }
    }

    public int getSwordEntityId(SkillContainer container) {
        if (container.getDataManager().hasData((SkillDataKey)SwordSoaringDatakeys.SWORD_ENTITY_ID.get())) {
            return (Integer)container.getDataManager().getDataValue((SkillDataKey)SwordSoaringDatakeys.SWORD_ENTITY_ID.get());
        }
        return 0;
    }

    public boolean canExecute(SkillContainer container) {
        PlayerPatch executor = container.getExecutor();
        return ((Player)executor.getOriginal()).m_20096_() && SwordSoaringMod.isValidSword(executor.getValidItemInHand(InteractionHand.MAIN_HAND)) && (Integer)container.getDataManager().getDataValue((SkillDataKey)SwordSoaringDatakeys.COOLDOWN_TIMER.get()) <= 0 || ((Player)executor.getOriginal()).m_7500_();
    }

    public void executeOnServer(SkillContainer container, FriendlyByteBuf args) {
        super.executeOnServer(container, args);
        ServerPlayerPatch executor = container.getServerExecutor();
        executor.playAnimationSynchronized(this.playerSummonAnim, 0.15f);
        container.getDataManager().setDataSync((SkillDataKey)SwordSoaringDatakeys.COOLDOWN_TIMER.get(), (Object)this.cooldown);
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        int cooldown = (Integer)container.getDataManager().getDataValue((SkillDataKey)SwordSoaringDatakeys.COOLDOWN_TIMER.get());
        if (cooldown > 0) {
            container.getDataManager().setData((SkillDataKey)SwordSoaringDatakeys.COOLDOWN_TIMER.get(), (Object)(cooldown - 1));
        }
        if (cooldown == this.cooldown - (int)(((StaticAnimation)this.playerSummonAnim.get()).getTotalTime() * 10.0f) && !container.getExecutor().isLogicalClient()) {
            ScreenSwordEntity screenSwordEntity = new ScreenSwordEntity((Player)container.getExecutor().getOriginal(), this.lifeTime);
            ((Player)container.getExecutor().getOriginal()).m_9236_().m_7967_((Entity)screenSwordEntity);
            container.getDataManager().setDataSync((SkillDataKey)SwordSoaringDatakeys.SWORD_ENTITY_ID.get(), (Object)screenSwordEntity.m_19879_());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Object> getTooltipArgsOfScreen(List<Object> list) {
        list.add((double)this.lifeTime / 20.0);
        list.add((double)this.cooldown / 20.0);
        list.add(SwordSoaringKeyMappings.SWORD_SKILL.m_90863_());
        return list;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        return (Integer)container.getDataManager().getDataValue((SkillDataKey)SwordSoaringDatakeys.COOLDOWN_TIMER.get()) > 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y, float partialTick) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, (float)gui.getSlidingProgression(), 0.0f);
        guiGraphics.m_280411_(this.getSkillTexture(), (int)x, (int)y, 24, 24, 0.0f, 0.0f, 1, 1, 1, 1);
        int currentCooldown = (Integer)container.getDataManager().getDataValue((SkillDataKey)SwordSoaringDatakeys.COOLDOWN_TIMER.get());
        int currentLifetime = this.cooldown - currentCooldown;
        if (currentLifetime > this.lifeTime) {
            guiGraphics.drawString(gui.getFont(), String.format("%.1f", (double)currentCooldown / 20.0), x + 6.0f, y + 8.0f, 0xFFFFFF, true);
        } else {
            guiGraphics.drawString(gui.getFont(), String.format("%.1f", (double)(this.lifeTime - currentLifetime) / 20.0), x + 6.0f, y + 8.0f, 0xFFFFFF, true);
        }
        poseStack.m_85849_();
    }

    public static class Builder
    extends SkillBuilder<KillAuraSkill> {
        protected AnimationManager.AnimationAccessor<? extends StaticAnimation> playerSummonAnim;
        protected AnimationManager.AnimationAccessor<? extends StaticAnimation> swordSummonAnim;

        public Builder setCategory(SkillCategory category) {
            this.category = category;
            return this;
        }

        public Builder setActivateType(Skill.ActivateType activateType) {
            this.activateType = activateType;
            return this;
        }

        public Builder setResource(Skill.Resource resource) {
            this.resource = resource;
            return this;
        }

        public Builder setCreativeTab(CreativeModeTab tab) {
            this.tab = tab;
            return this;
        }

        public Builder setPlayerSummonAnim(AnimationManager.AnimationAccessor<? extends StaticAnimation> summonAnim) {
            this.playerSummonAnim = summonAnim;
            return this;
        }

        public Builder setSwordSummonAnim(AnimationManager.AnimationAccessor<? extends StaticAnimation> summonAnim) {
            this.swordSummonAnim = summonAnim;
            return this;
        }
    }
}

