/*
 * Decompiled with CFR 0.152.
 */
package net.p1nero.ss.skill.sword_controller;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.p1nero.ss.entity.sword.screen_sword.ScreenSwordEntity;
import net.p1nero.ss.gameassets.SwordSoaringDatakeys;
import net.p1nero.ss.skill.sword_controller.KillAuraSkill;
import net.p1nero.ss.util.ItemUtils;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class ScreenSwordSkill
extends KillAuraSkill {
    private static final UUID EVENT_UUID = UUID.fromString("051a9bb2-7541-11ee-b962-0242ac191981");
    private int maxProtectCount;
    private float healCount;

    public ScreenSwordSkill(KillAuraSkill.Builder builder) {
        super(builder);
    }

    @Override
    public void setParams(CompoundTag parameters) {
        super.setParams(parameters);
        this.maxProtectCount = parameters.m_128451_("protect_count");
        this.healCount = parameters.m_128457_("heal_count");
    }

    public int getMaxProtectCount() {
        return this.maxProtectCount;
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        ((Player)container.getExecutor().getOriginal()).m_146915_(false);
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_ATTACK, EVENT_UUID, hurtEvent -> {
            Entity patt2281$temp = ((ServerPlayer)((ServerPlayerPatch)hurtEvent.getPlayerPatch()).getOriginal()).m_9236_().m_6815_(((Integer)container.getDataManager().getDataValue((SkillDataKey)SwordSoaringDatakeys.SWORD_ENTITY_ID.get())).intValue());
            if (patt2281$temp instanceof ScreenSwordEntity) {
                ScreenSwordEntity screenSwordEntity = (ScreenSwordEntity)patt2281$temp;
                int protectCountLeft = (Integer)container.getDataManager().getDataValue((SkillDataKey)SwordSoaringDatakeys.PROTECT_COUNT.get());
                if (protectCountLeft <= 0) {
                    return;
                }
                container.getDataManager().setDataSync((SkillDataKey)SwordSoaringDatakeys.PROTECT_COUNT.get(), (Object)(protectCountLeft - 1));
                if ((protectCountLeft - 1) % (this.maxProtectCount / 6) == 0) {
                    ((ServerPlayerPatch)hurtEvent.getPlayerPatch()).playSound((SoundEvent)EpicFightSounds.NEUTRALIZE_MOBS.get(), 0.0f, 0.0f);
                    ((ServerPlayer)((ServerPlayerPatch)hurtEvent.getPlayerPatch()).getOriginal()).m_5634_(this.healCount);
                } else {
                    ((ServerPlayerPatch)hurtEvent.getPlayerPatch()).playSound((SoundEvent)EpicFightSounds.CLASH.get(), 0.0f, 0.0f);
                    ((HitParticleType)EpicFightParticles.HIT_BLUNT.get()).spawnParticleWithArgument(((ServerPlayer)((ServerPlayerPatch)hurtEvent.getPlayerPatch()).getOriginal()).m_284548_(), HitParticleType.FRONT_OF_EYES, HitParticleType.ZERO, ((ServerPlayerPatch)hurtEvent.getPlayerPatch()).getOriginal(), hurtEvent.getDamageSource().m_7640_());
                }
                DamageSource patt3414$temp = hurtEvent.getDamageSource();
                if (patt3414$temp instanceof EpicFightDamageSource) {
                    EpicFightDamageSource epicFightDamageSource = (EpicFightDamageSource)patt3414$temp;
                    epicFightDamageSource.setBaseImpact(0.0f);
                    epicFightDamageSource.setStunType(StunType.NONE);
                }
                if (hurtEvent.getDamageSource().m_269014_()) {
                    hurtEvent.setResult(AttackResult.ResultType.MISSED);
                    hurtEvent.setParried(true);
                    hurtEvent.setCanceled(true);
                } else {
                    Entity entity = hurtEvent.getDamageSource().m_7639_();
                    if (entity != null) {
                        double total = ItemUtils.getItemAttackDamage((LivingEntity)((ServerPlayerPatch)hurtEvent.getPlayerPatch()).getOriginal(), screenSwordEntity.getItemStack(null));
                        float counterattackDamage = (double)(hurtEvent.getDamage() * 0.5f) > total ? (float)total : hurtEvent.getDamage() * 0.5f;
                        hurtEvent.getDamageSource().m_7639_().m_6469_(hurtEvent.getDamageSource(), counterattackDamage);
                    }
                }
            } else {
                container.getDataManager().setDataSync((SkillDataKey)SwordSoaringDatakeys.PROTECT_COUNT.get(), (Object)0);
                if (((Player)container.getExecutor().getOriginal()).m_142038_()) {
                    ((Player)container.getExecutor().getOriginal()).m_146915_(false);
                }
            }
        });
    }

    @Override
    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        ((Player)container.getExecutor().getOriginal()).m_146915_(false);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_ATTACK, EVENT_UUID);
    }

    @Override
    public void executeOnServer(SkillContainer container, FriendlyByteBuf args) {
        super.executeOnServer(container, args);
        ServerPlayerPatch executer = container.getServerExecutor();
        container.getDataManager().setDataSync((SkillDataKey)SwordSoaringDatakeys.PROTECT_COUNT.get(), (Object)this.maxProtectCount);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Object> getTooltipArgsOfScreen(List<Object> list) {
        list.add(this.maxProtectCount);
        list.add(Float.valueOf(this.healCount));
        return super.getTooltipArgsOfScreen(list);
    }

    @Override
    public boolean shouldDraw(SkillContainer container) {
        return (Integer)container.getDataManager().getDataValue((SkillDataKey)SwordSoaringDatakeys.PROTECT_COUNT.get()) > 0 || super.shouldDraw(container);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y, float partialTick) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, (float)gui.getSlidingProgression(), 0.0f);
        guiGraphics.m_280411_(this.getSkillTexture(), (int)x, (int)y, 24, 24, 0.0f, 0.0f, 1, 1, 1, 1);
        int protectCount = (Integer)container.getDataManager().getDataValue((SkillDataKey)SwordSoaringDatakeys.PROTECT_COUNT.get());
        int currentCooldown = (Integer)container.getDataManager().getDataValue((SkillDataKey)SwordSoaringDatakeys.COOLDOWN_TIMER.get());
        int currentLifetime = this.cooldown - currentCooldown;
        if (protectCount > 0 && currentLifetime < this.lifeTime) {
            guiGraphics.drawString(gui.getFont(), ((Integer)container.getDataManager().getDataValue((SkillDataKey)SwordSoaringDatakeys.PROTECT_COUNT.get())).toString(), x + 6.0f, y + 8.0f, 0xFFFFFF, true);
        } else {
            guiGraphics.drawString(gui.getFont(), String.format("%.1f", (double)((Integer)container.getDataManager().getDataValue((SkillDataKey)SwordSoaringDatakeys.COOLDOWN_TIMER.get())).intValue() / 20.0), x + 6.0f, y + 8.0f, 0xFFFFFF, true);
        }
        poseStack.m_85849_();
    }
}

