/*
 * Decompiled with CFR 0.152.
 */
package net.p1nero.ss.skill.sword_soaring;

import com.github.exopandora.shouldersurfing.api.client.ShoulderSurfing;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.fml.ModList;
import net.p1nero.ss.SwordSoaringMod;
import net.p1nero.ss.client.keymapping.SwordSoaringKeyMappings;
import net.p1nero.ss.client.sound.SwordFlyingSoundInstance;
import net.p1nero.ss.gameassets.SwordSoaringDatakeys;
import net.p1nero.ss.gameassets.SwordSoaringSkillCategories;
import net.p1nero.ss.gameassets.SwordSoaringSkillSlots;
import net.p1nero.ss.gameassets.skills.FlyingSkills;
import net.p1nero.ss.item.SwordSoaringItems;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.client.events.engine.ControlEngine;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class SwordSoaringSkill
extends Skill {
    private static final UUID EVENT_UUID = UUID.fromString("051a9bb2-7541-11ee-b962-0242ac114514");
    protected int cooldown;
    protected double speed;
    protected final AnimationManager.AnimationAccessor<? extends StaticAnimation> init;
    protected final AnimationManager.AnimationAccessor<? extends StaticAnimation> flying;
    protected final AnimationManager.AnimationAccessor<? extends StaticAnimation> acceleration;
    protected final Supplier<Skill> priorSkill;

    public static Builder createSwordSoaringSkill() {
        return new Builder().setCreativeTab((CreativeModeTab)SwordSoaringItems.DEFAULT_TAB.get()).setCategory(SwordSoaringSkillCategories.SWORD_SOARING).setResource(Skill.Resource.NONE);
    }

    public Skill getPriorSkill() {
        return this.priorSkill == null ? null : this.priorSkill.get();
    }

    public SwordSoaringSkill(Builder builder) {
        super((SkillBuilder)builder);
        this.init = builder.init;
        this.flying = builder.flying;
        this.acceleration = builder.acceleration;
        this.priorSkill = builder.priorSkill;
    }

    public void setParams(CompoundTag parameters) {
        super.setParams(parameters);
        this.cooldown = parameters.m_128451_("cooldown");
        this.speed = parameters.m_128459_("speed");
    }

    public boolean canExecute(SkillContainer container) {
        PlayerPatch executer = container.getExecutor();
        if (((Player)executer.getOriginal()).m_21205_().m_150930_((Item)SwordSoaringItems.VATANSEVER.get()) || ((Player)executer.getOriginal()).m_5842_()) {
            return false;
        }
        SkillDataManager dataManager = executer.getSkill((SkillSlot)SwordSoaringSkillSlots.SWORD_SOARING).getDataManager();
        return (Boolean)dataManager.getDataValue((SkillDataKey)SwordSoaringDatakeys.FLYING.get()) == false && ((Integer)dataManager.getDataValue((SkillDataKey)SwordSoaringDatakeys.COOLDOWN_TIMER.get()) <= 0 || ((Player)executer.getOriginal()).m_7500_()) && SwordSoaringMod.isValidSword(((Player)executer.getOriginal()).m_21205_()) && executer.hasStamina(this.consumption + 0.1f);
    }

    public void executeOnServer(SkillContainer container, FriendlyByteBuf args) {
        super.executeOnServer(container, args);
        ServerPlayerPatch executor = container.getServerExecutor();
        SkillDataManager dataManager = executor.getSkill((SkillSlot)SwordSoaringSkillSlots.SWORD_SOARING).getDataManager();
        Vec3 view = ((ServerPlayer)executor.getOriginal()).m_20252_(1.0f);
        ((ServerPlayer)executor.getOriginal()).m_5997_(view.f_82479_, 2.0, view.f_82481_);
        dataManager.setDataSync((SkillDataKey)SwordSoaringDatakeys.FLYING.get(), (Object)true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void executeOnClient(SkillContainer container, FriendlyByteBuf args) {
        LocalPlayerPatch executer = container.getClientExecutor();
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new SwordFlyingSoundInstance(executer));
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID, event -> {
            if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)SwordSoaringDatakeys.FLYING.get())).booleanValue()) {
                Input input = event.getMovementInput();
                input.f_108567_ = 0.0f;
                input.f_108566_ = 0.0f;
                input.f_108569_ = false;
                input.f_108568_ = false;
                input.f_108570_ = false;
                input.f_108571_ = false;
                input.f_108572_ = false;
                input.f_108573_ = false;
                LocalPlayer clientPlayer = (LocalPlayer)((LocalPlayerPatch)event.getPlayerPatch()).getOriginal();
                clientPlayer.m_6858_(false);
                clientPlayer.f_108583_ = -1;
                Minecraft mc = Minecraft.m_91087_();
                ControlEngine.setKeyBind((KeyMapping)mc.f_91066_.f_92091_, (boolean)false);
            }
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_ATTACK, EVENT_UUID, hurtEvent -> {
            if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)SwordSoaringDatakeys.FLYING.get())).booleanValue()) {
                this.stopFlying(container, (ServerPlayer)((ServerPlayerPatch)hurtEvent.getPlayerPatch()).getOriginal());
            }
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.FALL_EVENT, EVENT_UUID, fallEvent -> {
            if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)SwordSoaringDatakeys.FLYING.get())).booleanValue()) {
                if (!fallEvent.getPlayerPatch().isLogicalClient()) {
                    this.stopFlying(container, (ServerPlayer)fallEvent.getPlayerPatch().getOriginal());
                }
                fallEvent.getForgeEvent().setDamageMultiplier(0.0f);
                fallEvent.getForgeEvent().setCanceled(true);
                fallEvent.getPlayerPatch().updateMotion(false);
            }
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.BASIC_ATTACK_EVENT, EVENT_UUID, basicAttackEvent -> {
            if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)SwordSoaringDatakeys.FLYING.get())).booleanValue()) {
                basicAttackEvent.setCanceled(true);
            }
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.SKILL_CAST_EVENT, EVENT_UUID, skillExecuteEvent -> {
            if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)SwordSoaringDatakeys.FLYING.get())).booleanValue() && !skillExecuteEvent.getPlayerPatch().isLogicalClient()) {
                this.stopFlying(container, (ServerPlayer)skillExecuteEvent.getPlayerPatch().getOriginal());
            }
        });
        List<Skill> capabilitySkill = container.getExecutor().getSkillCapability().listAcquiredSkills().filter(skill -> skill.getCategory() == SwordSoaringSkillCategories.SWORD_SOARING).toList();
        if (capabilitySkill.contains(FlyingSkills.SWORD_SOARING_MASTER) || capabilitySkill.contains(FlyingSkills.SWORD_SOARING_ELYTRA_MASTER)) {
            this.cooldown = 0;
            this.consumption = 0.0f;
        }
    }

    public static void onLivingEquipmentChange(LivingEquipmentChangeEvent event) {
        ServerPlayerPatch serverPlayerPatch;
        SkillContainer container;
        Skill skill;
        ServerPlayer serverPlayer;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer && (serverPlayer = (ServerPlayer)livingEntity).m_6084_() && (skill = (container = (serverPlayerPatch = (ServerPlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)serverPlayer, ServerPlayerPatch.class)).getSkill((SkillSlot)SwordSoaringSkillSlots.SWORD_SOARING)).getSkill()) instanceof SwordSoaringSkill) {
            SwordSoaringSkill skill2 = (SwordSoaringSkill)skill;
            if (event.getSlot() == EquipmentSlot.MAINHAND && container.getDataManager().hasData((SkillDataKey)SwordSoaringDatakeys.FLYING.get()) && ((Boolean)container.getDataManager().getDataValue((SkillDataKey)SwordSoaringDatakeys.FLYING.get())).booleanValue()) {
                skill2.stopFlying(container, serverPlayer);
            }
        }
    }

    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        PlayerEventListener listener = container.getExecutor().getEventListener();
        listener.removeListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID);
        listener.removeListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_ATTACK, EVENT_UUID);
        listener.removeListener(PlayerEventListener.EventType.FALL_EVENT, EVENT_UUID);
        listener.removeListener(PlayerEventListener.EventType.BASIC_ATTACK_EVENT, EVENT_UUID);
        listener.removeListener(PlayerEventListener.EventType.SKILL_CAST_EVENT, EVENT_UUID);
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        int currentCooldown = (Integer)container.getDataManager().getDataValue((SkillDataKey)SwordSoaringDatakeys.COOLDOWN_TIMER.get());
        if (!container.getExecutor().isLogicalClient() && currentCooldown > 0) {
            container.getDataManager().setDataSync((SkillDataKey)SwordSoaringDatakeys.COOLDOWN_TIMER.get(), (Object)(currentCooldown - 1));
        }
        this.flyingTick(container);
    }

    public void flyingTick(SkillContainer container) {
        if (container.getExecutor().isLogicalClient()) {
            if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)SwordSoaringDatakeys.FLYING.get())).booleanValue() && container.getExecutor().hasStamina(this.consumption + 0.1f) && SwordSoaringMod.isValidSword(((Player)container.getExecutor().getOriginal()).m_21205_())) {
                LocalPlayer localPlayer = (LocalPlayer)container.getExecutor().getOriginal();
                Vec3 view = localPlayer.m_20252_(1.0f).m_82541_();
                if (ModList.get().isLoaded("shouldersurfing")) {
                    view = MathUtils.getVectorForRotation((float)ShoulderSurfing.getInstance().getCamera().getXRot(), (float)ShoulderSurfing.getInstance().getCamera().getYRot());
                    ((Player)container.getExecutor().getOriginal()).m_146922_((float)MathUtils.getYRotOfVector((Vec3)view));
                    ((Player)container.getExecutor().getOriginal()).m_5616_((float)MathUtils.getYRotOfVector((Vec3)view));
                    ((Player)container.getExecutor().getOriginal()).m_146926_((float)MathUtils.getXRotOfVector((Vec3)view));
                }
                Vec3 accelerationSpeed = view.m_82490_(this.speed);
                Vec3 normalSpeed = accelerationSpeed.m_82490_((double)0.33f);
                boolean accelerating = SwordSoaringKeyMappings.ACCELERATION.m_90857_();
                if (accelerating != (Boolean)container.getDataManager().getDataValue((SkillDataKey)SwordSoaringDatakeys.SPEED_UP.get())) {
                    container.getDataManager().setDataSync((SkillDataKey)SwordSoaringDatakeys.SPEED_UP.get(), (Object)accelerating);
                }
                Vec3 currentDeltaMovement = localPlayer.m_20184_();
                if (accelerating) {
                    double speedLength;
                    double currentLength = currentDeltaMovement.m_82553_();
                    if (currentLength < (speedLength = accelerationSpeed.m_82553_())) {
                        Vec3 interpolate = accelerationSpeed.m_82490_(currentLength / speedLength + (speedLength - currentLength) * 0.1);
                        localPlayer.m_20334_(interpolate.f_82479_, interpolate.f_82480_, interpolate.f_82481_);
                    } else {
                        localPlayer.m_20334_(accelerationSpeed.f_82479_, accelerationSpeed.f_82480_, accelerationSpeed.f_82481_);
                    }
                } else {
                    double normalLength;
                    double currentLength = currentDeltaMovement.m_82553_();
                    if (currentLength > (normalLength = normalSpeed.m_82553_())) {
                        Vec3 interpolate = normalSpeed.m_82490_(normalLength / currentLength - (currentLength - normalLength) * 0.1);
                        localPlayer.m_20334_(interpolate.f_82479_, interpolate.f_82480_, interpolate.f_82481_);
                    } else {
                        localPlayer.m_20334_(normalSpeed.f_82479_, normalSpeed.f_82480_, normalSpeed.f_82481_);
                    }
                }
            }
        } else if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)SwordSoaringDatakeys.FLYING.get())).booleanValue()) {
            container.getExecutor().resetActionTick();
            if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)SwordSoaringDatakeys.SPEED_UP.get())).booleanValue()) {
                container.getExecutor().setStamina(container.getExecutor().getStamina() - this.consumption);
            } else if (SwordSoaringMod.isValidSword(((Player)container.getExecutor().getOriginal()).m_21205_())) {
                container.getExecutor().setStamina(container.getExecutor().getStamina() - this.consumption * 0.33f);
            }
            if (((Player)container.getExecutor().getOriginal()).m_5842_() || !container.getExecutor().hasStamina(this.consumption + 0.1f) || !SwordSoaringMod.isValidSword(((Player)container.getExecutor().getOriginal()).m_21205_())) {
                this.stopFlying(container, (ServerPlayer)container.getExecutor().getOriginal());
            }
        }
    }

    public void stopFlying(SkillContainer container, ServerPlayer serverPlayer) {
        container.getDataManager().setDataSync((SkillDataKey)SwordSoaringDatakeys.FLYING.get(), (Object)false);
        container.getDataManager().setDataSync((SkillDataKey)SwordSoaringDatakeys.SPEED_UP.get(), (Object)false);
        container.getDataManager().setDataSync((SkillDataKey)SwordSoaringDatakeys.COOLDOWN_TIMER.get(), (Object)this.cooldown);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        return (Integer)container.getDataManager().getDataValue((SkillDataKey)SwordSoaringDatakeys.COOLDOWN_TIMER.get()) > 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y, float partialTick) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, (float)gui.getSlidingProgression(), 0.0f);
        guiGraphics.m_280411_(this.getSkillTexture(), (int)x, (int)y, 24, 24, 0.0f, 0.0f, 1, 1, 1, 1);
        guiGraphics.drawString(gui.getFont(), String.format("%.1f", (double)((Integer)container.getDataManager().getDataValue((SkillDataKey)SwordSoaringDatakeys.COOLDOWN_TIMER.get())).intValue() / 20.0), x + 6.0f, y + 8.0f, 0xFFFFFF, true);
        poseStack.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Object> getTooltipArgsOfScreen(List<Object> list) {
        list.add(SwordSoaringKeyMappings.TAKE_OFF.m_90863_().m_6881_().m_130940_(ChatFormatting.BOLD));
        list.add(SwordSoaringKeyMappings.ACCELERATION.m_90863_().m_6881_().m_130940_(ChatFormatting.BOLD));
        return list;
    }

    public static class Builder
    extends SkillBuilder<SwordSoaringSkill> {
        protected AnimationManager.AnimationAccessor<? extends StaticAnimation> init;
        protected AnimationManager.AnimationAccessor<? extends StaticAnimation> flying;
        protected AnimationManager.AnimationAccessor<? extends StaticAnimation> acceleration;
        @Nullable
        protected Supplier<Skill> priorSkill;

        public Builder setCategory(SkillCategory category) {
            this.category = category;
            return this;
        }

        public Builder setActivateType(Skill.ActivateType activateType) {
            this.activateType = activateType;
            return this;
        }

        public Builder setResource(Skill.Resource resource) {
            this.resource = resource;
            return this;
        }

        public Builder setCreativeTab(CreativeModeTab tab) {
            this.tab = tab;
            return this;
        }

        public Builder setFlyingAnimations(AnimationManager.AnimationAccessor<? extends StaticAnimation> init, AnimationManager.AnimationAccessor<? extends StaticAnimation> flying, AnimationManager.AnimationAccessor<? extends StaticAnimation> acceleration) {
            this.init = init;
            this.flying = flying;
            this.acceleration = acceleration;
            return this;
        }

        public Builder setPriorSkill(@Nullable Supplier<Skill> priorSkill) {
            this.priorSkill = priorSkill;
            return this;
        }
    }
}

