/*
 * Decompiled with CFR 0.152.
 */
package net.p1nero.ss.util.vfx;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.p1nero.ss.util.AnimationUtils;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class ParticleVFX {
    private static final int[][] CONNECTIONS = new int[][]{{0, 1}, {1, 2}, {2, 3}, {3, 4}, {4, 5}, {5, 6}};

    public static void createHexagramParticle(ParticleOptions particleOptions, Level level, Vec3 center, float interval, float radius, float yRot) {
        ParticleVFX.createHexagramParticle(particleOptions, level, center, interval, radius, yRot, 0.0f, 0.01f, 0.0f);
    }

    public static void createHexagramParticle(ParticleOptions particleOptions, Level level, Vec3 center, float interval, float radius, float yRot, float xSpeed, float ySpeed, float zSpeed) {
        for (Vec3 pos : ParticleVFX.generateHexagram(center, radius, interval, yRot)) {
            level.m_7106_(particleOptions, pos.f_82479_, pos.f_82480_, pos.f_82481_, (double)xSpeed, (double)ySpeed, (double)zSpeed);
        }
    }

    public static List<Vec3> generateHexagram(Vec3 center, double radius, double interval, double yRot) {
        double rad = Math.toRadians(yRot);
        double cos = Math.cos(rad);
        double sin = Math.sin(rad);
        ArrayList<Vec3> vertices = new ArrayList<Vec3>();
        for (int i = 0; i < 6; ++i) {
            double angle = Math.toRadians(60 * i);
            double dx = radius * Math.cos(angle);
            double dz = radius * Math.sin(angle);
            double rx = dx * cos - dz * sin;
            double rz = dx * sin + dz * cos;
            vertices.add(new Vec3(center.f_82479_ + rx, center.f_82480_, center.f_82481_ + rz));
        }
        int[][] connections = new int[][]{{0, 2}, {2, 4}, {4, 0}, {1, 3}, {3, 5}, {5, 1}};
        LinkedHashSet<Vec3> path = new LinkedHashSet<Vec3>();
        for (int[] edge : connections) {
            Vec3 start = (Vec3)vertices.get(edge[0]);
            Vec3 end = (Vec3)vertices.get(edge[1]);
            double dx = end.f_82479_ - start.f_82479_;
            double dz = end.f_82481_ - start.f_82481_;
            double length = Math.hypot(dx, dz);
            int steps = (int)Math.ceil(length / interval);
            for (int i = 0; i <= steps; ++i) {
                double ratio = (double)i / (double)steps;
                path.add(new Vec3(start.f_82479_ + dx * ratio, center.f_82480_, start.f_82481_ + dz * ratio));
            }
        }
        return new ArrayList<Vec3>(path);
    }

    public static void createBigDipperXYParticle(ParticleOptions particleOptions, Level level, Vec3 center, float interval, float radius, float yRot, float zRot) {
        ParticleVFX.createBigDipperXYParticle(particleOptions, level, center, interval, radius, yRot, zRot, 0.0f, 0.0f, 0.0f);
    }

    public static void createBigDipperXYParticle(ParticleOptions particleOptions, Level level, Vec3 center, float interval, float radius, float yRot, float zRot, float xSpeed, float ySpeed, float zSpeed) {
        for (Vec3 pos : ParticleVFX.generateBigDipperXY(center, radius, interval, yRot, zRot)) {
            level.m_7106_(particleOptions, pos.f_82479_, pos.f_82480_, pos.f_82481_, (double)xSpeed, (double)ySpeed, (double)zSpeed);
        }
    }

    public static void createBigDipperXZParticle(ParticleOptions particleOptions, Level level, Vec3 center, float interval, float radius, float yRot) {
        ParticleVFX.createBigDipperXZParticle(particleOptions, level, center, interval, radius, yRot, 0.0f, 0.0f, 0.0f);
    }

    public static void createBigDipperXZParticle(ParticleOptions particleOptions, Level level, Vec3 center, float interval, float radius, float yRot, float xSpeed, float ySpeed, float zSpeed) {
        for (Vec3 pos : ParticleVFX.generateBigDipperXZ(center, radius, interval, yRot)) {
            level.m_7106_(particleOptions, pos.f_82479_, pos.f_82480_, pos.f_82481_, (double)xSpeed, (double)ySpeed, (double)zSpeed);
        }
    }

    public static List<Vec3> generateBigDipperXZ(Vec3 center, double scale, double interval, double yRot) {
        scale *= 0.5;
        Vec3[] basePoints = new Vec3[]{new Vec3(-4.5, 0.0, -2.0), new Vec3(-5.0, 0.0, 1.0), new Vec3(-2.0, 0.0, 3.0), new Vec3(0.0, 0.0, 0.0), new Vec3(2.0, 0.0, 0.5), new Vec3(3.5, 0.0, 1.0), new Vec3(6.0, 0.0, 0.0)};
        double radian = Math.toRadians(yRot);
        double cos = Math.cos(radian);
        double sin = Math.sin(radian);
        ArrayList<Vec3> vertices = new ArrayList<Vec3>();
        for (Vec3 p : basePoints) {
            double scaledX = p.f_82479_ * scale;
            double scaledZ = p.f_82481_ * scale;
            double rotatedX = scaledX * cos - scaledZ * sin;
            double rotatedZ = scaledX * sin + scaledZ * cos;
            double x = center.f_82479_ + rotatedX;
            double z = center.f_82481_ + rotatedZ;
            vertices.add(new Vec3(x, center.f_82480_, z));
        }
        if (interval == -1.0) {
            return new ArrayList<Vec3>(vertices);
        }
        LinkedHashSet<Vec3> path = new LinkedHashSet<Vec3>();
        for (int[] conn : CONNECTIONS) {
            Vec3 start = (Vec3)vertices.get(conn[0]);
            Vec3 end = (Vec3)vertices.get(conn[1]);
            double dx = end.f_82479_ - start.f_82479_;
            double dz = end.f_82481_ - start.f_82481_;
            double length = Math.sqrt(dx * dx + dz * dz);
            int steps = (int)Math.ceil(length / interval);
            for (int i = 0; i <= steps; ++i) {
                double t = (double)i / (double)steps;
                double x = start.f_82479_ + dx * t;
                double z = start.f_82481_ + dz * t;
                path.add(new Vec3(x, center.f_82480_, z));
            }
        }
        return new ArrayList<Vec3>(path);
    }

    public static List<Vec3> generateBigDipperXY(Vec3 center, double scale, double interval, double yRot, double zRot) {
        scale *= 0.5;
        Vec3[] basePoints = new Vec3[]{new Vec3(-4.5, -2.0, 0.0), new Vec3(-5.0, 1.0, 0.0), new Vec3(-2.0, 3.0, 0.0), new Vec3(0.0, 0.0, 0.0), new Vec3(2.0, 0.5, 0.0), new Vec3(3.5, 1.0, 0.0), new Vec3(6.0, 0.0, 0.0)};
        double rad = Math.toRadians(yRot);
        double cos = Math.cos(rad);
        double sin = Math.sin(rad);
        double zRad = Math.toRadians(zRot);
        double zCos = Math.cos(zRad);
        double zSin = Math.sin(zRad);
        ArrayList<Vec3> vertices = new ArrayList<Vec3>();
        for (Vec3 p : basePoints) {
            double scaledX = p.f_82479_ * scale;
            double scaledY = p.f_82480_ * scale;
            double zRotatedX = scaledX * zCos - scaledY * zSin;
            double zRotatedY = scaledX * zSin + scaledY * zCos;
            double rotatedX = zRotatedX * cos;
            double rotatedZ = zRotatedX * sin;
            vertices.add(new Vec3(center.f_82479_ + rotatedX, center.f_82480_ + zRotatedY, center.f_82481_ + rotatedZ));
        }
        if (interval == -1.0) {
            return new ArrayList<Vec3>(vertices);
        }
        LinkedHashSet<Vec3> path = new LinkedHashSet<Vec3>();
        for (int[] conn : CONNECTIONS) {
            Vec3 start = (Vec3)vertices.get(conn[0]);
            Vec3 end = (Vec3)vertices.get(conn[1]);
            double dx = end.f_82479_ - start.f_82479_;
            double dz = end.f_82481_ - start.f_82481_;
            double dy = end.f_82480_ - start.f_82480_;
            double length = Math.sqrt(dx * dx + dy * dy + dz * dz);
            int steps = (int)Math.ceil(length / interval);
            for (int i = 0; i <= steps; ++i) {
                double t = (double)i / (double)steps;
                path.add(new Vec3(start.f_82479_ + dx * t, start.f_82480_ + dy * t, start.f_82481_ + dz * t));
            }
        }
        return new ArrayList<Vec3>(path);
    }

    public static void createLineBetweenJoint(LivingEntityPatch<?> entityPatch, Joint joint1, Joint joint2, ParticleOptions particleOptions, int count) {
        Vec3 pos1 = AnimationUtils.getJointWorldPos(entityPatch, joint1);
        Vec3 pos2 = AnimationUtils.getJointWorldPos(entityPatch, joint2);
        LivingEntity livingEntity = (LivingEntity)entityPatch.getOriginal();
        ParticleVFX.createLineSegmentParticles(livingEntity.m_9236_(), pos1, pos2, particleOptions, count, livingEntity.m_20184_());
    }

    public static void createRandomLine(Level level, Vec3 center, ParticleOptions particleOptions, double minSpeed, double maxSpeed, int particleCount) {
        RandomSource random1 = level.f_46441_;
        for (int i = 0; i < particleCount; ++i) {
            double t = (double)i / (double)(particleCount - 1);
            double distance = t * 5.0;
            double angle = random1.m_188500_() * 2.0 * Math.PI;
            double pitch = random1.m_188500_() * Math.PI - 1.5707963267948966;
            double offsetX = Math.cos(angle) * Math.cos(pitch);
            double offsetY = Math.sin(pitch);
            double offsetZ = Math.sin(angle) * Math.cos(pitch);
            double x = center.m_7096_() + offsetX * distance;
            double y = center.m_7098_() + offsetY * distance;
            double z = center.m_7094_() + offsetZ * distance;
            double speed = minSpeed + random1.m_188500_() * (maxSpeed - minSpeed);
            level.m_7106_(particleOptions, x, y, z, offsetX * speed, offsetY * speed, offsetZ * speed);
        }
    }

    public static void createJointRandomLine(LivingEntityPatch<?> entityPatch, Joint joint, ParticleOptions particleOptions, double minSpeed, double maxSpeed, int particleCount) {
        LivingEntity entity = (LivingEntity)entityPatch.getOriginal();
        Level level = entity.m_9236_();
        Vec3 vec3 = AnimationUtils.getJointWorldPos(entityPatch, joint);
        RandomSource random = level.f_46441_;
        for (int i = 0; i < particleCount; ++i) {
            double t = (double)i / (double)(particleCount - 1);
            double distance = t * 5.0;
            double angle = random.m_188500_() * 2.0 * Math.PI;
            double pitch = random.m_188500_() * Math.PI - 1.5707963267948966;
            double offsetX = Math.cos(angle) * Math.cos(pitch);
            double offsetY = Math.sin(pitch);
            double offsetZ = Math.sin(angle) * Math.cos(pitch);
            double x = vec3.m_7096_() + offsetX * distance;
            double y = vec3.m_7098_() + offsetY * distance;
            double z = vec3.m_7094_() + offsetZ * distance;
            double speed = minSpeed + random.m_188500_() * (maxSpeed - minSpeed);
            if (!level.f_46443_) continue;
            level.m_7106_(particleOptions, x + entity.m_20185_(), y + entity.m_20186_(), z + entity.m_20189_(), offsetX * speed, offsetY * speed, offsetZ * speed);
        }
    }

    public static void createSphereParticles(Level level, Vec3 center, ParticleOptions particleOptions, double radius, double minSpeed, double maxSpeed, int particleCount) {
        RandomSource random = level.f_46441_;
        for (int i = 0; i < particleCount; ++i) {
            double angle = random.m_188500_() * 2.0 * Math.PI;
            double pitch = Math.acos(2.0 * random.m_188500_() - 1.0) - 1.5707963267948966;
            double offsetX = Math.cos(angle) * Math.cos(pitch);
            double offsetY = Math.sin(pitch);
            double offsetZ = Math.sin(angle) * Math.cos(pitch);
            double x = center.m_7096_() + offsetX * radius;
            double y = center.m_7098_() + offsetY * radius;
            double z = center.m_7094_() + offsetZ * radius;
            double speed = minSpeed + random.m_188500_() * (maxSpeed - minSpeed);
            level.m_6493_(particleOptions, true, x, y, z, offsetX * speed, offsetY * speed, offsetZ * speed);
        }
    }

    public static void createJointSphereParticles(LivingEntityPatch<?> entityPatch, Joint joint, ParticleOptions particleOptions, double radius, double minSpeed, double maxSpeed, int particleCount) {
        LivingEntity entity = (LivingEntity)entityPatch.getOriginal();
        Level level = entity.m_9236_();
        Vec3 vec3 = AnimationUtils.getJointWorldPos(entityPatch, joint);
        RandomSource random = level.f_46441_;
        for (int i = 0; i < particleCount; ++i) {
            double angle = random.m_188500_() * 2.0 * Math.PI;
            double pitch = Math.acos(2.0 * random.m_188500_() - 1.0) - 1.5707963267948966;
            double offsetX = Math.cos(angle) * Math.cos(pitch);
            double offsetY = Math.sin(pitch);
            double offsetZ = Math.sin(angle) * Math.cos(pitch);
            double x = vec3.m_7096_() + offsetX * radius;
            double y = vec3.m_7098_() + offsetY * radius;
            double z = vec3.m_7094_() + offsetZ * radius;
            double speed = minSpeed + random.m_188500_() * (maxSpeed - minSpeed);
            if (!level.f_46443_) continue;
            level.m_7106_(particleOptions, x + entity.m_20185_(), y + entity.m_20186_(), z + entity.m_20189_(), offsetX * speed, offsetY * speed, offsetZ * speed);
        }
    }

    public static void createDirectionalParticles(LivingEntityPatch<?> entityPatch, Vec3 center, ParticleOptions particleOptions, double radius, double minSpeed, double maxSpeed, int particleCount) {
        LivingEntity entity = (LivingEntity)entityPatch.getOriginal();
        Level level = entity.m_9236_();
        RandomSource random = level.f_46441_;
        for (int i = 0; i < particleCount; ++i) {
            double theta = random.m_188500_() * 2.0 * Math.PI;
            double phi = Math.acos(2.0 * random.m_188500_() - 1.0);
            double dirX = Math.sin(phi) * Math.cos(theta);
            double dirY = Math.cos(phi);
            double dirZ = Math.sin(phi) * Math.sin(theta);
            double posX = center.m_7096_() + dirX;
            double posY = center.m_7098_() + dirY;
            double posZ = center.m_7094_() + dirZ;
            double speed = minSpeed + random.m_188500_() * (maxSpeed - minSpeed);
            if (!level.f_46443_) continue;
            level.m_6493_(particleOptions, true, posX, posY, posZ, dirX * speed, dirY * speed, dirZ * speed);
        }
    }

    public static void createJointDirectionalParticles(LivingEntityPatch<?> entityPatch, Joint joint, ParticleOptions particleOptions, double radius, double minSpeed, double maxSpeed, int particleCount) {
        LivingEntity entity = (LivingEntity)entityPatch.getOriginal();
        Level level = entity.m_9236_();
        Vec3 jointPos = AnimationUtils.getJointWorldPos(entityPatch, joint);
        RandomSource random = level.f_46441_;
        for (int i = 0; i < particleCount; ++i) {
            double theta = random.m_188500_() * 2.0 * Math.PI;
            double phi = Math.acos(2.0 * random.m_188500_() - 1.0);
            double dirX = Math.sin(phi) * Math.cos(theta);
            double dirY = Math.cos(phi);
            double dirZ = Math.sin(phi) * Math.sin(theta);
            double posX = jointPos.m_7096_() + dirX;
            double posY = jointPos.m_7098_() + dirY;
            double posZ = jointPos.m_7094_() + dirZ;
            double speed = minSpeed + random.m_188500_() * (maxSpeed - minSpeed);
            if (!level.f_46443_) continue;
            level.m_6493_(particleOptions, true, posX, posY, posZ, dirX * speed, dirY * speed, dirZ * speed);
        }
    }

    public static void createRingParticles(Level level, Vec3 center, ParticleOptions particleOptions, double radius, double minSpeed, double maxSpeed, int particleCount) {
        RandomSource random = level.f_46441_;
        for (int i = 0; i < particleCount; ++i) {
            double angle = random.m_188500_() * 2.0 * Math.PI;
            double x = center.m_7096_() + Math.cos(angle) * radius;
            double y = center.m_7098_();
            double z = center.m_7094_() + Math.sin(angle) * radius;
            double speedX = -Math.sin(angle);
            double speedZ = Math.cos(angle);
            double speed = minSpeed + random.m_188500_() * (maxSpeed - minSpeed);
            level.m_7106_(particleOptions, x, y, z, speedX * speed, 0.0, speedZ * speed);
        }
    }

    public static void createJointRingParticles(LivingEntityPatch<?> entityPatch, Joint joint, ParticleOptions particleOptions, double radius, double minSpeed, double maxSpeed, int particleCount) {
        LivingEntity entity = (LivingEntity)entityPatch.getOriginal();
        Level level = entity.m_9236_();
        Vec3 vec3 = AnimationUtils.getJointWorldPos(entityPatch, joint);
        RandomSource random = level.f_46441_;
        for (int i = 0; i < particleCount; ++i) {
            double angle = random.m_188500_() * 2.0 * Math.PI;
            double x = vec3.m_7096_() + Math.cos(angle) * radius;
            double y = vec3.m_7098_();
            double z = vec3.m_7094_() + Math.sin(angle) * radius;
            double speedX = -Math.sin(angle);
            double speedZ = Math.cos(angle);
            double speed = minSpeed + random.m_188500_() * (maxSpeed - minSpeed);
            level.m_7106_(particleOptions, x + entity.m_20185_(), y + entity.m_20186_(), z + entity.m_20189_(), speedX * speed, 0.0, speedZ * speed);
        }
    }

    public static void createRandomInSphereParticles(Level level, Vec3 center, ParticleOptions particleOptions, double radius, double minSpeed, double maxSpeed, int particleCount) {
        RandomSource random = level.f_46441_;
        for (int i = 0; i < particleCount; ++i) {
            double r = radius * Math.cbrt(random.m_188500_());
            double angle = random.m_188500_() * 2.0 * Math.PI;
            double pitch = Math.acos(2.0 * random.m_188500_() - 1.0) - 1.5707963267948966;
            double x = center.m_7096_() + r * Math.cos(angle) * Math.cos(pitch);
            double y = center.m_7098_() + r * Math.sin(pitch);
            double z = center.m_7094_() + r * Math.sin(angle) * Math.cos(pitch);
            double speed = minSpeed + random.m_188500_() * (maxSpeed - minSpeed);
            double dirAngle = random.m_188500_() * 2.0 * Math.PI;
            double dirPitch = random.m_188500_() * Math.PI - 1.5707963267948966;
            double dirX = Math.cos(dirAngle) * Math.cos(dirPitch);
            double dirY = Math.sin(dirPitch);
            double dirZ = Math.sin(dirAngle) * Math.cos(dirPitch);
            level.m_6493_(particleOptions, true, x, y, z, dirX * speed, dirY * speed, dirZ * speed);
        }
    }

    public static void createJointRandomInSphereParticles(LivingEntityPatch<?> entityPatch, Joint joint, ParticleOptions particleOptions, double radius, double minSpeed, double maxSpeed, int particleCount) {
        LivingEntity entity = (LivingEntity)entityPatch.getOriginal();
        Level level = entity.m_9236_();
        Vec3 vec3 = AnimationUtils.getJointWorldPos(entityPatch, joint);
        RandomSource random = level.f_46441_;
        for (int i = 0; i < particleCount; ++i) {
            double r = radius * Math.cbrt(random.m_188500_());
            double angle = random.m_188500_() * 2.0 * Math.PI;
            double pitch = Math.acos(2.0 * random.m_188500_() - 1.0) - 1.5707963267948966;
            double x = vec3.m_7096_() + r * Math.cos(angle) * Math.cos(pitch);
            double y = vec3.m_7098_() + r * Math.sin(pitch);
            double z = vec3.m_7094_() + r * Math.sin(angle) * Math.cos(pitch);
            double speed = minSpeed + random.m_188500_() * (maxSpeed - minSpeed);
            double dirAngle = random.m_188500_() * 2.0 * Math.PI;
            double dirPitch = random.m_188500_() * Math.PI - 1.5707963267948966;
            double dirX = Math.cos(dirAngle) * Math.cos(dirPitch);
            double dirY = Math.sin(dirPitch);
            double dirZ = Math.sin(dirAngle) * Math.cos(dirPitch);
            if (!level.f_46443_) continue;
            level.m_7106_(particleOptions, x + entity.m_20185_(), y + entity.m_20186_(), z + entity.m_20189_(), dirX * speed, dirY * speed, dirZ * speed);
        }
    }

    public static void createLineSegmentParticles(Level level, Vec3 start, Vec3 end, ParticleOptions particleOptions, int particleCount, Vec3 deltaMovement) {
        Vec3 direction = end.m_82546_(start);
        for (int i = 0; i < particleCount; ++i) {
            double t = (double)i / (double)(particleCount - 1);
            Vec3 pos = start.m_82549_(direction.m_82490_(t));
            level.m_7106_(particleOptions, pos.f_82479_, pos.f_82480_, pos.f_82481_, deltaMovement.f_82479_, deltaMovement.f_82480_, deltaMovement.f_82481_);
        }
    }

    public static void createLineSegmentParticles(Level level, Vec3 start, Vec3 end, ParticleOptions particleOptions, double minSpeed, double maxSpeed, int particleCount) {
        RandomSource random = level.f_46441_;
        Vec3 direction = end.m_82546_(start);
        for (int i = 0; i < particleCount; ++i) {
            double t = (double)i / (double)(particleCount - 1);
            Vec3 pos = start.m_82549_(direction.m_82490_(t));
            double speed = minSpeed + random.m_188500_() * (maxSpeed - minSpeed);
            double dirX = direction.f_82479_ / (double)particleCount;
            double dirY = direction.f_82480_ / (double)particleCount;
            double dirZ = direction.f_82481_ / (double)particleCount;
            level.m_7106_(particleOptions, pos.f_82479_, pos.f_82480_, pos.f_82481_, dirX * speed, dirY * speed, dirZ * speed);
        }
    }

    public static void createMovingParticles(Level level, Vec3 start, Vec3 end, ParticleOptions particleOptions, double minSpeed, double maxSpeed, int particleCount) {
        RandomSource random = level.f_46441_;
        Vec3 direction = end.m_82546_(start).m_82541_();
        for (int i = 0; i < particleCount; ++i) {
            double speed = minSpeed + random.m_188500_() * (maxSpeed - minSpeed);
            level.m_7106_(particleOptions, start.f_82479_, start.f_82480_, start.f_82481_, direction.f_82479_ * speed, direction.f_82480_ * speed, direction.f_82481_ * speed);
        }
    }
}

