/*
 * Decompiled with CFR 0.152.
 */
package dev.huey.voidBounce;

import com.destroystokyo.paper.ParticleBuilder;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Particle;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public final class VoidBounce
extends JavaPlugin
implements TabCompleter,
CommandExecutor,
Listener {
    static boolean enabled;
    static double voidHeight;
    static double groundHeight;
    static double strength;
    File file;
    YamlConfiguration config;
    BukkitRunnable tickTask = new BukkitRunnable(){

        public void run() {
            VoidBounce.this.onTick();
        }
    };
    Component prefix = Component.join((JoinConfiguration)JoinConfiguration.noSeparators(), (ComponentLike[])new ComponentLike[]{Component.text((String)"["), Component.text((String)"Void").color((TextColor)NamedTextColor.DARK_PURPLE), Component.text((String)"Bounce").color((TextColor)NamedTextColor.LIGHT_PURPLE), Component.text((String)"] ")}).colorIfAbsent((TextColor)NamedTextColor.GRAY);
    Set<Player> voided = new HashSet<Player>();

    void load() {
        this.file = new File(this.getDataFolder(), "config.yml");
        if (!this.file.exists()) {
            try {
                this.getDataFolder().mkdirs();
                this.file.createNewFile();
            }
            catch (IOException e) {
                this.getLogger().severe("Weird: Could not create config file?");
            }
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        for (Data<?> data : Data.values()) {
            this.config.addDefault(data.id, data.def);
        }
        this.config.options().copyDefaults(true);
        for (Data<?> data : Data.values()) {
            data.set(this.config.get(data.id));
        }
        this.save();
    }

    void save() {
        for (Data<?> data : Data.values()) {
            this.config.set(data.id, data.get());
        }
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            this.getLogger().severe("Weird: Could not save config file?");
        }
    }

    public void onEnable() {
        PluginCommand command = this.getCommand("voidbounce");
        if (command == null) {
            this.getLogger().severe("Weird: Command not found?");
        } else {
            command.setTabCompleter((TabCompleter)this);
            command.setExecutor((CommandExecutor)this);
        }
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.load();
        this.tickTask.runTaskTimer((Plugin)this, 0L, 1L);
        this.getLogger().info("Enabled!");
    }

    public void onDisable() {
        this.tickTask.cancel();
        this.save();
        this.getLogger().info("Disabled!");
    }

    void send(Audience aud, String msg, NamedTextColor col) {
        aud.sendMessage(this.prefix.append(Component.text((String)msg).color((TextColor)col)));
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        String lastArg = args[args.length - 1];
        switch (args.length) {
            case 1: {
                return Stream.of("reload", "save", "set", "get", "toggle").filter(s -> s.contains(lastArg)).toList();
            }
            case 2: {
                switch (args[0].toLowerCase()) {
                    case "get": 
                    case "set": {
                        return Data.values().stream().filter(d -> d != Data.Enabled).map(d -> d.id).filter(s -> s.contains(lastArg)).toList();
                    }
                }
                break;
            }
            case 3: {
                switch (args[0].toLowerCase()) {
                    case "set": {
                        return List.of("<value>");
                    }
                }
            }
        }
        return Collections.emptyList();
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String @NotNull [] args) {
        Player pl;
        if (sender instanceof Player && !(pl = (Player)sender).isOp()) {
            this.send((Audience)pl, "Only server OPs can use this command!", NamedTextColor.RED);
            return true;
        }
        if (args.length == 0) {
            this.send((Audience)sender, enabled ? "I'm running!" : "I'm inactive!", NamedTextColor.GREEN);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                this.load();
                this.send((Audience)sender, "Config reloaded!", NamedTextColor.GREEN);
                break;
            }
            case "save": {
                this.save();
                this.send((Audience)sender, "Config saved!", NamedTextColor.GREEN);
                break;
            }
            case "toggle": {
                enabled = !enabled;
                this.send((Audience)sender, enabled ? "Enabled!" : "Disabled!", NamedTextColor.GREEN);
                break;
            }
            case "get": {
                if (args.length < 2) {
                    this.send((Audience)sender, "Get what?", NamedTextColor.RED);
                    return true;
                }
                for (Data<?> data : Data.values()) {
                    if (data == Data.Enabled || !data.id.equalsIgnoreCase(args[1])) continue;
                    if (data.clazz == Double.class) {
                        this.send((Audience)sender, "'%s' is currently %.2f".formatted(data.id, (Double)data.get()), NamedTextColor.GREEN);
                    } else {
                        this.send((Audience)sender, "Weird: Value is not a double?", NamedTextColor.RED);
                    }
                    return true;
                }
                this.send((Audience)sender, "No such thing!", NamedTextColor.RED);
                break;
            }
            case "set": {
                if (args.length < 2) {
                    this.send((Audience)sender, "Set what?", NamedTextColor.RED);
                    return true;
                }
                if (args.length < 3) {
                    this.send((Audience)sender, "Set to what?", NamedTextColor.RED);
                    return true;
                }
                for (Data<?> data : Data.values()) {
                    if (data == Data.Enabled || !data.id.equalsIgnoreCase(args[1])) continue;
                    if (data.clazz == Double.class) {
                        double value;
                        try {
                            value = Double.parseDouble(args[2]);
                        }
                        catch (NumberFormatException e) {
                            this.send((Audience)sender, "Invalid number!", NamedTextColor.RED);
                            return true;
                        }
                        data.set(value);
                        this.send((Audience)sender, "'%s' is set to %.2f".formatted(data.id, value), NamedTextColor.GREEN);
                        if (groundHeight <= voidHeight) {
                            Data.GroundHeight.set(voidHeight + 10.0);
                            this.send((Audience)sender, "'ground-height' should be higher than 'void-height', adjusted it to %.2f".formatted(groundHeight), NamedTextColor.YELLOW);
                        }
                        if (strength < 2.0) {
                            Data.Strength.set(2.0);
                            this.send((Audience)sender, "'velocity' is too small, adjusted it to 2.00", NamedTextColor.YELLOW);
                        }
                    } else {
                        this.send((Audience)sender, "Weird: Value is not a double?", NamedTextColor.RED);
                    }
                    return true;
                }
                this.send((Audience)sender, "No such thing!", NamedTextColor.RED);
            }
        }
        return true;
    }

    boolean shouldSkip(Player pl) {
        return !enabled || List.of(GameMode.CREATIVE, GameMode.SPECTATOR).contains(pl.getGameMode());
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent ev) {
        this.voided.remove(ev.getPlayer());
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent ev) {
        if (!ev.hasChangedPosition()) {
            return;
        }
        Player pl = ev.getPlayer();
        if (this.shouldSkip(pl)) {
            return;
        }
        if (pl.getY() <= voidHeight) {
            if (!this.voided.contains(pl)) {
                new ParticleBuilder(Particle.CLOUD).allPlayers().location(pl.getLocation().add(0.0, -1.0, 0.0)).offset(0.2, 0.1, 0.2).count(20).extra(0.02).spawn();
                pl.playSound((Sound)Sound.sound().type(Key.key((String)"minecraft:block.slime_block.place")).source(Sound.Source.MASTER).build(), Sound.Emitter.self());
            }
            this.voided.add(ev.getPlayer());
        }
        if (pl.getY() >= groundHeight) {
            this.voided.remove(ev.getPlayer());
        }
    }

    void onTick() {
        for (Player pl : Bukkit.getOnlinePlayers()) {
            Vector vec;
            if (this.shouldSkip(pl) || !this.voided.contains(pl)) continue;
            vec.setY(((vec = pl.getVelocity()).getY() < 0.0 ? vec.getY() / 2.0 : vec.getY()) + strength / 20.0);
            pl.setVelocity(vec);
        }
    }

    record Data<T>(Class<T> clazz, String id, T def, Supplier<T> getter, Consumer<T> setter) {
        static final Data<Boolean> Enabled = new Data<Boolean>(Boolean.class, "enabled", true, () -> enabled, v -> {
            enabled = v;
        });
        static final Data<Double> VoidHeight = new Data<Double>(Double.class, "void-height", 70.0, () -> voidHeight, v -> {
            voidHeight = v;
        });
        static final Data<Double> GroundHeight = new Data<Double>(Double.class, "ground-height", 80.0, () -> groundHeight, v -> {
            groundHeight = v;
        });
        static final Data<Double> Strength = new Data<Double>(Double.class, "strength", 3.0, () -> strength, v -> {
            strength = v;
        });

        static List<Data<?>> values() {
            return List.of(Enabled, VoidHeight, GroundHeight, Strength);
        }

        void set(Object v) {
            if (this.clazz.isInstance(v)) {
                this.setter.accept(v);
            }
        }

        T get() {
            return this.getter.get();
        }
    }
}

