/*
 * Decompiled with CFR 0.152.
 */
package vzling.hadean.breathe.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import vzling.hadean.breathe.client.animation.FlameGuardianEntityAnimation;
import vzling.hadean.breathe.entity.FlameGuardianEntity;
import vzling.lib.client.model.AnimatableEntityModel;

@OnlyIn(value=Dist.CLIENT)
public class FlameGuardianEntityModel<T extends FlameGuardianEntity>
extends AnimatableEntityModel<T>
implements ArmedModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"hadean_breathe", (String)"flame_guardian"), "main");
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart arm0;
    private final ModelPart arm1;
    private final ModelPart leg0;
    private final ModelPart leg1;

    public FlameGuardianEntityModel(ModelPart root) {
        this.root = root.m_171324_("root");
        this.body = this.root.m_171324_("body");
        this.head = this.body.m_171324_("head");
        this.arm0 = this.body.m_171324_("arm0");
        this.arm1 = this.body.m_171324_("arm1");
        this.leg0 = this.root.m_171324_("leg0");
        this.leg1 = this.root.m_171324_("leg1");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_().m_171514_(0, 70).m_171488_(-4.5f, -21.0f, -3.0f, 9.0f, 5.0f, 6.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 40).m_171488_(-9.0f, -12.0f, -6.0f, 18.0f, 12.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-21.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171488_(-1.0f, -5.0f, -7.5f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-10.0f, (float)-2.0f));
        PartDefinition head_r1 = head.m_171599_("head_r1", CubeListBuilder.m_171558_().m_171514_(16, 4).m_171488_(8.0f, -8.0f, -4.0f, 3.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(6, 4).m_171488_(4.0f, -5.0f, -4.0f, 7.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(6, 5).m_171488_(-4.0f, -8.0f, 8.0f, 4.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(2, 1).m_171488_(-4.0f, -5.0f, 4.0f, 4.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-4.0f, -5.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-7.0f, (float)-1.5f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition arm0 = body.m_171599_("arm0", CubeListBuilder.m_171558_().m_171514_(60, 21).m_171488_(-4.0f, -3.5f, -3.0f, 4.0f, 30.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-9.0f, (float)-9.0f, (float)0.0f));
        PartDefinition arm1 = body.m_171599_("arm1", CubeListBuilder.m_171558_().m_171514_(60, 58).m_171488_(0.0f, -3.5f, -3.0f, 4.0f, 30.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)9.0f, (float)-9.0f, (float)0.0f));
        PartDefinition leg0 = root.m_171599_("leg0", CubeListBuilder.m_171558_().m_171514_(37, 0).m_171488_(-3.5f, -3.0f, -3.0f, 6.0f, 16.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)-13.0f, (float)0.0f));
        PartDefinition leg1 = root.m_171599_("leg1", CubeListBuilder.m_171558_().m_171514_(60, 0).m_171480_().m_171488_(-3.5f, -3.0f, -3.0f, 6.0f, 16.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)5.0f, (float)-13.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public ModelPart root() {
        return this.root;
    }

    public ModelPart getHead() {
        return this.head;
    }

    public void setupWalkAnimation(T entity, float limbSwing, float limbSwingAmount) {
        this.animateWalk(FlameGuardianEntityAnimation.WALK, limbSwing, limbSwingAmount, 2.0f, 2.0f);
    }

    public void m_6002_(@NotNull HumanoidArm arm, @NotNull PoseStack stack) {
        this.root.m_104299_(stack);
        this.body.m_104299_(stack);
        ModelPart armPart = arm == HumanoidArm.LEFT ? this.arm1 : this.arm0;
        armPart.m_104299_(stack);
        stack.m_85837_(arm == HumanoidArm.LEFT ? 0.1 : -0.1, 0.75, 0.0);
    }
}

