/*
 * Decompiled with CFR 0.152.
 */
package vzling.hadean.breathe.entity;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Targeting;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import vzling.hadean.breathe.entity.HadeanEnforcerEntity;
import vzling.lib.entity.AbstractSkillEntity;
import vzling.lib.init.MobEffectInit;
import vzling.lib.init.ParticleInit;
import vzling.lib.util.EntityUtil;

public class EmberEntity
extends ThrowableProjectile {
    private State state = State.FLYING;
    private boolean hitTarget = false;
    private boolean hit = false;

    public EmberEntity(EntityType<? extends ThrowableProjectile> type, Level level) {
        super(type, level);
    }

    public EmberEntity(EntityType<? extends ThrowableProjectile> type, Level level, LivingEntity owner) {
        super(type, owner, level);
        this.m_146884_(owner.m_20182_());
    }

    public boolean m_20069_() {
        return false;
    }

    public boolean m_20068_() {
        return true;
    }

    protected void m_8097_() {
    }

    public void m_8119_() {
        Entity vec;
        Entity skillEntity;
        Targeting targeting;
        Entity entity;
        super.m_8119_();
        this.m_146922_(0.0f);
        this.m_146926_(0.0f);
        this.f_19859_ = 0.0f;
        this.f_19860_ = 0.0f;
        this.m_9236_().m_7106_((ParticleOptions)(this.isDuck() ? (ParticleOptions)ParticleInit.DUCK_FLAME.get() : ParticleTypes.f_123744_), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), Mth.m_216263_((RandomSource)this.f_19796_, (double)-0.1, (double)0.1), Mth.m_216263_((RandomSource)this.f_19796_, (double)-0.1, (double)0.1), Mth.m_216263_((RandomSource)this.f_19796_, (double)-0.1, (double)0.1));
        if ((this.m_19749_() == null || !this.m_19749_().m_6084_() || !((entity = this.m_19749_()) instanceof Targeting) || (targeting = (Targeting)entity).m_5448_() == null || !targeting.m_5448_().m_6084_() || (entity = this.m_19749_()) instanceof AbstractSkillEntity && !(skillEntity = (AbstractSkillEntity)entity).isUsingSkill()) && this.m_6084_()) {
            this.m_146870_();
        }
        if (this.f_19797_ % 10 == 5) {
            this.m_216990_(SoundEvents.f_12520_);
        }
        if (this.f_19797_ >= 85) {
            this.m_146870_();
        }
        if (this.f_19797_ == 65) {
            this.state = State.RETURNING;
            this.m_216990_(SoundEvents.f_12516_);
        }
        if (this.state == State.FLYING && (skillEntity = this.m_19749_()) instanceof Targeting && (targeting = (Targeting)skillEntity).m_5448_() != null) {
            Entity entity2;
            vec = targeting.m_5448_().m_20182_().m_82520_(0.0, 0.5, 0.0).m_82546_(this.m_20182_()).m_82541_();
            if ((double)this.m_20270_((Entity)targeting.m_5448_()) >= 0.75) {
                this.m_20256_(vec.m_82490_(0.4));
            } else {
                this.m_20256_(Vec3.f_82478_);
            }
            if (this.hitTarget && (entity2 = this.m_19749_()) instanceof LivingEntity) {
                LivingEntity entity3 = (LivingEntity)entity2;
                targeting.m_5448_().m_7311_(Math.max(targeting.m_5448_().m_20094_(), 60));
                if (EntityUtil.forceHurt((LivingEntity)targeting.m_5448_(), (DamageSource)entity3.m_269291_().m_269333_(entity3), (float)13.0f)) {
                    EntityUtil.forceAddEffect((LivingEntity)targeting.m_5448_(), (MobEffectInstance)new MobEffectInstance((MobEffect)MobEffectInit.VERTIGO.get(), 20, 0, false, false));
                    Level level = entity3.m_9236_();
                    if (level instanceof ServerLevel) {
                        ServerLevel level2 = (ServerLevel)level;
                        level2.m_8767_((ParticleOptions)(this.isDuck() ? (SimpleParticleType)ParticleInit.DUCK_FLAME.get() : ParticleTypes.f_123744_), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 8, 0.0, 0.0, 0.0, 0.25);
                    }
                }
            }
        }
        if (this.state == State.RETURNING && (vec = this.m_19749_()) instanceof Targeting && (targeting = (Targeting)vec).m_5448_() != null) {
            vec = this.m_19749_().m_20182_().m_82520_(0.0, 0.5, 0.0).m_82546_(this.m_20182_());
            this.m_20256_(vec.m_82490_(1.0 / (double)(85 - this.f_19797_)));
            if (this.hitTarget) {
                targeting.m_5448_().m_20256_(this.m_20182_().m_82546_(targeting.m_5448_().m_20182_()));
                targeting.m_5448_().f_19864_ = true;
                if (!this.hit) {
                    EntityUtil.forceAddEffect((LivingEntity)targeting.m_5448_(), (MobEffectInstance)new MobEffectInstance((MobEffect)MobEffectInit.VERTIGO.get(), 60, 0, false, false));
                    this.hit = true;
                }
            }
        }
    }

    protected void m_5790_(@NotNull EntityHitResult result) {
        super.m_5790_(result);
        Entity entity = result.m_82443_();
        if (entity instanceof LivingEntity) {
            LivingEntity owner;
            LivingEntity entity2 = (LivingEntity)entity;
            entity = this.m_19749_();
            if (entity instanceof LivingEntity && !entity2.m_7306_((Entity)(owner = (LivingEntity)entity))) {
                entity2.m_7311_(Math.max(entity2.m_20094_(), 60));
                if (EntityUtil.forceHurt((LivingEntity)entity2, (DamageSource)this.m_19749_().m_269291_().m_269333_(owner), (float)13.0f)) {
                    EntityUtil.forceAddEffect((LivingEntity)entity2, (MobEffectInstance)new MobEffectInstance((MobEffect)MobEffectInit.VERTIGO.get(), 20, 0, false, false));
                    Level level = entity2.m_9236_();
                    if (level instanceof ServerLevel) {
                        ServerLevel level2 = (ServerLevel)level;
                        level2.m_8767_((ParticleOptions)(this.isDuck() ? (SimpleParticleType)ParticleInit.DUCK_FLAME.get() : ParticleTypes.f_123744_), entity2.m_20185_(), entity2.m_20186_() + 0.5, entity2.m_20189_(), 8, 0.0, 0.0, 0.0, 0.25);
                    }
                }
                this.hitTarget = true;
            }
        }
    }

    public boolean isDuck() {
        HadeanEnforcerEntity entity;
        Entity entity2 = this.m_19749_();
        return entity2 instanceof HadeanEnforcerEntity && (entity = (HadeanEnforcerEntity)entity2).isDuck();
    }

    public static enum State {
        FLYING,
        RETURNING;

    }
}

