/*
 * Decompiled with CFR 0.152.
 */
package vzling.hadean.breathe.item;

import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vzling.hadean.breathe.client.model.EnforcerArmorModel;
import vzling.hadean.breathe.init.HBItem;
import vzling.hadean.breathe.init.HBKeyMapping;
import vzling.hadean.breathe.init.HBNetwork;
import vzling.hadean.breathe.network.DemonModePacket;

public class EnforcerArmorItem
extends ArmorItem {
    public EnforcerArmorItem(ArmorMaterial material, ArmorItem.Type type, Item.Properties properties) {
        super(material, type, properties);
    }

    public void initializeClient(@NotNull Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new ArmorRender());
    }

    public void m_6883_(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int time, boolean selected) {
        Player player;
        super.m_6883_(stack, level, entity, time, selected);
        CompoundTag tag = stack.m_41784_();
        int demonTime = tag.m_128451_("demonTime");
        int demonCooldown = tag.m_128451_("demonCooldown");
        if (entity instanceof Player && (player = (Player)entity).m_6844_(EquipmentSlot.HEAD).m_150930_((Item)HBItem.ENFORCER_HOOD.get()) && player.m_6844_(EquipmentSlot.CHEST).m_150930_((Item)HBItem.ENFORCER_CHESTPLATE.get()) && player.m_6844_(EquipmentSlot.LEGS).m_150930_((Item)HBItem.ENFORCER_LEGGINGS.get()) && player.m_6844_(EquipmentSlot.FEET).m_150930_((Item)HBItem.ENFORCER_BOOTS.get()) && player.m_6844_(EquipmentSlot.CHEST) == stack) {
            if (!level.f_46443_) {
                if (demonTime > 0) {
                    tag.m_128405_("demonTime", demonTime - 1);
                } else if (demonCooldown > 0) {
                    tag.m_128405_("demonCooldown", demonCooldown - 1);
                }
            } else if (HBKeyMapping.USE_SKILL.m_90859_() && demonCooldown == 0) {
                HBNetwork.CHANNEL.sendToServer((Object)new DemonModePacket());
            }
        } else {
            tag.m_128405_("demonTime", 0);
        }
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return ResourceLocation.fromNamespaceAndPath((String)"hadean_breathe", (String)("textures/armor/enforcer_armor" + (slot == EquipmentSlot.LEGS ? "_2.png" : "_1.png"))).toString();
    }

    private static final class ArmorRender
    implements IClientItemExtensions {
        private ArmorRender() {
        }

        @NotNull
        public HumanoidModel<?> getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel<?> model) {
            EnforcerArmorModel innerModel = new EnforcerArmorModel(Minecraft.m_91087_().m_167973_().m_171103_(EnforcerArmorModel.INNER));
            EnforcerArmorModel outerModel = new EnforcerArmorModel(Minecraft.m_91087_().m_167973_().m_171103_(EnforcerArmorModel.OUTER));
            EnforcerArmorModel armorModel = slot == EquipmentSlot.LEGS ? innerModel : outerModel;
            return armorModel;
        }
    }
}

