/*
 * Decompiled with CFR 0.152.
 */
package vzling.hadean.breathe.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.NotNull;
import vzling.hadean.breathe.entity.HadeanGhastEntity;
import vzling.lib.client.model.AnimatedModel;

public class HadeanGhastEntityModel<T extends HadeanGhastEntity>
extends EntityModel<T>
implements AnimatedModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"hadean_breathe", (String)"hadean_ghast"), "main");
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart[] tentacles = new ModelPart[9];

    public HadeanGhastEntityModel(ModelPart root) {
        this.root = root;
        this.body = root.m_171324_("body");
        for (int $$1 = 0; $$1 < this.tentacles.length; ++$$1) {
            this.tentacles[$$1] = root.m_171324_("body").m_171324_(HadeanGhastEntityModel.createTentacleName($$1));
        }
    }

    private static String createTentacleName(int i) {
        return "tentacle" + i;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-8.0f, -8.0f, -8.0f, 16.0f, 16.0f, 16.0f), PartPose.m_171419_((float)0.0f, (float)17.6f, (float)0.0f));
        RandomSource randomSource = RandomSource.m_216335_((long)1660L);
        for (int i = 0; i < 9; ++i) {
            float xPoint = (((float)(i % 3) - (float)(i / 3 % 2) * 0.5f + 0.25f) / 2.0f * 2.0f - 1.0f) * 5.0f;
            float zPoint = ((float)(i / 3) / 2.0f * 2.0f - 1.0f) * 5.0f;
            int length = randomSource.m_188503_(7) + 8;
            body.m_171599_("tentacle" + i, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, (float)length, 2.0f), PartPose.m_171419_((float)xPoint, (float)7.0f, (float)zPoint));
        }
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    @NotNull
    public ModelPart root() {
        return this.root;
    }

    public void setupAnim(@NotNull T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        for (int $$6 = 0; $$6 < this.tentacles.length; ++$$6) {
            this.tentacles[$$6].f_104203_ = 0.2f * Mth.m_14031_((float)(ageInTicks * 0.3f + (float)$$6)) + 0.4f;
        }
        this.body.f_104203_ = headPitch / 57.295776f;
        this.body.f_104204_ = netHeadYaw / 57.295776f;
    }

    public void m_7695_(@NotNull PoseStack stack, @NotNull VertexConsumer consumer, int light, int overlay, float red, float green, float blue, float alpha) {
        this.root().m_104306_(stack, consumer, light, overlay, red, green, blue, alpha);
    }
}

