/*
 * Decompiled with CFR 0.152.
 */
package vzling.hadean.breathe.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vzling.hadean.breathe.block.entity.EnforcerTreasureChestBlockEntity;
import vzling.hadean.breathe.init.HBBlockEntity;

public class EnforcerTreasureChestBlock
extends ShulkerBoxBlock {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0);

    public EnforcerTreasureChestBlock(BlockBehaviour.Properties properties) {
        super(DyeColor.RED, properties);
    }

    @NotNull
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new EnforcerTreasureChestBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return EnforcerTreasureChestBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)HBBlockEntity.ENFORCER_TREASURE_CHEST.get()), ShulkerBoxBlockEntity::m_155672_);
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter getter, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return SHAPE;
    }

    @NotNull
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_56183_, (Comparable)context.m_8125_().m_122424_());
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult result) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (player.m_5833_()) {
            return InteractionResult.CONSUME;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof EnforcerTreasureChestBlockEntity) {
            EnforcerTreasureChestBlockEntity chestBlockEntity = (EnforcerTreasureChestBlockEntity)blockEntity;
            if (EnforcerTreasureChestBlock.canOpen(level, pos, chestBlockEntity)) {
                player.m_5893_((MenuProvider)chestBlockEntity);
                player.m_36220_(Stats.f_12970_);
                PiglinAi.m_34873_((Player)player, (boolean)true);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    private static boolean canOpen(Level level, BlockPos pos, EnforcerTreasureChestBlockEntity chestBlockEntity) {
        if (chestBlockEntity.m_59700_() != ShulkerBoxBlockEntity.AnimationStatus.CLOSED) {
            return true;
        }
        AABB aabb = Shulker.m_149793_((Direction)Direction.UP, (float)0.0f, (float)0.5f).m_82338_(pos).m_82406_(1.0E-6);
        return level.m_45772_(aabb);
    }

    public void m_5707_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player) {
        this.m_142387_(level, player, pos, state);
        if (state.m_204336_(BlockTags.f_13088_)) {
            PiglinAi.m_34873_((Player)player, (boolean)false);
        }
        level.m_220407_(GameEvent.f_157794_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)state));
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof EnforcerTreasureChestBlockEntity) {
            EnforcerTreasureChestBlockEntity chestBlockEntity = (EnforcerTreasureChestBlockEntity)blockEntity;
            if (!level.f_46443_ && player.m_7500_() && !chestBlockEntity.m_7983_()) {
                ItemStack stack = new ItemStack((ItemLike)this);
                blockEntity.m_187476_(stack);
                if (chestBlockEntity.m_8077_()) {
                    stack.m_41714_(chestBlockEntity.m_7770_());
                }
                ItemEntity itemEntity = new ItemEntity(level, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), stack);
                itemEntity.m_32060_();
                level.m_7967_((Entity)itemEntity);
            } else {
                chestBlockEntity.m_59640_(player);
            }
        }
    }
}

