/*
 * Decompiled with CFR 0.152.
 */
package vzling.hadean.breathe.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import vzling.hadean.breathe.block.EnforcerTreasureChestBlock;
import vzling.hadean.breathe.block.entity.EnforcerTreasureChestBlockEntity;

public class EnforcerTreasureChestBlockEntityRenderer<T extends EnforcerTreasureChestBlockEntity>
implements BlockEntityRenderer<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"hadean_breathe", (String)"enforcer_treasure_chest"), "main");
    private final ModelPart bottom;
    private final ModelPart lid;

    public EnforcerTreasureChestBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart root = context.m_173582_(LAYER_LOCATION);
        this.bottom = root.m_171324_("bottom");
        this.lid = root.m_171324_("lid");
    }

    public static LayerDefinition createBoxLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition bottom = partdefinition.m_171599_("bottom", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)18.0f, (float)0.0f, (float)-3.1416f, (float)0.0f, (float)3.1416f));
        PartDefinition lid = partdefinition.m_171599_("lid", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)24.0f, (float)0.0f, (float)3.1416f, (float)0.0f, (float)3.1416f));
        PartDefinition head_r1 = lid.m_171599_("head_r1", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, 0.0f, 0.0f, 8.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-10.0f, (float)-5.0f, (float)2.5744f, (float)0.0f, (float)3.1416f));
        PartDefinition cube_r1 = lid.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(1.75f)).m_171514_(0, 16).m_171488_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(1.0f)), PartPose.m_171423_((float)0.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void render(T blockEntity, float partialTicks, @NotNull PoseStack stack, @NotNull MultiBufferSource bufferSource, int light, int overlay) {
        BlockState blockState;
        Direction direction = Direction.UP;
        if (blockEntity.m_58904_() != null && (blockState = blockEntity.m_58904_().m_8055_(blockEntity.m_58899_())).m_60734_() instanceof EnforcerTreasureChestBlock) {
            direction = (Direction)blockState.m_61143_((Property)EnforcerTreasureChestBlock.f_56183_);
        }
        stack.m_85836_();
        stack.m_252880_(0.5f, 0.5f, 0.5f);
        float g = 0.9995f;
        stack.m_85841_(g, g, g);
        float d = direction.m_122435_();
        stack.m_252781_(Axis.f_252436_.m_252977_(-d));
        stack.m_85841_(1.0f, -1.0f, -1.0f);
        stack.m_252880_(0.0f, -1.0f, 0.0f);
        ModelPart modelPart = this.getLid();
        modelPart.m_104227_(0.0f, 24.0f - blockEntity.m_59657_(partialTicks) * 0.5f * 16.0f, 0.0f);
        modelPart.f_104204_ = 270.0f * blockEntity.m_59657_(partialTicks) * ((float)Math.PI / 180);
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"hadean_breathe", (String)"textures/block/enforcer_treasure_chest.png")));
        this.getLid().m_104306_(stack, vertexConsumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
        this.getBottom().m_104306_(stack, vertexConsumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
        stack.m_85849_();
    }

    public ModelPart getBottom() {
        return this.bottom;
    }

    public ModelPart getLid() {
        return this.lid;
    }
}

